/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.utilities;

import ee.jakarta.tck.data.framework.utilities.DatabaseType;
import ee.jakarta.tck.data.framework.utilities.TestPropertyHandler;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.logging.Logger;

public enum TestProperty {
    javaHome(true, "java.home", "Path to the java executable used to create the current JVM"),
    javaSpecVer(true, "java.specification.version", "Specification version of the java executable"),
    javaTempDir(true, "java.io.tmpdir", "The path to a temporary directory where a copy of the signature file will be created"),
    javaVer(true, "java.version", "Full version of the java executable"),
    skipDeployment(false, "jakarta.tck.skip.deployment", "If true, run in SE mode and do not use Arquillian deployment, if false run in EE mode and use Arquillian deployments. Default: false", "false"),
    pollFrequency(false, "jakarta.tck.poll.frequency", "Time in seconds between polls of the repository to verify read-only data was successfully written. Default: 1 second", "1"),
    pollTimeout(false, "jakarta.tck.poll.timeout", "Time in seconds when we will stop polling to verify read-only data was successfully written. Default: 60 seconds", "60"),
    delay(false, "jakarta.tck.consistency.delay", "Time in seconds after verifying read-only data was successfully written to respository for repository to have consistency. Default: none"),
    databaseType(false, "jakarta.tck.database.type", "The type of database being used. Valid values are " + Arrays.asList(DatabaseType.values()).toString() + " (case insensitive). The database type is used to make assertions based on the keywords supported by the underlying database. Default: OTHER", "OTHER"),
    databaseName(false, "jakarta.tck.database.name", "The name of database being used. The database name is used to make assertions based on the underlying database. Default: none"),
    signatureClasspath(false, "signature.sigTestClasspath", "The path to the Jakarta Data API JAR used by your implementation. Required for standalone testing, but optional when testing on a Jakarta EE profile. Default: none"),
    signatureImageDir(true, "jimage.dir", "The path to a directory that is readable and writable that the signature test will cache Java SE modules as classes. Default: none");

    private boolean required;
    private String key;
    private String value;
    private String description;

    private TestProperty(boolean required, String key, String description) {
        this(required, key, description, null);
    }

    private TestProperty(boolean required, String key, String description, String defaultValue) {
        this.required = required;
        this.key = key;
        this.description = description;
        this.value = this.getValue(defaultValue);
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(String expectedValue) {
        return this.getValue().equalsIgnoreCase(expectedValue);
    }

    public boolean isSet() {
        if (this.value == null) {
            return false;
        }
        return !this.value.isBlank() && !this.value.isEmpty();
    }

    public long getLong() throws IllegalStateException, NumberFormatException {
        return Long.parseLong(this.value);
    }

    public int getInt() throws IllegalStateException, NumberFormatException {
        return Integer.parseInt(this.value);
    }

    public boolean getBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.valueOfIgnoreCase(this.value);
    }

    public String getValue() {
        if (this.required && this.value == null) {
            throw new IllegalStateException("Could not obtain a value for system property: " + this.key);
        }
        return this.value;
    }

    private String getValue(String defaultVal) throws IllegalStateException {
        Logger log = Logger.getLogger(TestProperty.class.getCanonicalName());
        String valueLocal = null;
        log.fine("Searching for property: " + this.key);
        if (valueLocal == null) {
            valueLocal = System.getProperty(this.key);
            log.fine("Value from system: " + valueLocal);
        }
        if (valueLocal == null) {
            valueLocal = TestPropertyHandler.loadProperties().getProperty(this.key);
            log.fine("Value from resource file: " + valueLocal);
        }
        if (valueLocal == null) {
            valueLocal = defaultVal;
            log.fine("Value set to default: " + valueLocal);
        }
        if (valueLocal == null) {
            log.fine((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Property was not set, value: null"})));
        }
        return valueLocal;
    }
}

