/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.unwrapping;

import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.UnexpectedTypeException;
import javax.validation.Validator;
import javax.validation.constraints.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ValidateUnwrappedValue;
import javax.validation.valueextraction.ExtractedValue;
import javax.validation.valueextraction.UnwrapByDefault;
import javax.validation.valueextraction.Unwrapping;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.unwrapping.model.IntegerWrapper;
import org.hibernate.beanvalidation.tck.tests.valueextraction.unwrapping.model.UnwrapByDefaultIntegerWrapperValueExtractor;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValueExtractionUnwrappingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValueExtractionUnwrappingTest.webArchiveBuilder().withTestClass(ValueExtractionUnwrappingTest.class)).withPackage(IntegerWrapper.class.getPackage())).build();
    }

    private Validator getValidatorWithoutValueExtractor() {
        return this.getValidator();
    }

    private Validator getValidatorWithValueExtractors() {
        return TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new ValueHolderExtractor()).addValueExtractor((ValueExtractor)new UnwrapByDefaultWrapperValueExtractor()).addValueExtractor((ValueExtractor)new UnwrapByDefaultIntegerWrapperValueExtractor()).buildValidatorFactory().getValidator();
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="b")})
    public void no_constraint_validator_for_unwrapped_value_throws_exception() {
        this.getValidatorWithValueExtractors().validate((Object)new EntityWithNoContraintValidatorForUnwrappedValue(), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="b")
    public void skip_and_unwrap_at_the_same_time_throws_exception() {
        this.getValidatorWithValueExtractors().validate((Object)new EntityWithSkipAndUnwrapAtTheSameTime(), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c")
    public void missing_value_extractor_throws_exception() {
        this.getValidatorWithoutValueExtractor().validate((Object)new EntityWithExplicitUnwrapping(), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_wrapped_value_if_explicit_unwrapping() {
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)new EntityWithExplicitUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withProperty("integerHolder").withInvalidValue(5));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void validate_wrapper_itself_if_there_is_no_unwrapping() {
        EntityWithNoUnwrapping entity = new EntityWithNoUnwrapping();
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)entity, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Null.class).withProperty("integerHolder").withInvalidValue(entity.integerHolder));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="d"), @SpecAssertion(section="valueextractordefinition-unwrapbydefault", id="a"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_wrapped_value_if_value_extractor_unwraps_by_default_for_generic_container() {
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)new WrapperWithImplicitUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withProperty("integerWrapper").withInvalidValue(5));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="a"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void validate_wrapper_if_unwrapping_disabled_per_constraint_for_generic_container() {
        WrapperWithDisabledUnwrapping entity = new WrapperWithDisabledUnwrapping();
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)entity, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Null.class).withProperty("integerWrapper").withInvalidValue(entity.integerWrapper));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_wrapped_value_if_value_extractor_unwraps_by_default_and_unwrapping_enabled_per_constraint_for_generic_container() {
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)new WrapperWithForcedUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withProperty("integerWrapper").withInvalidValue(5));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="d"), @SpecAssertion(section="valueextractordefinition-unwrapbydefault", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_wrapped_value_if_value_extractor_unwraps_by_default_for_non_generic_container() {
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)new IntegerWrapperWithImplicitUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("integerWrapper").containerElement("wrapper", false, null, null, IntegerWrapper.class, null)).withInvalidValue(5));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void validate_wrapper_if_unwrapping_disabled_per_constraint_for_non_generic_container() {
        IntegerWrapperWithDisabledUnwrapping entity = new IntegerWrapperWithDisabledUnwrapping();
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)entity, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Null.class).withProperty("integerWrapper").withInvalidValue(entity.integerWrapper));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints-implicitunwrapping", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="d"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_wrapped_value_if_value_extractor_unwraps_by_default_and_unwrapping_enabled_per_constraint_for_non_generic_container() {
        Set constraintViolations = this.getValidatorWithValueExtractors().validate((Object)new IntegerWrapperWithForcedUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("integerWrapper").containerElement("wrapper", false, null, null, IntegerWrapper.class, null)).withInvalidValue(5));
    }

    @Test
    @SpecAssertion(section="constraintmetadata-constraintdescriptor", id="p")
    public void validateUnwrappedValue_returns_correct_values() {
        Validator validator = this.getValidatorWithValueExtractors();
        ConstraintDescriptor minConstraintDescriptor = (ConstraintDescriptor)validator.getConstraintsForClass(WrapperWithImplicitUnwrapping.class).getConstraintsForProperty("integerWrapper").getConstraintDescriptors().iterator().next();
        Assert.assertEquals(minConstraintDescriptor.getAnnotation().annotationType(), Min.class);
        Assert.assertEquals((Object)minConstraintDescriptor.getValueUnwrapping(), (Object)ValidateUnwrappedValue.DEFAULT);
        minConstraintDescriptor = (ConstraintDescriptor)validator.getConstraintsForClass(WrapperWithDisabledUnwrapping.class).getConstraintsForProperty("integerWrapper").getConstraintDescriptors().iterator().next();
        Assert.assertEquals(minConstraintDescriptor.getAnnotation().annotationType(), Null.class);
        Assert.assertEquals((Object)minConstraintDescriptor.getValueUnwrapping(), (Object)ValidateUnwrappedValue.SKIP);
        minConstraintDescriptor = (ConstraintDescriptor)validator.getConstraintsForClass(WrapperWithForcedUnwrapping.class).getConstraintsForProperty("integerWrapper").getConstraintDescriptors().iterator().next();
        Assert.assertEquals(minConstraintDescriptor.getAnnotation().annotationType(), Min.class);
        Assert.assertEquals((Object)minConstraintDescriptor.getValueUnwrapping(), (Object)ValidateUnwrappedValue.UNWRAP);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_implicit_unwrapping_having_two_type_parameters_and_only_one_maximally_specific_value_extractor_is_ok() {
        Validator validator = TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new UnwrapByDefaultWrapperWithTwoTypeArgumentsFirstValueExtractor()).buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)new BeanWithWrapperWithTwoTypeArguments(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("first", false, null, null, WrapperWithTwoTypeArguments.class, 0)).withInvalidValue(5L));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_implicit_unwrapping_having_two_type_parameters_and_only_one_maximally_specific_value_extractor_marked_with_unwrap_by_default_is_ok() {
        Validator validator = TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new UnwrapByDefaultWrapperWithTwoTypeArgumentsFirstValueExtractor()).addValueExtractor((ValueExtractor)new WrapperWithTwoTypeArgumentsSecondValueExtractor()).buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)new BeanWithWrapperWithTwoTypeArguments(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("first", false, null, null, WrapperWithTwoTypeArguments.class, 0)).withInvalidValue(5L));
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c")
    public void validate_implicit_unwrapping_having_two_type_parameters_and_two_maximally_specific_value_extractors_marked_with_unwrap_by_default_raises_exception() {
        Validator validator = TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new UnwrapByDefaultWrapperWithTwoTypeArgumentsFirstValueExtractor()).addValueExtractor((ValueExtractor)new UnwrapByDefaultWrapperWithTwoTypeArgumentsSecondValueExtractor()).buildValidatorFactory().getValidator();
        validator.validate((Object)new BeanWithWrapperWithTwoTypeArguments(), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_forced_unwrapping_having_two_type_parameters_and_only_one_maximally_specific_value_extractor_is_ok() {
        Validator validator = TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new WrapperWithTwoTypeArgumentsFirstValueExtractor()).buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)new BeanWithWrapperWithTwoTypeArgumentsAndForcedUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("first", false, null, null, WrapperWithTwoTypeArguments.class, 0)).withInvalidValue(5L));
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c")
    public void validate_forced_unwrapping_having_two_type_parameters_and_two_maximally_specific_value_extractors_raises_exception() {
        Validator validator = TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new WrapperWithTwoTypeArgumentsFirstValueExtractor()).addValueExtractor((ValueExtractor)new WrapperWithTwoTypeArgumentsSecondValueExtractor()).buildValidatorFactory().getValidator();
        validator.validate((Object)new BeanWithWrapperWithTwoTypeArgumentsAndForcedUnwrapping(), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-implicitunwrapping", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="k")})
    public void validate_forced_unwrapping_having_two_reverted_type_parameters_correctly_identifies_type_parameter() {
        Validator validator = TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new WrapperWithTwoTypeArgumentsSecondValueExtractor()).buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)new BeanWithWrapperWithRevertedTwoTypeArgumentsAndForcedUnwrapping(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("second", false, null, null, WrapperWithRevertedTwoTypeArguments.class, 0)).withInvalidValue(5L));
    }

    private class WrapperWithTwoTypeArgumentsSecondValueExtractor
    implements ValueExtractor<WrapperWithTwoTypeArguments<?, ?>> {
        private WrapperWithTwoTypeArgumentsSecondValueExtractor() {
        }

        public void extractValues(WrapperWithTwoTypeArguments<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("second", ((WrapperWithTwoTypeArguments)originalValue).value2);
        }
    }

    private class WrapperWithTwoTypeArgumentsFirstValueExtractor
    implements ValueExtractor<WrapperWithTwoTypeArguments<?, ?>> {
        private WrapperWithTwoTypeArgumentsFirstValueExtractor() {
        }

        public void extractValues(WrapperWithTwoTypeArguments<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("first", ((WrapperWithTwoTypeArguments)originalValue).value1);
        }
    }

    @UnwrapByDefault
    private class UnwrapByDefaultWrapperWithTwoTypeArgumentsSecondValueExtractor
    implements ValueExtractor<WrapperWithTwoTypeArguments<?, ?>> {
        private UnwrapByDefaultWrapperWithTwoTypeArgumentsSecondValueExtractor() {
        }

        public void extractValues(WrapperWithTwoTypeArguments<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("second", ((WrapperWithTwoTypeArguments)originalValue).value2);
        }
    }

    @UnwrapByDefault
    private class UnwrapByDefaultWrapperWithTwoTypeArgumentsFirstValueExtractor
    implements ValueExtractor<WrapperWithTwoTypeArguments<?, ?>> {
        private UnwrapByDefaultWrapperWithTwoTypeArgumentsFirstValueExtractor() {
        }

        public void extractValues(WrapperWithTwoTypeArguments<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("first", ((WrapperWithTwoTypeArguments)originalValue).value1);
        }
    }

    @UnwrapByDefault
    private class UnwrapByDefaultWrapperValueExtractor
    implements ValueExtractor<Wrapper<?>> {
        private UnwrapByDefaultWrapperValueExtractor() {
        }

        public void extractValues(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @ExtractedValue Wrapper<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, ((Wrapper)originalValue).value);
        }
    }

    private class ValueHolderExtractor
    implements ValueExtractor<ValueHolder<?>> {
        private ValueHolderExtractor() {
        }

        public void extractValues(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @ExtractedValue ValueHolder<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, ((ValueHolder)originalValue).value);
        }
    }

    private class WrapperWithRevertedTwoTypeArguments<V, W>
    extends WrapperWithTwoTypeArguments<W, V> {
        private WrapperWithRevertedTwoTypeArguments(V value1, W value2) {
            super(value2, value1);
        }
    }

    private class WrapperWithTwoTypeArguments<T, U> {
        private final T value1;
        private final U value2;

        private WrapperWithTwoTypeArguments(T value1, U value2) {
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    private class Wrapper<T> {
        private final T value;

        private Wrapper(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    private class ValueHolder<T> {
        private final T value;

        private ValueHolder(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    private class BeanWithWrapperWithRevertedTwoTypeArgumentsAndForcedUnwrapping {
        @Min(value=10L, payload={Unwrapping.Unwrap.class})
        private final @Min(value=10L, payload={Unwrapping.Unwrap.class}) WrapperWithRevertedTwoTypeArguments<Long, String> wrapper;

        private BeanWithWrapperWithRevertedTwoTypeArgumentsAndForcedUnwrapping() {
            this.wrapper = new WrapperWithRevertedTwoTypeArguments(5L, "value");
        }
    }

    private class BeanWithWrapperWithTwoTypeArgumentsAndForcedUnwrapping {
        @Min(value=10L, payload={Unwrapping.Unwrap.class})
        private final @Min(value=10L, payload={Unwrapping.Unwrap.class}) WrapperWithTwoTypeArguments<Long, String> wrapper;

        private BeanWithWrapperWithTwoTypeArgumentsAndForcedUnwrapping() {
            this.wrapper = new WrapperWithTwoTypeArguments(5L, "value");
        }
    }

    private class BeanWithWrapperWithTwoTypeArguments {
        @Min(value=10L)
        private final @Min(value=10L) WrapperWithTwoTypeArguments<Long, String> wrapper;

        private BeanWithWrapperWithTwoTypeArguments() {
            this.wrapper = new WrapperWithTwoTypeArguments(5L, "value");
        }
    }

    private class IntegerWrapperWithForcedUnwrapping {
        @Min(value=10L, payload={Unwrapping.Unwrap.class})
        private final @Min(value=10L, payload={Unwrapping.Unwrap.class}) IntegerWrapper integerWrapper = new IntegerWrapper(5);

        private IntegerWrapperWithForcedUnwrapping() {
        }
    }

    private class IntegerWrapperWithDisabledUnwrapping {
        @Null(payload={Unwrapping.Skip.class})
        private final IntegerWrapper integerWrapper = new IntegerWrapper(5);

        private IntegerWrapperWithDisabledUnwrapping() {
        }
    }

    private class IntegerWrapperWithImplicitUnwrapping {
        @Min(value=10L)
        private final @Min(value=10L) IntegerWrapper integerWrapper = new IntegerWrapper(5);

        private IntegerWrapperWithImplicitUnwrapping() {
        }
    }

    private class WrapperWithForcedUnwrapping {
        @Min(value=10L, payload={Unwrapping.Unwrap.class})
        private final @Min(value=10L, payload={Unwrapping.Unwrap.class}) Wrapper<Integer> integerWrapper;

        private WrapperWithForcedUnwrapping() {
            this.integerWrapper = new Wrapper(5);
        }
    }

    private class WrapperWithDisabledUnwrapping {
        @Null(payload={Unwrapping.Skip.class})
        private final Wrapper<Integer> integerWrapper;

        private WrapperWithDisabledUnwrapping() {
            this.integerWrapper = new Wrapper(5);
        }
    }

    private class WrapperWithImplicitUnwrapping {
        @Min(value=10L)
        private final @Min(value=10L) Wrapper<Integer> integerWrapper;

        private WrapperWithImplicitUnwrapping() {
            this.integerWrapper = new Wrapper(5);
        }
    }

    private class EntityWithNoUnwrapping {
        @Null
        private final ValueHolder<Integer> integerHolder;

        private EntityWithNoUnwrapping() {
            this.integerHolder = new ValueHolder(5);
        }
    }

    private class EntityWithExplicitUnwrapping {
        @Min(value=10L, payload={Unwrapping.Unwrap.class})
        private final @Min(value=10L, payload={Unwrapping.Unwrap.class}) ValueHolder<Integer> integerHolder;

        private EntityWithExplicitUnwrapping() {
            this.integerHolder = new ValueHolder(5);
        }
    }

    private class EntityWithNoContraintValidatorForUnwrappedValue {
        @Future(payload={Unwrapping.Unwrap.class})
        private final ValueHolder<Integer> integerHolder;

        private EntityWithNoContraintValidatorForUnwrappedValue() {
            this.integerHolder = new ValueHolder(5);
        }
    }

    private class EntityWithSkipAndUnwrapAtTheSameTime {
        @NotNull(payload={Unwrapping.Unwrap.class, Unwrapping.Skip.class})
        private final ValueHolder<Integer> integerHolder;

        private EntityWithSkipAndUnwrapAtTheSameTime() {
            this.integerHolder = new ValueHolder(5);
        }
    }
}

