/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ContainerElementConstraintMapKeyTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementConstraintMapKeyTest.webArchiveBuilder().withTestClass(ContainerElementConstraintMapKeyTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraint_specified_on_key_type_parameter_of_map_gets_validated() {
        TypeWithMap1 m = new TypeWithMap1();
        m.nameMap = new HashMap();
        m.nameMap.put("first", "Name 1");
        m.nameMap.put("", "Name 2");
        m.nameMap.put("third", "Name 3");
        Set constraintViolations = this.getValidator().validate((Object)m, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("nameMap").containerElement("<map key>", true, "", null, Map.class, 0)).withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraints_specified_on_map_and_on_key_type_parameter_of_map_get_validated() {
        TypeWithMap2 m = new TypeWithMap2();
        m.nameMap = new HashMap();
        m.nameMap.put("first", "Name 1");
        m.nameMap.put("", "Name 2");
        m.nameMap.put("third", "Name 3");
        Set constraintViolations = this.getValidator().validate((Object)m, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("nameMap").containerElement("<map key>", true, "", null, Map.class, 0)).withInvalidValue(""));
        m = new TypeWithMap2();
        constraintViolations = this.getValidator().validate((Object)m, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("nameMap").withInvalidValue(m.nameMap));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void getter_constraint_provided_on_key_type_parameter_of_a_map_gets_validated() {
        TypeWithMap3 m = new TypeWithMap3();
        m.stringMap = new HashMap();
        m.stringMap.put("", "First");
        m.stringMap.put("second", "Second");
        m.stringMap.put(null, "Third");
        Set constraintViolations = this.getValidator().validate((Object)m, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("stringMap").containerElement("<map key>", true, "", null, Map.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("stringMap").containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("stringMap").containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void return_value_constraint_provided_on_key_type_parameter_of_a_map_gets_validated() throws Exception {
        Method method = TypeWithMap4.class.getDeclaredMethod("returnStringMap", new Class[0]);
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("first", "First");
        parameter.put("", "Second");
        parameter.put(null, "Third");
        Set constraintViolations = this.getValidator().forExecutables().validateReturnValue((Object)new TypeWithMap4(), method, parameter, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStringMap").returnValue().containerElement("<map key>", true, "", null, Map.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStringMap").returnValue().containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStringMap").returnValue().containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void method_parameter_constraint_provided_as_key_type_parameter_of_a_map_gets_validated() throws Exception {
        Method method = TypeWithMap5.class.getDeclaredMethod("setValues", Map.class);
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("first", "First");
        parameter.put("", "Second");
        parameter.put(null, "Third");
        Object[] values = new Object[]{parameter};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)new TypeWithMap5(), method, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("mapParameter", 0).containerElement("<map key>", true, "", null, Map.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("mapParameter", 0).containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("mapParameter", 0).containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constructor_parameter_constraint_provided_on_key_type_parameter_of_a_map_gets_validated() throws Exception {
        Constructor constructor = TypeWithMap6.class.getDeclaredConstructor(Map.class);
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("first", "First");
        parameter.put("", "Second");
        parameter.put(null, "Third");
        Object[] values = new Object[]{parameter};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithMap6.class).parameter("mapParameter", 0).containerElement("<map key>", true, "", null, Map.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithMap6.class).parameter("mapParameter", 0).containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithMap6.class).parameter("mapParameter", 0).containerElement("<map key>", true, null, null, Map.class, 0)).withInvalidValue(null));
    }

    private static class TypeWithMap6 {
        public TypeWithMap6(Map<@NotNull @NotBlank String, String> mapParameter) {
        }
    }

    private static class TypeWithMap5 {
        private TypeWithMap5() {
        }

        public void setValues(Map<@NotNull @NotBlank String, String> mapParameter) {
        }
    }

    private static class TypeWithMap4 {
        private Map<String, String> stringMap;

        private TypeWithMap4() {
        }

        public Map<@NotNull @NotBlank String, String> returnStringMap() {
            return this.stringMap;
        }
    }

    private static class TypeWithMap3 {
        private Map<String, String> stringMap;

        private TypeWithMap3() {
        }

        public Map<@NotNull @NotBlank String, String> getStringMap() {
            return this.stringMap;
        }
    }

    private static class TypeWithMap2 {
        private @NotNull Map<@NotBlank String, String> nameMap;

        private TypeWithMap2() {
        }
    }

    private static class TypeWithMap1 {
        private Map<@NotBlank String, String> nameMap;

        private TypeWithMap1() {
        }
    }
}

