/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.core.api.event.ManagerStopping;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.arquillian.core.impl.EventContextImpl;
import org.jboss.arquillian.core.impl.EventImpl;
import org.jboss.arquillian.core.impl.ExtensionImpl;
import org.jboss.arquillian.core.impl.InjectorImpl;
import org.jboss.arquillian.core.impl.InstanceImpl;
import org.jboss.arquillian.core.impl.Reflections;
import org.jboss.arquillian.core.impl.SecurityActions;
import org.jboss.arquillian.core.impl.UncheckedThrow;
import org.jboss.arquillian.core.impl.context.ApplicationContextImpl;
import org.jboss.arquillian.core.impl.threading.ThreadedExecutorService;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.EventPoint;
import org.jboss.arquillian.core.spi.Extension;
import org.jboss.arquillian.core.spi.InjectionPoint;
import org.jboss.arquillian.core.spi.InvocationException;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.NonManagedObserver;
import org.jboss.arquillian.core.spi.ObserverMethod;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.core.spi.context.ApplicationContext;
import org.jboss.arquillian.core.spi.context.Context;
import org.jboss.arquillian.core.spi.context.ObjectStore;
import org.jboss.arquillian.core.spi.event.ManagerProcessing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerImpl
implements Manager {
    public static final String ARQUILLIAN_DEBUG_PROPERTY = "arquillian.debug";
    public static Boolean DEBUG = Boolean.valueOf(SecurityActions.getProperty("arquillian.debug"));
    private ThreadLocal<Stack<Object>> eventStack;
    private ThreadLocal<Set<Class<? extends Throwable>>> handledThrowables = new ThreadLocal<Set<Class<? extends Throwable>>>(){

        @Override
        protected Set<Class<? extends Throwable>> initialValue() {
            return new HashSet<Class<? extends Throwable>>();
        }
    };
    private final List<Context> contexts = new ArrayList<Context>();
    private final List<Extension> extensions = new ArrayList<Extension>();

    ManagerImpl(Collection<Class<? extends Context>> contextClasses, Collection<Class<?>> extensionClasses) {
        try {
            List<Extension> createdExtensions = this.createExtensions(extensionClasses);
            List<Context> createdContexts = this.createContexts(contextClasses);
            this.createBuiltInServices();
            this.contexts.addAll(createdContexts);
            this.extensions.addAll(createdExtensions);
            this.addContextsToApplicationScope();
            this.fireProcessing();
            this.addContextsToApplicationScope();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create and process manager", e);
        }
    }

    public void fire(Object event) {
        this.fire(event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void fire(T event, NonManagedObserver<T> nonManagedObserver) {
        Validate.notNull(event, (String)"Event must be specified");
        this.debug(event, true);
        this.handledThrowables.get().clear();
        List<ObserverMethod> observers = this.resolveObservers(event.getClass());
        List<ObserverMethod> interceptorObservers = this.resolveInterceptorObservers(event.getClass());
        ApplicationContext context = (ApplicationContext)this.getScopedContext(ApplicationScoped.class);
        boolean activatedApplicationContext = false;
        try {
            if (!context.isActive()) {
                context.activate();
                activatedApplicationContext = true;
            }
            new EventContextImpl<T>(this, interceptorObservers, observers, nonManagedObserver, event).proceed();
        }
        catch (Exception e) {
            Throwable fireException = e;
            if (fireException instanceof InvocationException) {
                fireException = fireException.getCause();
            }
            if (this.handledThrowables.get().contains(fireException.getClass())) {
                UncheckedThrow.throwUnchecked(fireException);
            } else {
                this.fireException(fireException);
            }
        }
        finally {
            this.debug(event, false);
            if (activatedApplicationContext && context.isActive()) {
                context.deactivate();
            }
        }
    }

    public <T> void bind(Class<? extends Annotation> scope, Class<T> type, T instance) {
        Validate.notNull(scope, (String)"Scope must be specified");
        Validate.notNull(type, (String)"Type must be specified");
        Validate.notNull(instance, (String)"Instance must be specified");
        Context scopedContext = this.getScopedContext(scope);
        if (scopedContext == null) {
            throw new IllegalArgumentException("No Context registered with support for scope: " + scope);
        }
        if (!scopedContext.isActive()) {
            throw new IllegalArgumentException("No active " + scope.getSimpleName() + " Context to bind to");
        }
        scopedContext.getObjectStore().add(type, instance);
    }

    public <T> T resolve(Class<T> type) {
        Validate.notNull(type, (String)"Type must be specified");
        List<Context> activeContexts = this.resolveActiveContexts();
        for (int i = activeContexts.size() - 1; i >= 0; --i) {
            Context context = activeContexts.get(i);
            Object object = context.getObjectStore().get(type);
            if (object == null) continue;
            return (T)object;
        }
        return null;
    }

    public void inject(Object obj) {
        this.inject(ExtensionImpl.of(obj));
    }

    public <T> T getContext(Class<T> type) {
        for (Context context : this.contexts) {
            if (!type.isInstance(context)) continue;
            return type.cast(context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeInApplicationContext(Callable<T> callable) throws Exception {
        ApplicationContext context = (ApplicationContext)this.getScopedContext(ApplicationScoped.class);
        boolean activatedByUs = false;
        try {
            if (!context.isActive()) {
                context.activate();
                activatedByUs = true;
            }
            T t = callable.call();
            return t;
        }
        finally {
            if (activatedByUs && context.isActive()) {
                context.deactivate();
            }
        }
    }

    public List<Context> getContexts() {
        return Collections.unmodifiableList(this.contexts);
    }

    public <T> void bindAndFire(Class<? extends Annotation> scope, Class<T> type, T instance) {
        this.bind(scope, type, instance);
        this.fire(instance);
    }

    public <T> T getExtension(Class<T> type) {
        for (Extension extension : this.extensions) {
            Object target = ((ExtensionImpl)extension).getTarget();
            if (!type.isInstance(target)) continue;
            return type.cast(target);
        }
        return null;
    }

    public void start() {
        this.fire(new ManagerStarted());
        this.getContext(ApplicationContext.class).activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Exception shutdownException = null;
        try {
            this.fire(new ManagerStopping());
        }
        catch (Exception e) {
            try {
                this.fireException(e);
            }
            catch (Exception e2) {
                shutdownException = e2;
            }
        }
        ManagerImpl managerImpl = this;
        synchronized (managerImpl) {
            for (Context context : this.contexts) {
                context.clearAll();
            }
            this.contexts.clear();
            this.extensions.clear();
            if (this.eventStack != null) {
                this.eventStack.remove();
            }
            this.handledThrowables.remove();
        }
        if (shutdownException != null) {
            UncheckedThrow.throwUnchecked(shutdownException);
        }
    }

    public void fireProcessing() throws Exception {
        final HashSet extensions = new HashSet();
        final HashSet<Class<? extends Context>> contexts = new HashSet<Class<? extends Context>>();
        this.fire(new ManagerProcessing(){

            public ManagerProcessing observer(Class<?> observer) {
                if (extensions.contains(observer)) {
                    throw new IllegalArgumentException("Attempted to register the same Observer: " + observer.getName() + " multiple times, please check classpath for conflicting jar versions");
                }
                extensions.add(observer);
                return this;
            }

            public ManagerProcessing context(Class<? extends Context> context) {
                if (contexts.contains(context)) {
                    throw new IllegalArgumentException("Attempted to register the same " + Context.class.getSimpleName() + " : " + context.getName() + " multiple times, please check classpath for conflicting jar versions");
                }
                contexts.add(context);
                return this;
            }
        });
        this.extensions.addAll(this.createExtensions(extensions));
        this.contexts.addAll(this.createContexts(contexts));
    }

    boolean isExceptionHandled(Throwable e) {
        return this.handledThrowables.get().contains(e.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireException(Throwable event) {
        this.debug(event, true);
        try {
            List<ObserverMethod> observers = this.resolveObservers(event.getClass());
            if (observers.size() == 0) {
                UncheckedThrow.throwUnchecked(event);
            }
            for (int i = 0; i < observers.size(); ++i) {
                ObserverMethod observer = observers.get(i);
                try {
                    this.debug(observer, false);
                    observer.invoke((Manager)this, (Object)event);
                    continue;
                }
                catch (Exception e) {
                    Throwable toBeFired = e.getCause();
                    if (toBeFired.getClass() == event.getClass()) {
                        if (i != observers.size() - 1) continue;
                        this.handledThrowables.get().add(toBeFired.getClass());
                        UncheckedThrow.throwUnchecked(toBeFired);
                        continue;
                    }
                    this.fireException(toBeFired);
                }
            }
        }
        finally {
            this.debug(event, false);
        }
    }

    private List<Extension> createExtensions(Collection<Class<?>> extensionClasses) throws Exception {
        ArrayList<Extension> created = new ArrayList<Extension>();
        for (Class<?> extensionClass : extensionClasses) {
            ExtensionImpl extension = ExtensionImpl.of(Reflections.createInstance(extensionClass));
            this.inject(extension);
            created.add(extension);
        }
        return created;
    }

    private List<Context> createContexts(Collection<Class<? extends Context>> contextClasses) throws Exception {
        ArrayList<Context> created = new ArrayList<Context>();
        for (Class<? extends Context> contextClass : contextClasses) {
            created.add(Reflections.createInstance(contextClass));
        }
        return created;
    }

    private void createBuiltInServices() throws Exception {
        ApplicationContextImpl context = new ApplicationContextImpl();
        this.contexts.add((Context)context);
        this.executeInApplicationContext(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ManagerImpl.this.bind(ApplicationScoped.class, Injector.class, InjectorImpl.of(ManagerImpl.this));
                ManagerImpl.this.bind(ApplicationScoped.class, ExecutorService.class, new ThreadedExecutorService(ManagerImpl.this));
                return null;
            }
        });
    }

    private void addContextsToApplicationScope() throws Exception {
        this.executeInApplicationContext(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ApplicationContext appContext = ManagerImpl.this.getContext(ApplicationContext.class);
                ObjectStore store = appContext.getObjectStore();
                for (Context context : ManagerImpl.this.contexts) {
                    store.add(context.getClass().getInterfaces()[0], (Object)context);
                }
                return null;
            }
        });
    }

    private List<ObserverMethod> resolveObservers(Class<?> eventType) {
        ArrayList<ObserverMethod> observers = new ArrayList<ObserverMethod>();
        for (Extension extension : this.extensions) {
            for (ObserverMethod observer : extension.getObservers()) {
                if (!Reflections.getType(observer.getType()).isAssignableFrom(eventType) || Reflections.isType(observer.getType(), EventContext.class)) continue;
                observers.add(observer);
            }
        }
        Collections.sort(observers);
        return observers;
    }

    private List<ObserverMethod> resolveInterceptorObservers(Class<?> eventType) {
        ArrayList<ObserverMethod> observers = new ArrayList<ObserverMethod>();
        for (Extension extension : this.extensions) {
            for (ObserverMethod observer : extension.getObservers()) {
                if (!Reflections.isType(observer.getType(), EventContext.class) || !Reflections.getType(observer.getType()).isAssignableFrom(eventType)) continue;
                observers.add(observer);
            }
        }
        Collections.sort(observers);
        return observers;
    }

    private List<Context> resolveActiveContexts() {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : this.contexts) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        return activeContexts;
    }

    private void inject(Extension extension) {
        this.injectInstances(extension);
        this.injectEvents(extension);
    }

    private void injectInstances(Extension extension) {
        for (InjectionPoint point : extension.getInjectionPoints()) {
            point.set(InstanceImpl.of(Reflections.getType(point.getType()), point.getScope(), this));
        }
    }

    private void injectEvents(Extension extension) {
        for (EventPoint point : extension.getEventPoints()) {
            point.set(EventImpl.of(Reflections.getType(point.getType()), this));
        }
    }

    private Context getScopedContext(Class<? extends Annotation> scope) {
        for (Context context : this.contexts) {
            if (context.getScope() != scope) continue;
            return context;
        }
        return null;
    }

    void debug(ObserverMethod method, boolean interceptor) {
        if (DEBUG.booleanValue()) {
            System.out.println(this.calcDebugPrefix() + "(" + (interceptor ? "I" : "O") + ") " + method.getMethod().getDeclaringClass().getSimpleName() + "." + method.getMethod().getName());
        }
    }

    private void debug(Object event, boolean push) {
        if (DEBUG.booleanValue()) {
            if (this.eventStack == null) {
                this.eventStack = new ThreadLocal<Stack<Object>>(){

                    @Override
                    protected Stack<Object> initialValue() {
                        return new Stack<Object>();
                    }
                };
            }
            if (push) {
                System.out.println(this.calcDebugPrefix() + "(E) " + this.getEventName(event));
                this.eventStack.get().push(event);
            } else if (!this.eventStack.get().isEmpty()) {
                this.eventStack.get().pop();
            }
        }
    }

    private String getEventName(Object object) {
        Class<?> eventClass = object.getClass();
        if (eventClass.isAnonymousClass() && eventClass.getInterfaces().length == 1 && !eventClass.getInterfaces()[0].getName().startsWith("java")) {
            return eventClass.getInterfaces()[0].getSimpleName();
        }
        return eventClass.getSimpleName();
    }

    private String calcDebugPrefix() {
        int size = this.eventStack.get().size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }
}

