/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredURLClassLoader
extends URLClassLoader {
    private String regExpFilter;

    public FilteredURLClassLoader(URL[] urls, String regExpFilter) {
        super(urls);
        this.regExpFilter = regExpFilter;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.matches(this.regExpFilter)) {
            URL resource;
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (resource = super.findResource(name.replace('.', '/').concat(".class"))) != null) {
                c = super.findClass(name);
            }
            if (c != null) {
                return c;
            }
        }
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (!name.matches(this.regExpFilter)) {
            url = this.findResource(name);
            if (url == null) {
                url = super.findResource(name);
            }
            if (url != null) {
                return url;
            }
        }
        if ((url = this.getParent().getResource(name)) == null) {
            return super.getResource(name);
        }
        return url;
    }
}

