/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class InjectImplProvidedJobOperatorTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @ParameterizedTest
    @ValueSource(strings={"CDIJobOperatorInjectedBatchlet", "jobOperatorInjectedBatchlet", "com.ibm.jbatch.tck.artifacts.cdi.JobOperatorInjectedBatchlet"})
    public void testCDIJobOperatorInject(String refName) throws Exception {
        String METHOD = "testCDIJobOperatorInject";
        String tckAppProvidedJobOperatorClassNameFromOtherTest = "com.ibm.jbatch.tck.cdi.jobop.TCKJobOperatorWrapper";
        try {
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_beans", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            String expectedExitStatus = Long.toString(jobExec.getExecutionId());
            Assertions.assertEquals((Object)expectedExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected exit status");
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            Assertions.assertEquals((int)1, (int)steps.size(), (String)"Wrong number of step executions found");
            Assertions.assertNotEquals((Object)tckAppProvidedJobOperatorClassNameFromOtherTest, (Object)steps.get(0).getExitStatus(), (String)"Wrong JobOperator impl class found");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            InjectImplProvidedJobOperatorTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

