/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import java.util.logging.Logger;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="overrideOnAttributeValuesUponRestartBatchlet")
public class OverrideOnAttributeValuesUponRestartBatchlet
extends AbstractBatchlet {
    private static final String sourceClass = OverrideOnAttributeValuesUponRestartBatchlet.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    @Inject
    StepContext stepCtx;
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="execution.number")
    String executionNumberString;
    int execNum;
    String stepName;

    public String process() throws Exception {
        this.execNum = Integer.parseInt(this.executionNumberString);
        this.stepName = this.stepCtx.getStepName();
        logger.fine("execution # = " + this.execNum + ", step = " + this.stepName);
        String exitStatus = this.calculateExitStatus();
        logger.fine("Exiting with exitStatus = " + exitStatus);
        return exitStatus;
    }

    private String calculateExitStatus() {
        if (this.stepName.equals("step1")) {
            switch (this.execNum) {
                case 1: {
                    return "ES.STEP1";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (this.stepName.equals("step2")) {
            switch (this.execNum) {
                case 2: {
                    return "ES.STEP2";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (this.stepName.equals("step3")) {
            switch (this.execNum) {
                case 3: {
                    return "ES.STEP3";
                }
            }
            return "ILLEGAL.STATE";
        }
        return "ILLEGAL.STATE";
    }

    public void stop() throws Exception {
        logger.fine(sourceClass + ".cancel()");
    }
}

