/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.inner;

import java.io.Serializable;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.partition.AbstractPartitionAnalyzer;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.Assert;

public class ParallelContextPropagationArtifacts {
    public static String GOOD_EXIT_STATUS = "VERY GOOD INVOCATION";

    @Named(value="PCPAnalyzer")
    public static class PCPAnalyzer
    extends AbstractPartitionAnalyzer {
        @Inject
        JobContext jobCtx;

        public void analyzeCollectorData(Serializable data) throws Exception {
            this.jobCtx.setExitStatus(this.jobCtx.getExitStatus() + data);
        }
    }

    @Named(value="PCPCollector")
    public static class PCPCollector
    implements PartitionCollector {
        @Inject
        JobContext jobCtx;
        @Inject
        StepContext stepCtx;

        public String collectPartitionData() throws Exception {
            Assert.assertEquals((String)"step name", (Object)"step1", (Object)this.stepCtx.getStepName());
            long jobid = this.jobCtx.getExecutionId();
            long instanceid = this.jobCtx.getInstanceId();
            long stepid = this.stepCtx.getStepExecutionId();
            return ":J" + jobid + "I" + instanceid + "S" + stepid;
        }
    }

    @Named(value="PCPPartitionBatchlet")
    public static class PCPPartitionBatchlet
    extends AbstractBatchlet {
        @Inject
        JobContext jobCtx;
        @Inject
        StepContext stepCtx;

        public String process() throws Exception {
            String propVal = this.jobCtx.getProperties().getProperty("topLevelJobProperty");
            Assert.assertEquals((String)"Job Property comparison", (Object)"topLevelJobProperty.value", (Object)propVal);
            propVal = this.stepCtx.getProperties().getProperty("topLevelStepProperty");
            Assert.assertEquals((String)"Step Property comparison", (Object)"topLevelStepProperty.value", (Object)propVal);
            Assert.assertEquals((String)"Job name", (Object)"partitionCtxPropagation", (Object)this.jobCtx.getJobName());
            Assert.assertEquals((String)"Step name", (Object)"step1", (Object)this.stepCtx.getStepName());
            return GOOD_EXIT_STATUS;
        }

        public void stop() throws Exception {
        }
    }

    @Named(value="PCPSplitFlowBatchlet")
    public static class PCPSplitFlowBatchlet
    extends AbstractBatchlet {
        @Inject
        JobContext jobCtx;
        @Inject
        StepContext stepCtx;

        public String process() throws Exception {
            String expectedJobName;
            String propVal = this.jobCtx.getProperties().getProperty("topLevelJobProperty");
            String expectedPropVal = "topLevelJobProperty.value";
            if (propVal == null || !propVal.equals(expectedPropVal)) {
                throw new Exception("Expected propVal of " + expectedPropVal + ", but found: " + propVal);
            }
            String jobName = this.jobCtx.getJobName();
            if (!jobName.equals(expectedJobName = "splitFlowCtxPropagation")) {
                throw new Exception("Expected jobName of " + expectedJobName + ", but found: " + jobName);
            }
            String data = this.stepExitStatus();
            return this.stepCtx.getExitStatus() + data;
        }

        private String stepExitStatus() {
            long execId = this.jobCtx.getExecutionId();
            long instanceId = this.jobCtx.getInstanceId();
            long stepExecId = this.stepCtx.getStepExecutionId();
            return ":J" + execId + "I" + instanceId + "S" + stepExecId;
        }
    }
}

