/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;
import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.handly.ui.preference.IPreferenceListener;
import org.eclipse.handly.ui.viewer.ViewerDragSupport;
import org.eclipse.handly.ui.viewer.ViewerDropSupport;
import org.eclipse.ui.PlatformUI;

public abstract class OutlineDragAndDropContribution
extends OutlineContribution {
    private ViewerDropSupport dropSupport;
    private IBooleanPreference lexicalSortPreference;
    private IPreferenceListener lexicalSortPreferenceListener = event -> PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
        if (this.lexicalSortPreference != null) {
            this.dropSupport.setFeedbackEnabled(!this.lexicalSortPreference.getValue());
        }
    });

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        this.createDragSupport().start();
        this.dropSupport = this.createDropSupport();
        this.dropSupport.start();
        this.lexicalSortPreference = outlinePage.getLexicalSortPreference();
        if (this.lexicalSortPreference != null) {
            if (this.lexicalSortPreference.getValue()) {
                this.dropSupport.setFeedbackEnabled(false);
            }
            this.lexicalSortPreference.addListener(this.lexicalSortPreferenceListener);
        }
    }

    @Override
    public void dispose() {
        if (this.lexicalSortPreference != null) {
            this.lexicalSortPreference.removeListener(this.lexicalSortPreferenceListener);
            this.lexicalSortPreference = null;
        }
        super.dispose();
    }

    protected abstract ViewerDragSupport createDragSupport();

    protected abstract ViewerDropSupport createDropSupport();
}

