/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation.util;

import java.util.Map;
import java.util.Optional;
import org.eclipse.glsp.graph.builder.impl.GEdgeBuilder;
import org.eclipse.glsp.graph.builder.impl.GNodeBuilder;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.emf.model.notation.Edge;
import org.eclipse.glsp.server.emf.model.notation.NotationElement;
import org.eclipse.glsp.server.emf.model.notation.Shape;

public final class NotationUtil {
    public static final String DEFAULT_EXTENSION = "notation";

    private NotationUtil() {
    }

    public static boolean isUnresolved(NotationElement notationElement) {
        return notationElement.getSemanticElement() != null && notationElement.getSemanticElement().getResolvedSemanticElement() == null;
    }

    public static GEdgeBuilder applyEdgeData(Edge edge, GEdgeBuilder builder) {
        if (edge.getBendPoints() != null) {
            edge.getBendPoints().stream().map(GraphUtil::copy).forEachOrdered(arg_0 -> ((GEdgeBuilder)builder).addRoutingPoint(arg_0));
        }
        return builder;
    }

    public static GNodeBuilder applyShapeData(Shape shape, GNodeBuilder builder) {
        Optional.ofNullable(shape.getPosition()).map(GraphUtil::copy).ifPresent(arg_0 -> ((GNodeBuilder)builder).position(arg_0));
        Optional.ofNullable(shape.getSize()).map(GraphUtil::copy).ifPresent(newSize -> {
            builder.size(newSize);
            builder.addLayoutOptions(Map.of("prefWidth", newSize.getWidth(), "prefHeight", newSize.getHeight()));
        });
        return builder;
    }
}

