/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.actions;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionHandlerRegistry;
import org.eclipse.glsp.server.actions.ClientActionForwarder;
import org.eclipse.glsp.server.actions.ResponseAction;
import org.eclipse.glsp.server.di.ClientId;
import org.eclipse.glsp.server.disposable.Disposable;
import org.eclipse.glsp.server.features.core.model.UpdateModelAction;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.utils.FutureUtil;

public class DefaultActionDispatcher
extends Disposable
implements ActionDispatcher,
ActionHandler {
    private static final Logger LOGGER = LogManager.getLogger(DefaultActionDispatcher.class);
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    @Inject
    protected ActionHandlerRegistry actionHandlerRegistry;
    @Inject
    @ClientId
    protected String clientId;
    @Inject
    protected ClientActionForwarder clientActionForwarder;
    protected final String name;
    protected final Thread thread;
    protected final BlockingQueue<Action> actionsQueue = new ArrayBlockingQueue<Action>(100, true);
    protected List<Action> postUpdateQueue = new ArrayList<Action>();
    protected final Map<Action, CompletableFuture<Void>> results = Collections.synchronizedMap(new HashMap());
    @Inject
    protected Provider<GLSPClient> client;

    public DefaultActionDispatcher() {
        this.name = String.valueOf(this.getClass().getSimpleName()) + " " + COUNT.incrementAndGet();
        this.thread = new Thread(this::runThread);
        this.thread.setName(this.name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public CompletableFuture<Void> dispatch(Action action) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.results.put(action, result);
        if (this.thread == Thread.currentThread()) {
            this.handleAction(action);
        } else {
            this.addToQueue(action);
        }
        return result;
    }

    @Override
    public void dispatchAfterNextUpdate(Action ... actions) {
        this.postUpdateQueue.addAll(Arrays.asList(actions));
    }

    protected void addToQueue(Action action) {
        if (Thread.currentThread() == this.thread) {
            LOGGER.error("Actions shouldn't be added to the actions queue from the dispatcher thread!");
            this.handleAction(action);
            return;
        }
        boolean success = this.actionsQueue.offer(action);
        while (!success) {
            if (!this.thread.isAlive() || this.thread.isInterrupted()) {
                LOGGER.warn(String.format("Received an action after the ActionDispatcher was stopped. Ignoring action: %s", action));
                return;
            }
            try {
                success = this.actionsQueue.offer(action, 1L, TimeUnit.SECONDS);
                if (success) continue;
                LOGGER.warn(String.format("Actions queue is currently full for dispatcher %s ; retrying...", this.name));
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    private void runThread() {
        try {
            while (true) {
                this.handleNextAction();
            }
        }
        catch (InterruptedException e) {
            LOGGER.info(String.format("Terminating DefaultActionDispatcher thread %s", Thread.currentThread().getName()));
            LOGGER.info("Terminating DefaultActionDispatcher");
            return;
        }
    }

    private void handleNextAction() throws InterruptedException {
        Action action = this.actionsQueue.take();
        if (action != null) {
            this.handleAction(action);
        }
    }

    protected void handleAction(Action action) {
        this.checkThread();
        if (action == null) {
            LOGGER.warn(String.format("Received a null action for client %s", this.clientId));
            return;
        }
        try {
            List<CompletableFuture<Void>> results = this.runAction(action);
            CompletableFuture<Void> result = FutureUtil.aggregateResults(results);
            ((CompletableFuture)result.thenAccept(any -> this.results.remove(action).complete(null))).exceptionally(t -> {
                this.results.remove(action).completeExceptionally((Throwable)t);
                return null;
            });
        }
        catch (Throwable t2) {
            this.results.remove(action).completeExceptionally(t2);
        }
    }

    protected List<CompletableFuture<Void>> runAction(Action action) {
        boolean handledOnClient = this.clientActionForwarder.handle(action);
        List<ActionHandler> actionHandlers = this.actionHandlerRegistry.get(action);
        if (!handledOnClient && actionHandlers.isEmpty()) {
            throw new IllegalArgumentException("No handler registered for action: " + action);
        }
        ArrayList<CompletableFuture<Void>> results = new ArrayList<CompletableFuture<Void>>();
        for (ActionHandler actionHandler : actionHandlers) {
            List<Action> responses = actionHandler.execute(action).stream().map(response -> ResponseAction.respond(action, response)).collect(Collectors.toList());
            results.addAll(this.dispatchAll(responses));
        }
        if (action instanceof UpdateModelAction) {
            results.add(this.dispatchPostUpdateQueue());
        }
        return results;
    }

    protected CompletableFuture<Void> dispatchPostUpdateQueue() {
        ArrayList<Action> toDispatch = new ArrayList<Action>(this.postUpdateQueue);
        this.postUpdateQueue.clear();
        this.dispatchAll(toDispatch);
        return CompletableFuture.completedFuture(null);
    }

    protected final void checkThread() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("This method should only be invoked from the ActionDispatcher's thread: " + this.name);
        }
    }

    protected void executeAllPendingActions() {
        this.dispatch(new JoinAction()).join();
    }

    @Override
    public void doDispose() {
        this.executeAllPendingActions();
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    @Override
    public List<Class<? extends Action>> getHandledActionTypes() {
        return List.of(JoinAction.class);
    }

    @Override
    public List<Action> execute(Action action) {
        return this.none();
    }

    public static class JoinAction
    extends Action {
        public JoinAction() {
            super("internal.join");
        }
    }
}

