/********************************************************************************
 * Copyright (c) 2020-2021 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
package org.eclipse.glsp.server.disposable;

import java.util.ArrayList;
import java.util.List;

/**
 * A collection of {@link IDisposable}s that can be disposed.
 */
public class DisposableCollection extends Disposable {
   private final List<IDisposable> disposables = new ArrayList<>();

   public void add(final IDisposable disposable) {
      if (!isDisposed()) {
         this.disposables.add(disposable);
      }
   }

   public void add(final Runnable runnable) {
      add(IDisposable.create(runnable));
   }

   public void remove(final IDisposable disposable) {
      if (!isDisposed()) {
         this.disposables.remove(disposable);
      }
   }

   @Override
   protected void doDispose() {
      disposables.forEach(IDisposable::dispose);
   }
}
