/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public final class MultiBinding<T> {
    private final Set<Class<? extends T>> bindings;
    private final TypeLiteral<T> type;
    private String annotationName;

    public static <T> MultiBinding<T> create(Class<T> type) {
        return new MultiBinding<T>(TypeLiteral.get(type));
    }

    public static <T> MultiBinding<T> create(TypeLiteral<T> type) {
        return new MultiBinding<T>(type);
    }

    private MultiBinding(TypeLiteral<T> type) {
        this.type = type;
        this.bindings = new LinkedHashSet<Class<? extends T>>();
    }

    public MultiBinding<T> setAnnotationName(String annotationName) {
        this.annotationName = annotationName;
        return this;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public void applyBinding(Binder binder) {
        Multibinder multiBinder = this.annotationName == null ? Multibinder.newSetBinder((Binder)binder, this.getType()) : Multibinder.newSetBinder((Binder)binder, this.getType(), (Annotation)Names.named((String)this.annotationName));
        this.bindings.forEach(b -> {
            ScopedBindingBuilder scopedBindingBuilder = multiBinder.addBinding().to(b);
        });
    }

    public boolean add(Class<? extends T> newBinding) {
        return this.bindings.add(newBinding);
    }

    public boolean addAll(Collection<Class<? extends T>> newBindings) {
        return this.bindings.addAll(newBindings);
    }

    public boolean remove(Class<? extends T> toRemove) {
        return this.bindings.remove(toRemove);
    }

    public boolean removeAll(Collection<Class<? extends T>> toRemove) {
        return this.bindings.removeAll(toRemove);
    }

    public boolean rebind(Class<? extends T> oldBinding, Class<? extends T> newBinding) {
        if (this.remove(oldBinding)) {
            this.add(newBinding);
            return true;
        }
        return false;
    }

    public Set<Class<? extends T>> getAll() {
        return this.bindings;
    }

    public boolean contains(Class<? extends T> binding) {
        return this.bindings.contains(binding);
    }

    TypeLiteral<T> getType() {
        return this.type;
    }
}

