/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.control;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.business.internal.command.control.ControlCommand;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SiriusControlCommand
extends ControlCommand {
    private final Session session;
    private final Set<DRepresentationDescriptor> repDescriptors;
    private final URI representationsDestination;
    private final boolean shouldEndBySaving;
    private IProgressMonitor monitor;

    @Deprecated
    public SiriusControlCommand(EObject semanticRoot, URI semanticDest, Set<DRepresentationDescriptor> repDescriptors, URI representationsDest, IProgressMonitor monitor) {
        this(semanticRoot, semanticDest, repDescriptors, representationsDest, true, monitor);
    }

    public SiriusControlCommand(EObject semanticRoot, URI semanticDest, Set<DRepresentationDescriptor> representations, URI representationsDest, boolean shouldEndBySaving, IProgressMonitor monitor) {
        super(semanticRoot, semanticDest);
        this.session = SessionManager.INSTANCE.getSession(semanticRoot);
        this.repDescriptors = Sets.newHashSet(representations);
        this.representationsDestination = representationsDest;
        this.shouldEndBySaving = shouldEndBySaving;
        this.monitor = monitor;
    }

    @Override
    protected void doExecute() {
        try {
            this.monitor.beginTask(Messages.SiriusControlCommand_controlResourceMsg, 3);
            super.doExecute();
            this.monitor.worked(1);
            this.markContainerResourceAsModified(this.semanticObjectToControl.eContainer());
            this.createNewRepresentationsFileAndMoveRepresentations();
            this.monitor.worked(1);
            this.notifySessionAboutControlledModel();
            if (this.shouldEndBySaving) {
                this.session.save((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
        }
        finally {
            this.monitor.done();
        }
    }

    private void markContainerResourceAsModified(EObject obj) {
        Resource rootContainerResource;
        EObject rootContainer = this.getRootContainer(obj);
        if (obj != null && rootContainer != null && (rootContainerResource = rootContainer.eResource()) != null) {
            rootContainerResource.setModified(true);
        }
    }

    protected EObject getRootContainer(EObject eObject) {
        return new EObjectQuery(eObject).getResourceContainer();
    }

    private void createNewRepresentationsFileAndMoveRepresentations() {
        Resource newRepresentationsFile;
        boolean emptyAirdFragmentOnControl = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_EMPTY_AIRD_FRAGMENT_ON_CONTROL.name(), false, null);
        if (this.repDescriptors.isEmpty() && !emptyAirdFragmentOnControl) {
            return;
        }
        if (this.repDescriptors.isEmpty() && emptyAirdFragmentOnControl) {
            Resource firstAird = this.session.getSessionResource();
            newRepresentationsFile = firstAird.getResourceSet().createResource(this.representationsDestination);
            DAnalysis newDAnalysis = this.getDAnalysis(newRepresentationsFile);
            for (Viewpoint viewpoint : this.session.getSelectedViewpoints(false)) {
                DView createDView = ViewpointFactory.eINSTANCE.createDView();
                createDView.setViewpoint(viewpoint);
                newDAnalysis.getOwnedViews().add((Object)createDView);
                newDAnalysis.getSelectedViews().add((Object)createDView);
            }
        } else {
            newRepresentationsFile = this.getOrCreateChildResource(this.getParentAird(), this.representationsDestination);
        }
        DAnalysis newDAnalysis = this.getDAnalysis(newRepresentationsFile);
        newDAnalysis.getSemanticResources().add((Object)new ResourceDescriptor(this.controlledResource.getURI()));
        this.updateReferencedAnalysisReferences(newDAnalysis);
        this.moveRepresentations(newDAnalysis);
        this.updateModelsReferences(newDAnalysis);
    }

    private void updateReferencedAnalysisReferences(DAnalysis newDAnalysis) {
        EObject semanticParentRoot = this.getRootContainer(this.semanticObjectToControl.eContainer());
        LinkedHashSet<DAnalysis> referencers = new LinkedHashSet<DAnalysis>();
        for (Resource aird : this.session.getAllSessionResources()) {
            DAnalysis currentAnalysis = this.getDAnalysis(aird);
            Set<EObject> releventModels = new DAnalysisQuery(currentAnalysis).getMainModels();
            if (!Iterables.contains(releventModels, (Object)semanticParentRoot)) continue;
            ArrayList<DAnalysis> referencedAnalysis = new ArrayList<DAnalysis>((Collection<DAnalysis>)currentAnalysis.getReferencedAnalysis());
            for (DAnalysis childrenAnalysis : referencedAnalysis) {
                Option<EObject> optionalChildrenMainModel = new DAnalysisQuery(childrenAnalysis).getMainModel();
                if (!optionalChildrenMainModel.some() || !new EObjectQuery((EObject)optionalChildrenMainModel.get()).isContainedIn(this.semanticObjectToControl)) continue;
                currentAnalysis.getReferencedAnalysis().remove((Object)childrenAnalysis);
                newDAnalysis.getReferencedAnalysis().add((Object)childrenAnalysis);
            }
            referencers.add(currentAnalysis);
        }
        if (!referencers.isEmpty() && this.session instanceof DAnalysisSession) {
            ((DAnalysisSession)this.session).addReferencedAnalysis(newDAnalysis, referencers);
        }
    }

    private void moveRepresentations(DAnalysis targetAnalysis) {
        for (DRepresentationDescriptor representation : this.repDescriptors) {
            ((DAnalysisSession)this.session).moveRepresentation(targetAnalysis, representation);
        }
    }

    private void updateModelsReferences(DAnalysis analysisToIgnore) {
        for (Resource resource : ((DAnalysisSession)this.session).getAllSessionResources()) {
            for (EObject content : resource.getContents()) {
                if (!(content instanceof DAnalysis) || content.equals(analysisToIgnore)) continue;
                for (DView view : ((DAnalysis)content).getOwnedViews()) {
                    DAnalysisSessionHelper.updateModelsReferences(view);
                }
            }
        }
    }

    private Resource getParentAird() {
        return this.repDescriptors.iterator().next().eResource();
    }

    private DAnalysis getDAnalysis(Resource aird) {
        for (EObject root : aird.getContents()) {
            if (!(root instanceof DAnalysis)) continue;
            return (DAnalysis)root;
        }
        DAnalysis newAnalysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        aird.getContents().add((Object)newAnalysis);
        return newAnalysis;
    }

    private void notifySessionAboutControlledModel() {
        if (this.session instanceof DAnalysisSession) {
            ((DAnalysisSession)this.session).notifyControlledModel(this.controlledResource);
        }
    }
}

