/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.gemoc.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gemoc.trace.gemoc.generator.TraceAddonGeneratorIntegration;
import org.eclipse.gemoc.xdsmlframework.ide.ui.commands.AbstractDslSelectHandler;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * Handler that allows to get an XDSML project (containing a melange file)
 * and will ask for selection of the language (if necessary) and launch the generation
 */
@SuppressWarnings("all")
public class XDSMLProject2TraceAddonHandler extends AbstractDslSelectHandler implements IHandler {
  private final static String pluginId = "org.eclipse.gemoc.trace.gemoc.ui";
  
  @Override
  public Object executeForSelectedLanguage(final ExecutionEvent event, final IProject updatedGemocLanguageProject, final String language) throws ExecutionException {
    final IFile dslFile = this.getDslFileFromSelection(event);
    final String baseProjectName = XDSMLProjectHelper.baseProjectName(dslFile.getProject());
    String _xifexpression = null;
    boolean _endsWith = baseProjectName.endsWith(language.toLowerCase());
    if (_endsWith) {
      _xifexpression = baseProjectName;
    } else {
      String _lowerCase = language.toLowerCase();
      _xifexpression = ((baseProjectName + ".") + _lowerCase);
    }
    final String suggestedBasePluginName = _xifexpression;
    final String suggestedPluginName = (suggestedBasePluginName + ".trace");
    final InputDialog inputDialog = new InputDialog(null, 
      ("Create MultiDimensional Trace addon for language " + language), "Enter project name ", suggestedPluginName, null);
    inputDialog.open();
    int _returnCode = inputDialog.getReturnCode();
    boolean _equals = (_returnCode == Window.OK);
    if (_equals) {
      final String projectName = inputDialog.getValue();
      String _string = dslFile.toString();
      String _plus = ("Generating trace addon plugin for " + _string);
      final Job j = new Job(_plus) {
        @Override
        protected IStatus run(final IProgressMonitor monitor) {
          try {
            TraceAddonGeneratorIntegration.generateAddon(dslFile, language, projectName, true, monitor);
          } catch (final Throwable _t) {
            if (_t instanceof Exception) {
              final Exception e = (Exception)_t;
              return new Status(Status.ERROR, XDSMLProject2TraceAddonHandler.pluginId, "An error occured while generating the trace addon. Please expand below for the complete error stack trace.", e);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
          return new Status(Status.OK, XDSMLProject2TraceAddonHandler.pluginId, "Multidimensional Trace addon plugin generated.");
        }
      };
      j.schedule();
    }
    return null;
  }
  
  @Override
  public String getSelectionMessage() {
    return "Select Language that is used to initialize the Multidimensional Trace addon creation wizard";
  }
}
