/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.build.fragments;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;

public class MergeWriter {
    public static final String DEFAULT_COPYRIGHT = "<copyright>\n\n</copyright>";
    public static final String NL_REGEX = "(\r\n?)|(\n\r?)";
    protected Logger log = Logger.getLogger(this.getClass());
    private @NonNull StringBuilder s = new StringBuilder();
    private @NonNull String fileName;

    public static String getCopyright(String copyright) {
        if (copyright == null || copyright.length() <= 0) {
            return DEFAULT_COPYRIGHT;
        }
        return copyright.trim().replaceAll(NL_REGEX, "\n");
    }

    public MergeWriter(@NonNull String fileName) throws IOException {
        this.fileName = fileName;
        this.log.info((Object)("Generating '" + fileName + "'"));
    }

    public void append(@NonNull String string) {
        this.s.append(string);
    }

    public void close() throws IOException {
        String newContents;
        String merged = newContents = this.s.toString().replaceAll(NL_REGEX, "\n");
        try {
            int len;
            FileReader in = new FileReader(this.fileName);
            StringBuilder s = new StringBuilder();
            char[] cbuf = new char[4096];
            while ((len = in.read(cbuf)) > 0) {
                s.append(cbuf, 0, len);
            }
            in.close();
            String oldContents = s.toString().replaceAll(NL_REGEX, "\n");
            int oldIndex = oldContents.indexOf("</copyright>");
            int newIndex = newContents.indexOf("</copyright>");
            if (oldIndex >= 0 && newIndex >= 0) {
                merged = String.valueOf(oldContents.substring(0, oldIndex)) + newContents.substring(newIndex, newContents.length());
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        File file = new File(this.fileName);
        file.getParentFile().mkdirs();
        FileWriter w = new FileWriter(file);
        w.write(merged);
        w.close();
    }
}

