/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;

public class CodeExecutorDispatcher
implements ICodeExecutor {
    protected List<ICodeExecutor> _executors = new ArrayList<ICodeExecutor>();

    public CodeExecutorDispatcher() {
    }

    public CodeExecutorDispatcher(ICodeExecutor codeExecutor) {
        this();
        this.addExecutor(codeExecutor);
    }

    public CodeExecutorDispatcher(List<ICodeExecutor> codeExecutors) {
        this();
        for (ICodeExecutor codeExecutor : codeExecutors) {
            this.addExecutor(codeExecutor);
        }
    }

    public void addExecutor(ICodeExecutor executor) {
        this._executors.add(executor);
    }

    public Object execute(MSEOccurrence mseOccurrence) throws CodeExecutionException {
        int count = 0;
        for (ICodeExecutor executor : this._executors) {
            ++count;
            try {
                return executor.execute(mseOccurrence);
            }
            catch (CodeExecutionException e) {
                if (e.isCodeExecutionApplicable()) {
                    Activator.getDefault().error("Code executor(" + count + "/" + this._executors.size() + ") " + executor.getExcutorID() + " wasn't able to process the request. " + e.getMessage(), e);
                    throw new CodeExecutionException("An applicable code executor was found but failed due to " + e.getMessage(), mseOccurrence);
                }
                Activator.getDefault().debug("Code executor(" + count + "/" + this._executors.size() + ") " + executor.getExcutorID() + " wasn't able to process the request. " + e.getMessage());
            }
        }
        throw new CodeExecutionException("No code executor could perform the action call. (a commons mistake is : missing package export of the called class or aspect)", mseOccurrence);
    }

    public Object execute(Object caller, String methodName, List<Object> parameters) throws CodeExecutionException {
        for (ICodeExecutor executor : this._executors) {
            try {
                return executor.execute(caller, methodName, parameters);
            }
            catch (CodeExecutionException codeExecutionException) {
                // empty catch block
            }
        }
        throw new CodeExecutionException("No code executor could perform the action call. (a commons mistake is : missing package export of the called class or aspect)", null);
    }

    public List<Method> findCompatibleMethodsWithAnnotation(Object caller, List<Object> parameters, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (ICodeExecutor executor : this._executors) {
            result.addAll(executor.findCompatibleMethodsWithAnnotation(caller, parameters, annotationClass));
        }
        return result;
    }

    public String getExcutorID() {
        return this.getClass().getSimpleName();
    }
}

