/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.DebugPackage;
import org.eclipse.gemoc.dsl.debug.DebugTargetState;
import org.eclipse.gemoc.dsl.debug.DebugTargetUtils;
import org.eclipse.gemoc.dsl.debug.RegisterGroup;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.State;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.Variable;

public final class ThreadUtils {
    private ThreadUtils() {
    }

    public static boolean canResume(Thread thread) {
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED;
    }

    public static void resumedReply(Thread thread) {
        if (!ThreadUtils.canResume(thread)) {
            throw new IllegalStateException("can't resume a not suspended thread or a thread in a not connected debug target.");
        }
        thread.setState(State.RUNNING);
    }

    public static boolean canSuspend(Thread thread) {
        return ThreadUtils.isActive(thread);
    }

    public static boolean isActive(Thread thread) {
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && ThreadUtils.isActiveStat(thread.getState());
    }

    private static boolean isActiveStat(State state) {
        return state == State.RUNNING || ThreadUtils.isSteppingState(state);
    }

    public static boolean isStepping(Thread thread) {
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && ThreadUtils.isSteppingState(thread.getState());
    }

    private static boolean isSteppingState(State state) {
        return state == State.STEPPING_INTO || state == State.STEPPING_OVER || state == State.STEPPING_RETURN;
    }

    public static void suspendRequest(Thread thread) {
        if (!ThreadUtils.canSuspend(thread)) {
            throw new IllegalStateException("can't suspend a not running or stepping thread or a thread in a not connected debug target.");
        }
        thread.setState(State.SUSPENDING);
    }

    public static void suspendedReply(Thread thread) {
        State state = thread.getState();
        if (thread.getDebugTarget().getState() != DebugTargetState.CONNECTED || state != State.SUSPENDING && !ThreadUtils.isActiveStat(state)) {
            throw new IllegalStateException("a suspend reply must happend when the thread is suspending, running, or stepping and the debug target is connected.");
        }
        thread.setState(State.SUSPENDED);
        ThreadUtils.unchangeVariables(thread);
    }

    private static void unchangeVariables(Thread thread) {
        StackFrame currentStackFrame = thread.getBottomStackFrame();
        while (currentStackFrame != null) {
            for (Variable variable : currentStackFrame.getVariables()) {
                variable.setValueChanged(false);
            }
            currentStackFrame = currentStackFrame.getChildFrame();
        }
    }

    public static void terminateRequest(Thread thread) {
        if (!ThreadUtils.canTerminate(thread)) {
            throw new IllegalStateException("can't terminate a thread if this debug target is not connected.");
        }
        thread.setState(State.TERMINATING);
    }

    public static void terminatedReply(Thread thread) {
        if (thread.getDebugTarget().getState() != DebugTargetState.CONNECTED && thread.getDebugTarget().getState() != DebugTargetState.TERMINATING || thread.getState() == State.TERMINATED) {
            throw new IllegalStateException("a terminate reply can't happend when the debug target is not connected, terminating or if the thread is already terminated.");
        }
        thread.setState(State.TERMINATED);
    }

    public static boolean canTerminate(Thread thread) {
        return DebugTargetUtils.canTerminate(thread.getDebugTarget());
    }

    public static void stepOverReply(Thread thread) {
        if (!ThreadUtils.canStepOver(thread)) {
            throw new IllegalStateException("can't step over when the thread is not in suspended mode or the debug target is disconnected.");
        }
        thread.setState(State.STEPPING_OVER);
    }

    public static boolean canStepReturn(Thread thread) {
        StackFrame topStackFrame = thread.getTopStackFrame();
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED && topStackFrame != null && topStackFrame.getParentFrame() != null;
    }

    public static void stepReturnReply(Thread thread) {
        if (!ThreadUtils.canStepReturn(thread)) {
            throw new IllegalStateException("can't step return when the thread is not in suspended mode or the debug target is disconnected or the current stack frame don't have a parent frame.");
        }
        thread.setState(State.STEPPING_RETURN);
    }

    public static boolean canStepInto(Thread thread) {
        StackFrame topStackFrame = thread.getTopStackFrame();
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED && topStackFrame != null && topStackFrame.isCanStepIntoCurrentInstruction();
    }

    public static void stepIntoReply(Thread thread) {
        if (!ThreadUtils.canStepInto(thread)) {
            throw new IllegalStateException("can't step into when the thread is not in suspended mode or the debug target is disconnected or the current instruction don't support step into.");
        }
        thread.setState(State.STEPPING_INTO);
    }

    public static boolean canStepOver(Thread thread) {
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED;
    }

    public static Variable getVariable(Thread thread, String name) {
        StackFrame topStackFrame = thread.getTopStackFrame();
        Variable res = topStackFrame != null ? DebugTargetUtils.getVariable(topStackFrame, name) : null;
        return res;
    }

    public static void setVariableReply(StackFrame stackFrame, String declarationTypeName, String name, Object value, boolean supportModifications) {
        Thread thread = ThreadUtils.getThread(stackFrame);
        if (ThreadUtils.canSetVariable(thread)) {
            if (thread.getTopStackFrame() == null) {
                throw new IllegalStateException("can't set a variable when there is not stack frame.");
            }
        } else {
            throw new IllegalStateException("can't set a variable when the debug target is not connected or the thread is not suspended.");
        }
        DebugTargetUtils.setVariable(stackFrame, declarationTypeName, name, value, supportModifications);
    }

    public static void setVariableValueReply(Variable variable, Object value) {
        variable.setValue(value);
    }

    private static boolean canSetVariable(Thread thread) {
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED;
    }

    public static void deleteVariableReply(Thread thread, String name) {
        Variable variable = ThreadUtils.getVariable(thread, name);
        if (variable != null) {
            EcoreUtil.delete((EObject)variable);
        }
    }

    public static RegisterGroup getRegisterGroup(Thread thread, String name) {
        StackFrame topStackFrame = thread.getTopStackFrame();
        RegisterGroup res = topStackFrame != null ? DebugTargetUtils.getRegisterGroup(topStackFrame, name) : null;
        return res;
    }

    public static StackFrame pushStackFrameReply(Thread thread, String name, EObject context, EObject instruction, boolean canStepInto) {
        StackFrame newFrame;
        if (ThreadUtils.canPushFrame(thread)) {
            StackFrame topStackFrame = thread.getTopStackFrame();
            newFrame = DebugPackage.eINSTANCE.getDebugFactory().createStackFrame();
            newFrame.setName(name);
            newFrame.setContext(context);
            newFrame.setCurrentInstruction(instruction);
            newFrame.setCanStepIntoCurrentInstruction(canStepInto);
            if (topStackFrame != null) {
                newFrame.setParentFrame(topStackFrame);
            }
            if (context == null) {
                if (topStackFrame != null) {
                    newFrame.setContext(topStackFrame.getContext());
                } else {
                    newFrame.setContext(thread.getContext());
                }
            }
            thread.setTopStackFrame(newFrame);
            if (thread.getBottomStackFrame() == null) {
                thread.setBottomStackFrame(newFrame);
            }
        } else {
            throw new IllegalStateException("can't push a stack frame when the debug target is not connected or the thread is not suspended.");
        }
        StackFrame res = newFrame;
        return res;
    }

    public static boolean canPushFrame(Thread thread) {
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED;
    }

    public static StackFrame popStackFrameReply(Thread thread) {
        if (!ThreadUtils.canPopFrame(thread)) {
            throw new IllegalStateException("can't pop a stack frame when the debug target is not connected or the thread is not suspended.");
        }
        StackFrame topStackFrame = thread.getTopStackFrame();
        thread.setTopStackFrame(topStackFrame.getParentFrame());
        EcoreUtil.delete((EObject)topStackFrame);
        StackFrame res = topStackFrame;
        return res;
    }

    public static boolean canPopFrame(Thread thread) {
        StackFrame topStackFrame = thread.getTopStackFrame();
        return thread.getDebugTarget().getState() == DebugTargetState.CONNECTED && thread.getState() == State.SUSPENDED && topStackFrame != null;
    }

    public static boolean isSuspended(Thread thread) {
        return thread.getState() == State.SUSPENDED;
    }

    public static Thread getThread(StackFrame frame) {
        Thread res = null;
        EObject current = frame.eContainer();
        while (current instanceof StackFrame) {
            current = current.eContainer();
        }
        if (current instanceof Thread) {
            res = (Thread)current;
        }
        return res;
    }

    public static void setCurrentInstructionReply(Thread thread, EObject instruction, boolean canStepInto) {
        StackFrame topStackFrame = thread.getTopStackFrame();
        if (topStackFrame == null) {
            throw new IllegalStateException("can't set current instrcution when there is no top stack frame.");
        }
        topStackFrame.setCurrentInstruction(instruction);
        topStackFrame.setCanStepIntoCurrentInstruction(canStepInto);
    }
}

