/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.sirius;

import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.gemoc.ale.interpreted.engine.AleEngine;
import org.eclipse.sirius.common.acceleo.aql.business.internal.AQLSiriusInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;

public class ALESiriusInterpreter
extends AQLSiriusInterpreter {
    AleEngine engine;

    public ALESiriusInterpreter(AleEngine engine) {
        this.engine = engine;
    }

    public boolean provides(String expression) {
        return expression != null && expression.startsWith("ale:");
    }

    public IInterpreterWithDiagnostic.IEvaluationResult evaluateExpression(EObject target, String fullExpression) throws EvaluationException {
        IQueryEnvironment queryEnv;
        this.javaExtensions.reloadIfNeeded();
        String expression = fullExpression.replaceFirst("ale:", "");
        Map variables = this.getVariables();
        variables.put("self", target);
        ALEInterpreter aleInterpreter = this.engine.getInterpreter();
        if (aleInterpreter != null && (queryEnv = aleInterpreter.getQueryEnvironment()) != null) {
            IQueryBuilderEngine builder = QueryParsing.newBuilder((IQueryEnvironment)queryEnv);
            IQueryBuilderEngine.AstResult build = builder.build(expression);
            IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine((IQueryEnvironment)queryEnv);
            final EvaluationResult evalResult = evaluationEngine.eval(build, variables);
            final BasicDiagnostic diagnostic = new BasicDiagnostic();
            if (build.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(build.getDiagnostic());
            }
            if (evalResult.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(evalResult.getDiagnostic());
            }
            return new IInterpreterWithDiagnostic.IEvaluationResult(){

                public Object getValue() {
                    return evalResult.getResult();
                }

                public Diagnostic getDiagnostic() {
                    List children = diagnostic.getChildren();
                    if (children.size() == 1) {
                        return (Diagnostic)children.get(0);
                    }
                    return diagnostic;
                }
            };
        }
        return new IInterpreterWithDiagnostic.IEvaluationResult(){

            public Object getValue() {
                return null;
            }

            public Diagnostic getDiagnostic() {
                return new BasicDiagnostic();
            }
        };
    }
}

