/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.diffviewer.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Pair;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.addon.diffviewer.logic.Diff;
import org.eclipse.gemoc.addon.diffviewer.logic.DiffComputer;
import org.eclipse.gemoc.addon.diffviewer.views.ValueView;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;

public class TimelineDiffViewerRenderer
extends Pane {
    private static final int H_MARGIN = 8;
    private static final int V_MARGIN = 2;
    private static final int WIDTH = 24;
    private static final int UNIT = 40;
    private static final Insets HALF_MARGIN_INSETS = new Insets(2.0, 4.0, 2.0, 4.0);
    private static final Insets MARGIN_INSETS = new Insets(2.0, 8.0, 2.0, 8.0);
    private static final Paint LINE_PAINT = new Color(Color.LIGHTGRAY.getRed(), Color.LIGHTGRAY.getGreen(), Color.LIGHTGRAY.getBlue(), 0.5);
    private static final Background LINE_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill(LINE_PAINT, null, null)});
    private static final Background HEADER_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)});
    private static final Background WHITE_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final Background TRANSPARENT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)});
    private static final Font STATE_FONT = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)9.0);
    private static final Font VALUE_FONT = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0);
    private static final Font GROUP_FONT = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0);
    private final VBox rootVBox = new VBox();
    private final HBox line1 = new HBox();
    private final HBox line2 = new HBox();
    private final VBox eqLines = new VBox();
    private final VBox eqBox = new VBox();
    private final VBox substLines = new VBox();
    private final VBox substBox = new VBox();
    private final VBox inLines = new VBox();
    private final VBox inBox = new VBox();
    private final VBox delLines = new VBox();
    private final VBox delBox = new VBox();
    private final ScrollBar scrollBar = new ScrollBar();
    private final IntegerProperty nbDisplayableStates;
    private final IntegerProperty statesRange;
    private final IntegerProperty nbStates;
    private int currentState = 0;
    final Map<HBox, List<List<Diff.DiffKind>>> lineToSegments = new HashMap<HBox, List<List<Diff.DiffKind>>>();
    final Map<HBox, List<String>> segmentToDescription = new HashMap<HBox, List<String>>();
    final Map<List<Value<?>>, String> dimensionDescriptions = new HashMap();
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor1 = null;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor2 = null;
    private final List<List<Value<?>>> values1 = new ArrayList();
    private final List<List<Value<?>>> values2 = new ArrayList();
    private final List<State<?, ?>> states1 = new ArrayList();
    private final List<State<?, ?>> states2 = new ArrayList();
    private DiffComputer diffComputer;

    public TimelineDiffViewerRenderer() {
        this.nbStates = new SimpleIntegerProperty();
        this.statesRange = new SimpleIntegerProperty();
        this.nbDisplayableStates = new SimpleIntegerProperty();
        this.nbDisplayableStates.bind((ObservableValue)this.widthProperty().divide(40));
        this.statesRange.bind((ObservableValue)this.nbStates.subtract((ObservableNumberValue)this.nbDisplayableStates));
        this.nbDisplayableStates.addListener((v, o, n) -> this.refresh());
        this.setupBox(this.eqBox, "Toggle identical traces", this.eqLines);
        this.setupBox(this.substBox, "Toggle similar traces", this.substLines);
        this.setupBox(this.inBox, "Toggle inserted traces", this.inLines);
        this.setupBox(this.delBox, "Toggle deleted traces", this.delLines);
        ScrollPane scrollPane = new ScrollPane((Node)this.rootVBox);
        scrollPane.minWidthProperty().bind((ObservableValue)this.widthProperty());
        scrollPane.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        scrollPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        scrollPane.setFitToWidth(true);
        scrollPane.setBorder(Border.EMPTY);
        VBox headerPane = new VBox();
        headerPane.minWidthProperty().bind((ObservableValue)this.widthProperty());
        headerPane.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        headerPane.setBackground(HEADER_BACKGROUND);
        scrollPane.translateYProperty().bind((ObservableValue)headerPane.heightProperty());
        scrollPane.maxHeightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)headerPane.heightProperty()));
        this.getChildren().add((Object)headerPane);
        this.getChildren().add((Object)scrollPane);
        this.minHeightProperty().bind((ObservableValue)headerPane.heightProperty().add((ObservableNumberValue)scrollPane.heightProperty()));
        this.prefHeightProperty().bind((ObservableValue)headerPane.heightProperty().add((ObservableNumberValue)scrollPane.heightProperty()));
        this.maxHeightProperty().bind((ObservableValue)headerPane.heightProperty().add((ObservableNumberValue)scrollPane.heightProperty()));
        this.scrollBar.setVisibleAmount(1.0);
        this.scrollBar.setBlockIncrement(10.0);
        this.scrollBar.setMin(0.0);
        this.scrollBar.disableProperty().bind((ObservableValue)this.statesRange.lessThanOrEqualTo(0));
        this.scrollBar.maxProperty().bind((ObservableValue)this.statesRange);
        this.scrollBar.valueProperty().addListener((v, o, n) -> {
            if (o.intValue() != n.intValue() && n.intValue() != this.currentState) {
                this.currentState = n.intValue();
                this.refresh();
            }
        });
        headerPane.getChildren().add((Object)this.scrollBar);
        headerPane.getChildren().add((Object)this.line1);
        headerPane.getChildren().add((Object)this.line2);
        this.setBackground(WHITE_BACKGROUND);
        scrollPane.setBackground(WHITE_BACKGROUND);
        this.rootVBox.setBackground(WHITE_BACKGROUND);
    }

    private void setupBox(VBox box, String labelString, VBox content) {
        HBox boxLabel = new HBox();
        Polygon arrow = new Polygon(new double[]{2.5, 10.0, 10.0, 5.0, 2.5, 0.0});
        Label label = new Label(labelString);
        boxLabel.setBackground(HEADER_BACKGROUND);
        label.setFont(GROUP_FONT);
        HBox.setMargin((Node)arrow, (Insets)HALF_MARGIN_INSETS);
        boxLabel.setAlignment(Pos.CENTER_LEFT);
        boxLabel.getChildren().addAll((Object[])new Node[]{arrow, label});
        boxLabel.setCursor(Cursor.HAND);
        box.getChildren().add((Object)boxLabel);
        boxLabel.setOnMouseClicked(e -> {
            if (box.getChildren().size() > 1) {
                box.getChildren().remove((Object)content);
                arrow.setRotate(0.0);
            } else {
                box.getChildren().add((Object)content);
                arrow.setRotate(90.0);
            }
        });
    }

    private String computeStateLabel(int stateNumber) {
        if (stateNumber > 999) {
            return String.valueOf(stateNumber / 1000) + "k" + stateNumber % 1000 / 10;
        }
        return "" + stateNumber;
    }

    private void addState(State<?, ?> state, HBox line, Color color, int stateIndex, String stateDescription) {
        Rectangle rectangle = new Rectangle(24.0, 24.0, (Paint)color);
        rectangle.setArcHeight(24.0);
        rectangle.setArcWidth(24.0);
        rectangle.setUserData(state);
        Label text = new Label(this.computeStateLabel(stateIndex));
        text.setTextOverrun(OverrunStyle.ELLIPSIS);
        text.setAlignment(Pos.CENTER);
        text.setMouseTransparent(true);
        text.setTextFill((Paint)Color.WHITE);
        text.setFont(STATE_FONT);
        text.setMaxWidth(24.0);
        Tooltip tooltip = new Tooltip(stateDescription);
        Tooltip.install((Node)rectangle, (Tooltip)tooltip);
        StackPane layout = new StackPane();
        StackPane.setMargin((Node)rectangle, (Insets)MARGIN_INSETS);
        layout.getChildren().addAll((Object[])new Node[]{rectangle, text});
        line.getChildren().add((Object)layout);
    }

    private void addBlankState(HBox line) {
        Rectangle rectangle = new Rectangle(24.0, 24.0, (Paint)Color.TRANSPARENT);
        HBox.setMargin((Node)rectangle, (Insets)MARGIN_INSETS);
        line.getChildren().add((Object)rectangle);
    }

    private void addValue(Value<?> value, HBox line, String description, boolean newValue, Diff.DiffKind diffKind) {
        List<Object> segment;
        List<List<Diff.DiffKind>> segments = this.lineToSegments.get(line);
        boolean addDescription = false;
        if (segments.isEmpty()) {
            segment = new ArrayList();
            addDescription = true;
            segments.add(segment);
        } else if (newValue) {
            segment = new ArrayList();
            addDescription = true;
            segments.add(segment);
        } else {
            segment = segments.get(segments.size() - 1);
            if (segment == null) {
                segment = new ArrayList();
                addDescription = true;
                segments.add(segment);
            }
        }
        if (addDescription) {
            List<String> descriptions = this.segmentToDescription.get(line);
            if (descriptions == null) {
                descriptions = new ArrayList<String>();
                this.segmentToDescription.put(line, descriptions);
            }
            descriptions.add(description);
        }
        segment.add((Object)diffKind);
    }

    private void addValue(Value<?> value, HBox line, String description, boolean newValue) {
        this.addValue(value, line, description, newValue, Diff.DiffKind.EQ);
    }

    private void addDelayedValue(HBox line, String description) {
        List<Object> segment;
        List<List<Diff.DiffKind>> segments = this.lineToSegments.get(line);
        boolean addDescription = false;
        if (segments.isEmpty()) {
            segment = new ArrayList();
            addDescription = true;
            segments.add(segment);
        } else {
            segment = segments.get(segments.size() - 1);
        }
        if (addDescription) {
            List<String> descriptions = this.segmentToDescription.get(line);
            if (descriptions == null) {
                descriptions = new ArrayList<String>();
                this.segmentToDescription.put(line, descriptions);
            }
            descriptions.add(description);
        }
        segment.add((Object)Diff.DiffKind.DEL);
    }

    private void addBlankValue(HBox line) {
        this.lineToSegments.get(line).add(null);
    }

    private List<Value<?>> normalizeValueTrace(List<Value<?>> trace, int start, int end, ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor) {
        ArrayList result = new ArrayList();
        for (Value<?> w : trace) {
            int firstStateIndex = extractor.getValueFirstStateIndex(w);
            int lastStateIndex = extractor.getValueLastStateIndex(w);
            while (result.size() < firstStateIndex - start) {
                result.add(null);
            }
            int i = Math.max(firstStateIndex, start);
            while (i <= Math.min(lastStateIndex, end)) {
                result.add(w);
                ++i;
            }
        }
        return result;
    }

    public void loadTraces(ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor1, ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor2) {
        this.loadTraces(extractor1, extractor2, 0, 0, extractor1.getStatesTraceLength() - 1, extractor2.getStatesTraceLength() - 1);
    }

    public void loadTraces(ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor1, ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor2, int s1, int s2, int e1, int e2) {
        List<Value<?>> normalizedValues;
        List values;
        this.extractor1 = extractor1;
        this.extractor2 = extractor2;
        this.values1.clear();
        this.values2.clear();
        this.states1.clear();
        this.states2.clear();
        this.dimensionDescriptions.clear();
        this.states1.addAll(extractor1.getStates(s1, e1));
        for (Dimension dimension : this.extractor1.getDimensions()) {
            values = extractor1.getValuesForStates(dimension, s1, e1);
            normalizedValues = this.normalizeValueTrace(values, s1, e1, extractor1);
            while (normalizedValues.size() < e1 - s1 + 1) {
                normalizedValues.add(null);
            }
            this.values1.add(normalizedValues);
            this.dimensionDescriptions.put(normalizedValues, extractor1.getDimensionLabel(dimension));
        }
        this.states2.addAll(extractor2.getStates(s2, e2));
        for (Dimension dimension : this.extractor2.getDimensions()) {
            values = extractor2.getValuesForStates(dimension, s2, e2);
            normalizedValues = this.normalizeValueTrace(values, s2, e2, extractor2);
            while (normalizedValues.size() < e2 - s2 + 1) {
                normalizedValues.add(null);
            }
            this.values2.add(normalizedValues);
            this.dimensionDescriptions.put(normalizedValues, extractor1.getDimensionLabel(dimension));
        }
        this.diffComputer = new DiffComputer();
        this.diffComputer.loadTraces(this.values1, this.values2);
        this.nbStates.set(this.diffComputer.getDiffs().size());
        this.currentState = 0;
        this.scrollBar.setValue(0.0);
        this.refresh();
    }

    private boolean isNewValue(int idx, List<Value<?>> list) {
        return idx == 0 || idx < list.size() && idx > 0 && list.get(idx - 1) != list.get(idx);
    }

    private void fillGap(HBox line, List<Value<?>> trace, int idx, String description) {
        if (idx > 0 && idx < trace.size()) {
            if (trace.get(idx - 1) != null || idx < trace.size() - 1 && trace.get(idx + 1) != null) {
                this.addDelayedValue(line, description);
            } else {
                this.addBlankValue(line);
            }
        } else {
            this.addBlankValue(line);
        }
    }

    public void refresh() {
        if (this.diffComputer != null) {
            Label l;
            HBox traceBox;
            Label l1;
            HBox trace2Box;
            HBox trace1Box;
            VBox pairBox;
            this.line1.getChildren().clear();
            this.line2.getChildren().clear();
            this.eqLines.getChildren().clear();
            this.substLines.getChildren().clear();
            this.inLines.getChildren().clear();
            this.delLines.getChildren().clear();
            this.lineToSegments.clear();
            this.rootVBox.getChildren().clear();
            List<Pair<List<Value<?>>, List<Value<?>>>> eqGroup = this.diffComputer.getEqGroup();
            List<Pair<List<Value<?>>, List<Value<?>>>> substGroup = this.diffComputer.getSubstGroup();
            List<List<Value<?>>> inGroup = this.diffComputer.getInGroup();
            List<List<Value<?>>> delGroup = this.diffComputer.getDelGroup();
            if (!eqGroup.isEmpty()) {
                this.rootVBox.getChildren().add((Object)this.eqBox);
            }
            if (!substGroup.isEmpty()) {
                this.rootVBox.getChildren().add((Object)this.substBox);
            }
            if (!inGroup.isEmpty()) {
                this.rootVBox.getChildren().add((Object)this.inBox);
            }
            if (!delGroup.isEmpty()) {
                this.rootVBox.getChildren().add((Object)this.delBox);
            }
            HashMap<List, HBox> traceToLine = new HashMap<List, HBox>();
            int c = 0;
            for (Pair<List<Value<?>>, List<Value<?>>> pair : eqGroup) {
                pairBox = new VBox();
                trace1Box = new HBox();
                trace2Box = new HBox();
                traceToLine.put((List)pair.getKey(), trace1Box);
                traceToLine.put((List)pair.getValue(), trace2Box);
                this.lineToSegments.put(trace1Box, new ArrayList());
                this.lineToSegments.put(trace2Box, new ArrayList());
                l1 = new Label(this.dimensionDescriptions.get(pair.getKey()));
                Label label = new Label(this.dimensionDescriptions.get(pair.getValue()));
                VBox.setMargin((Node)l1, (Insets)HALF_MARGIN_INSETS);
                VBox.setMargin((Node)label, (Insets)HALF_MARGIN_INSETS);
                l1.setFont(VALUE_FONT);
                label.setFont(VALUE_FONT);
                pairBox.getChildren().addAll((Object[])new Node[]{l1, trace1Box, label, trace2Box});
                this.eqLines.getChildren().add((Object)pairBox);
                pairBox.setBackground(c % 2 == 0 ? LINE_BACKGROUND : WHITE_BACKGROUND);
                trace1Box.setBackground(TRANSPARENT_BACKGROUND);
                trace2Box.setBackground(TRANSPARENT_BACKGROUND);
                ++c;
            }
            for (Pair<List<Value<?>>, List<Value<?>>> pair : substGroup) {
                pairBox = new VBox();
                trace1Box = new HBox();
                trace2Box = new HBox();
                traceToLine.put((List)pair.getKey(), trace1Box);
                traceToLine.put((List)pair.getValue(), trace2Box);
                this.lineToSegments.put(trace1Box, new ArrayList());
                this.lineToSegments.put(trace2Box, new ArrayList());
                l1 = new Label(this.dimensionDescriptions.get(pair.getKey()));
                Label label = new Label(this.dimensionDescriptions.get(pair.getValue()));
                VBox.setMargin((Node)l1, (Insets)HALF_MARGIN_INSETS);
                VBox.setMargin((Node)label, (Insets)HALF_MARGIN_INSETS);
                l1.setFont(VALUE_FONT);
                label.setFont(VALUE_FONT);
                pairBox.getChildren().addAll((Object[])new Node[]{l1, trace1Box, label, trace2Box});
                this.substLines.getChildren().add((Object)pairBox);
                pairBox.setBackground(c % 2 == 0 ? LINE_BACKGROUND : WHITE_BACKGROUND);
                trace1Box.setBackground(TRANSPARENT_BACKGROUND);
                trace2Box.setBackground(TRANSPARENT_BACKGROUND);
                ++c;
            }
            for (List list : inGroup) {
                VBox inVBox = new VBox();
                traceBox = new HBox();
                traceToLine.put(list, traceBox);
                this.lineToSegments.put(traceBox, new ArrayList());
                l = new Label(this.dimensionDescriptions.get(list));
                VBox.setMargin((Node)l, (Insets)HALF_MARGIN_INSETS);
                l.setFont(VALUE_FONT);
                inVBox.getChildren().addAll((Object[])new Node[]{l, traceBox});
                this.inLines.getChildren().add((Object)inVBox);
                traceBox.setBackground(c % 2 == 0 ? LINE_BACKGROUND : WHITE_BACKGROUND);
                ++c;
            }
            for (List list : delGroup) {
                VBox delVBox = new VBox();
                traceBox = new HBox();
                traceToLine.put(list, traceBox);
                this.lineToSegments.put(traceBox, new ArrayList());
                l = new Label(this.dimensionDescriptions.get(list));
                VBox.setMargin((Node)l, (Insets)HALF_MARGIN_INSETS);
                l.setFont(VALUE_FONT);
                delVBox.getChildren().addAll((Object[])new Node[]{l, traceBox});
                this.delLines.getChildren().add((Object)delVBox);
                traceBox.setBackground(c % 2 == 0 ? LINE_BACKGROUND : WHITE_BACKGROUND);
                ++c;
            }
            List<Diff> list = this.diffComputer.getDiffs();
            block10: for (Diff diff : list.subList(this.currentState, Math.min(this.currentState + this.nbDisplayableStates.intValue(), list.size()))) {
                int i = diff.idx1;
                int j = diff.idx2;
                switch (diff.kind) {
                    case EQ: {
                        String d;
                        String d2;
                        String d1;
                        Value v2;
                        Value v1;
                        List t2;
                        List t1;
                        State<?, ?> state1 = this.states1.get(i);
                        State<?, ?> state = this.states2.get(j);
                        this.addState(state1, this.line1, Color.SLATEBLUE, this.extractor1.getStateIndex(state1), this.extractor1.getStateDescription(state1));
                        this.addState(state, this.line2, Color.SLATEBLUE, this.extractor2.getStateIndex(state), this.extractor2.getStateDescription(state));
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : eqGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            v1 = (Value)t1.get(i);
                            v2 = (Value)t2.get(j);
                            d1 = this.extractor1.getValueDescription(v1);
                            d2 = this.extractor2.getValueDescription(v2);
                            this.addValue(v1, (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1));
                            this.addValue(v2, (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2));
                        }
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : substGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            v1 = (Value)t1.get(i);
                            v2 = (Value)t2.get(j);
                            d1 = this.extractor1.getValueDescription(v1);
                            d2 = this.extractor2.getValueDescription(v2);
                            this.addValue(v1, (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1));
                            this.addValue(v2, (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2));
                        }
                        for (List list2 : delGroup) {
                            d = this.extractor1.getValueDescription((Value)list2.get(i));
                            this.addValue((Value)list2.get(i), (HBox)traceToLine.get(list2), d, this.isNewValue(i, list2));
                        }
                        for (List list3 : inGroup) {
                            d = this.extractor2.getValueDescription((Value)list3.get(j));
                            this.addValue((Value)list3.get(j), (HBox)traceToLine.get(list3), d, this.isNewValue(j, list3));
                        }
                        continue block10;
                    }
                    case SUBST: {
                        String d2;
                        String d1;
                        String d;
                        List t2;
                        List t1;
                        State<?, ?> state1 = this.states1.get(i);
                        State<?, ?> state = this.states2.get(j);
                        this.addState(state1, this.line1, Color.TOMATO, this.extractor1.getStateIndex(state1), this.extractor1.getStateDescription(state1));
                        this.addState(state, this.line2, Color.TOMATO, this.extractor2.getStateIndex(state), this.extractor2.getStateDescription(state));
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : eqGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            d1 = this.extractor1.getValueDescription((Value)t1.get(i));
                            d2 = this.extractor2.getValueDescription((Value)t2.get(j));
                            this.addValue((Value)t1.get(i), (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1));
                            this.addValue((Value)t2.get(j), (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2));
                        }
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : substGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            d1 = this.extractor1.getValueDescription((Value)t1.get(i));
                            d2 = this.extractor2.getValueDescription((Value)t2.get(j));
                            if (this.diffComputer.compareEObjects((EObject)t1.get(i), (EObject)t2.get(j))) {
                                this.addValue((Value)t1.get(i), (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1));
                                this.addValue((Value)t2.get(j), (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2));
                                continue;
                            }
                            this.addValue((Value)t1.get(i), (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1), Diff.DiffKind.SUBST);
                            this.addValue((Value)t2.get(j), (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2), Diff.DiffKind.SUBST);
                        }
                        for (List list4 : delGroup) {
                            d = this.extractor1.getValueDescription((Value)list4.get(i));
                            this.addValue((Value)list4.get(i), (HBox)traceToLine.get(list4), d, this.isNewValue(i, list4));
                        }
                        for (List list5 : inGroup) {
                            d = this.extractor2.getValueDescription((Value)list5.get(j));
                            this.addValue((Value)list5.get(j), (HBox)traceToLine.get(list5), d, this.isNewValue(j, list5));
                        }
                        continue block10;
                    }
                    case DEL: {
                        String d;
                        String d2;
                        String d1;
                        List t2;
                        List t1;
                        State<?, ?> state1 = this.states1.get(i);
                        this.addState(state1, this.line1, Color.BROWN, this.extractor1.getStateIndex(state1), this.extractor1.getStateDescription(state1));
                        this.addBlankState(this.line2);
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : eqGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            d1 = this.extractor1.getValueDescription((Value)t1.get(i));
                            d2 = this.extractor2.getValueDescription((Value)t2.get(j));
                            this.addValue((Value)t1.get(i), (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1));
                            this.fillGap((HBox)traceToLine.get(t2), t2, j, d2);
                        }
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : substGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            d1 = this.extractor1.getValueDescription((Value)t1.get(i));
                            d2 = this.extractor2.getValueDescription((Value)t2.get(j));
                            this.addValue((Value)t1.get(i), (HBox)traceToLine.get(t1), d1, this.isNewValue(i, t1));
                            this.fillGap((HBox)traceToLine.get(t2), t2, j, d2);
                        }
                        for (List<Value<?>> list6 : delGroup) {
                            d = this.extractor1.getValueDescription(list6.get(i));
                            this.addValue(list6.get(i), (HBox)traceToLine.get(list6), d, this.isNewValue(i, list6));
                        }
                        for (List<Value<?>> list7 : inGroup) {
                            d = this.extractor2.getValueDescription(list7.get(j));
                            this.fillGap((HBox)traceToLine.get(list7), list7, j, d);
                        }
                        continue block10;
                    }
                    case IN: {
                        String d;
                        String d2;
                        String d1;
                        List t2;
                        List t1;
                        State<?, ?> state2 = this.states2.get(i);
                        this.addBlankState(this.line1);
                        this.addState(state2, this.line2, Color.BROWN, this.extractor2.getStateIndex(state2), this.extractor2.getStateDescription(state2));
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : eqGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            d1 = this.extractor1.getValueDescription((Value)t1.get(i));
                            d2 = this.extractor2.getValueDescription((Value)t2.get(j));
                            this.fillGap((HBox)traceToLine.get(t1), t1, i, d1);
                            this.addValue((Value)t2.get(j), (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2));
                        }
                        for (Pair<List<Value<?>>, List<Value<?>>> pair : substGroup) {
                            t1 = (List)pair.getKey();
                            t2 = (List)pair.getValue();
                            d1 = this.extractor1.getValueDescription((Value)t1.get(i));
                            d2 = this.extractor2.getValueDescription((Value)t2.get(j));
                            this.fillGap((HBox)traceToLine.get(t1), t1, i, d1);
                            this.addValue((Value)t2.get(j), (HBox)traceToLine.get(t2), d2, this.isNewValue(j, t2));
                        }
                        for (List<Value<?>> list8 : delGroup) {
                            d = this.extractor1.getValueDescription(list8.get(i));
                            this.fillGap((HBox)traceToLine.get(list8), list8, i, d);
                        }
                        for (List<Value<?>> list9 : inGroup) {
                            d = this.extractor2.getValueDescription(list9.get(j));
                            this.addValue(list9.get(j), (HBox)traceToLine.get(list9), d, this.isNewValue(j, list9));
                        }
                        continue block10;
                    }
                }
            }
            this.processSegments();
        }
    }

    private void processSegments() {
        for (Map.Entry<HBox, List<List<Diff.DiffKind>>> e : this.lineToSegments.entrySet()) {
            HBox line = e.getKey();
            List<String> descriptions = this.segmentToDescription.get(line);
            ObservableList children = line.getChildren();
            List<List<Diff.DiffKind>> segments = e.getValue();
            int idx = 0;
            for (List<Diff.DiffKind> segment : segments) {
                if (segment == null) {
                    Rectangle rectangle = new Rectangle(24.0, 8.0, (Paint)Color.TRANSPARENT);
                    HBox.setMargin((Node)rectangle, (Insets)MARGIN_INSETS);
                    children.add(rectangle);
                    continue;
                }
                Diff.DiffKind[] seg = new Diff.DiffKind[segment.size()];
                int i = 0;
                while (i < seg.length) {
                    seg[i] = segment.get(i);
                    ++i;
                }
                String description = descriptions.get(idx);
                ValueView view = new ValueView(description, seg);
                HBox.setMargin((Node)view, (Insets)MARGIN_INSETS);
                children.add(view);
                ++idx;
            }
        }
    }
}

