/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.query.ViewpointURIQuery;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointState;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class Entry {
    private final URI identifier;
    private final Viewpoint viewpoint;
    private final Set<URI> conflicts = Sets.newHashSet();
    private final Set<URI> reused = Sets.newHashSet();
    private final Set<URI> customizes = Sets.newHashSet();
    private ViewpointState state;
    private final Collection<Diagnostic> diagnostics = Lists.newArrayList();

    public Entry(Viewpoint viewpoint) {
        this.viewpoint = (Viewpoint)Preconditions.checkNotNull((Object)viewpoint);
        Preconditions.checkState((viewpoint.eResource() != null ? 1 : 0) != 0);
        Option<URI> id = new ViewpointQuery(this.viewpoint).getViewpointURI();
        assert (id.some());
        this.identifier = (URI)id.get();
        this.state = ViewpointState.UNDEFINED;
        this.fillDepdendencies(this.conflicts, (List<URI>)viewpoint.getConflicts());
        this.fillDepdendencies(this.reused, (List<URI>)viewpoint.getReuses());
        this.fillDepdendencies(this.customizes, (List<URI>)viewpoint.getCustomizes());
    }

    public URI getLogicalURI() {
        return this.identifier;
    }

    public Viewpoint getSirius() {
        return this.viewpoint;
    }

    public Resource getResource() {
        return this.viewpoint.eResource();
    }

    public ViewpointState getState() {
        return this.state;
    }

    public void setState(ViewpointState state) {
        this.state = (ViewpointState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
    }

    public Collection<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public Set<URI> getDeclaredDependencies() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.reused);
        result.addAll(this.customizes);
        return Collections.unmodifiableSet(result);
    }

    private void fillDepdendencies(Set<URI> uris, List<URI> declared) {
        for (URI uri : declared) {
            try {
                if (!ViewpointURIQuery.isValidViewpointURI(uri)) continue;
                uris.add(uri);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public Set<URI> getActualDependencies() {
        HashSet result = Sets.newHashSet();
        EObjectQuery q = new EObjectQuery(this.viewpoint);
        result.addAll(q.getResolvedDependencies());
        result.addAll(q.getUnresolvedDependencies());
        result.remove(URIQuery.VIEWPOINT_ENVIRONMENT_QUERY);
        return result;
    }

    public String toString() {
        return this.identifier.toString();
    }
}

