/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.synchronizer.AutomaticCreator;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.AbstractCreatedDTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeItemMappingExpression;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeMappingProvider;
import org.eclipse.sirius.tree.description.TreeItemMapping;

class TreeItemCreator
implements AutomaticCreator {
    private TreeItemMapping nm;
    private TreeMappingProvider provider;

    TreeItemCreator(TreeItemMapping nm, TreeMappingProvider provider) {
        this.nm = nm;
        this.provider = provider;
    }

    public Collection<? extends OutputDescriptor> computeDescriptors(CreatedOutput context, Iterator<EObject> it) {
        final AbstractCreatedDTreeItemContainer castedContext = (AbstractCreatedDTreeItemContainer)context;
        Predicate<OutputTreeItemDescriptor> filterPredicates = new Predicate<OutputTreeItemDescriptor>(){

            public boolean apply(OutputTreeItemDescriptor input) {
                return new TreeItemMappingExpression(castedContext.getGlobalContext(), input.getMapping().getDescription()).checkPrecondition(input.getSourceElement(), input.getViewContainer());
            }
        };
        ArrayList outputs = Lists.newArrayList();
        int i = 0;
        while (it.hasNext()) {
            EObject from = it.next();
            outputs.add(new OutputTreeItemDescriptor((DTreeItemContainer)context.getCreatedElement(), from, this.nm, i, this.provider));
            ++i;
        }
        return Collections2.filter((Collection)outputs, (Predicate)filterPredicates);
    }
}

