/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.print;

import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintCallback;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintHelper;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintJobParameters;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;

public class SWTPrintHelper
implements PrintHelper {
    private Printer printer;
    private PrintCallback callback;
    private double scaleFactor;
    private Rectangle trim;
    private Display display;

    public SWTPrintHelper(final PrinterData data, Display display, PrintCallback callback) {
        this.callback = callback;
        this.display = display;
        RunnableWithResult.Impl runnable = new RunnableWithResult.Impl(){

            public void run() {
                this.setResult(new Printer(data));
            }
        };
        display.syncExec((Runnable)runnable);
        this.printer = (Printer)runnable.getResult();
        this.computeScale();
        this.trim = this.printer.computeTrim(0, 0, 0, 0);
    }

    private void computeScale() {
        double dpiScale;
        RunnableWithResult.Impl runnable = new RunnableWithResult.Impl(){

            public void run() {
                this.setResult(SWTPrintHelper.this.display.getDPI());
            }
        };
        this.display.syncExec((Runnable)runnable);
        Point screenDPI = (Point)runnable.getResult();
        Point printerDPI = this.printer.getDPI();
        this.scaleFactor = dpiScale = (double)printerDPI.x / (double)screenDPI.x;
    }

    @Override
    public void launchPrintJob(String name) {
        this.launchPrintJobIntern(name);
    }

    private void launchPrintJobIntern(String name) {
        if (this.printer.startJob(name)) {
            this.callback.setParameters(new PrintJobParameters(this.printer, this.scaleFactor, this.trim));
            int pageNumber = this.callback.numberOfPages();
            int i = 0;
            while (i < pageNumber) {
                this.launchPrintPage(i);
                ++i;
            }
            this.printer.endJob();
        }
    }

    private void launchPrintPage(int page) {
        if (this.printer.startPage()) {
            this.callback.printPage(page);
            this.printer.endPage();
        }
    }

    @Override
    public void dispose() {
        this.printer.dispose();
    }
}

