/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.rename;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.m2e.refactoring.AbstractPomRefactoring;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.m2e.refactoring.PomVisitor;
import org.eclipse.m2e.refactoring.RefactoringModelResources;
import org.eclipse.m2e.refactoring.rename.MavenRenameWizardPage;
import org.eclipse.osgi.util.NLS;

public class RenameRefactoring
extends AbstractPomRefactoring {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String VERSION = "version";
    private static final String GETVERSION = Messages.RenameRefactoring_1;
    private static final String ARTIFACT_ID = "artifactId";
    private static final String GETARTIFACT_ID = "getArtifactId";
    private static final String GROUP_ID = "groupId";
    private static final String GETGROUP_ID = "getGroupId";
    MavenRenameWizardPage page;
    String oldGroupId;
    String oldArtifactId;
    String oldVersion;

    public RenameRefactoring(IFile file, MavenRenameWizardPage page) {
        super(file);
        this.page = page;
    }

    private Object getElement(Object root, Path path) {
        if (path == null || path.path.size() == 0) {
            return root;
        }
        PathElement current = path.path.remove(0);
        String getterName = "get" + current.element;
        try {
            Method getter = root.getClass().getMethod(getterName, new Class[0]);
            root = this.getElement(getter.invoke(root, EMPTY_OBJECT_ARRAY), path);
            if (root instanceof List) {
                List children = (List)root;
                int i = 0;
                while (i < children.size()) {
                    Object child = children.get(i);
                    Method artifact = child.getClass().getMethod(GETARTIFACT_ID, new Class[0]);
                    String artifactId = (String)artifact.invoke(child, EMPTY_OBJECT_ARRAY);
                    if (current.artifactId == null || current.artifactId.equals(artifactId)) {
                        return this.getElement(child, path);
                    }
                    ++i;
                }
            } else {
                return this.getElement(root, path);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private List<EObjectWithPath> scanModel(Model model, String groupId, String artifactId, String version, boolean processRoot) {
        ArrayList<EObjectWithPath> res = new ArrayList<EObjectWithPath>();
        Path path = new Path();
        if (processRoot) {
            this.scanObject(path, (EObject)model, groupId, artifactId, version, res);
        } else {
            this.scanChildren(path, (EObject)model, groupId, artifactId, version, res);
        }
        return res;
    }

    private List<EObjectWithPath> scanObject(Path current, EObject obj, String groupId, String artifactId, String version, List<EObjectWithPath> res) {
        if (this.scanFeature(obj, ARTIFACT_ID, artifactId)) {
            res.add(new EObjectWithPath(obj, current));
        }
        this.scanChildren(current, obj, groupId, artifactId, version, res);
        return res;
    }

    private List<EObjectWithPath> scanChildren(Path current, EObject obj2, String groupId, String artifactId, String version, List<EObjectWithPath> res) {
        for (EObject obj2 : obj2.eContents()) {
            Path child = current.clone();
            String element = obj2.eContainingFeature().getName();
            element = String.valueOf(element.substring(0, 1).toUpperCase()) + element.substring(1);
            child.addElement(element, artifactId);
            this.scanObject(child, obj2, groupId, artifactId, version, res);
        }
        return res;
    }

    private boolean scanFeature(EObject obj, String featureName, String value) {
        String val;
        if (value == null) {
            return false;
        }
        EStructuralFeature feature = obj.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return false;
        }
        String string = val = obj.eGet(feature) == null ? null : obj.eGet(feature).toString();
        return value.equals(val);
    }

    private String getValue(EObject obj, String featureName) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        return obj.eGet(feature) == null ? null : obj.eGet(feature).toString();
    }

    @Override
    public String getNewProjectName() {
        return this.page.getRenameEclipseProject() ? this.page.getNewArtifactId() : null;
    }

    public CompoundCommand applyModel(RefactoringModelResources model, String newGroupId, String newArtifactId, String newVersion, boolean processRoot) throws Exception {
        List<EObjectWithPath> affected = this.scanModel(model.getTmpModel(), this.oldGroupId, this.oldArtifactId, this.oldVersion, processRoot);
        Iterator<EObjectWithPath> i = affected.iterator();
        CompoundCommand command = new CompoundCommand();
        while (i.hasNext()) {
            EObjectWithPath obj = i.next();
            Object effectiveObj = this.getElement(model.getEffective(), obj.path.clone());
            if (effectiveObj == null) continue;
            Method method = effectiveObj.getClass().getMethod(GETVERSION, new Class[0]);
            String effectiveVersion = (String)method.invoke(effectiveObj, EMPTY_OBJECT_ARRAY);
            method = effectiveObj.getClass().getMethod(GETGROUP_ID, new Class[0]);
            String effectiveGroupId = (String)method.invoke(effectiveObj, EMPTY_OBJECT_ARRAY);
            if (this.oldVersion != null && !this.oldVersion.equals(effectiveVersion)) continue;
            if (this.oldGroupId != null && this.oldGroupId.equals(effectiveGroupId)) {
                this.applyFeature(this.editingDomain, model, GROUP_ID, newGroupId, command, obj);
            }
            this.applyFeature(this.editingDomain, model, ARTIFACT_ID, newArtifactId, command, obj);
            if ("".equals(newVersion)) continue;
            this.applyFeature(this.editingDomain, model, VERSION, newVersion, command, obj);
        }
        return command.isEmpty() ? null : command;
    }

    private void applyFeature(AdapterFactoryEditingDomain editingDomain, RefactoringModelResources model, String feature, String newValue, CompoundCommand command, EObjectWithPath obj) {
        RefactoringModelResources.PropertyInfo info = null;
        String old = this.getValue(obj.object, feature);
        if (old != null && old.startsWith("${")) {
            String pName = old.substring(2);
            pName = pName.substring(0, pName.length() - 1).trim();
            info = model.getProperties().get(pName);
        }
        if (info != null) {
            info.setNewValue((Command)new SetCommand((EditingDomain)editingDomain, (EObject)info.getPair(), info.getPair().eClass().getEStructuralFeature("value"), (Object)newValue));
        } else {
            this.applyObject(editingDomain, command, obj.object, feature, newValue);
        }
    }

    private void applyObject(AdapterFactoryEditingDomain editingDomain, CompoundCommand command, EObject obj, String featureName, String value) {
        EStructuralFeature feature = obj.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return;
        }
        Object old = obj.eGet(feature);
        if (old == null || old.equals(value)) {
            return;
        }
        command.append((Command)new SetCommand((EditingDomain)editingDomain, obj, feature, (Object)value));
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        PomResourceImpl resource = AbstractPomRefactoring.loadResource(this.file);
        try {
            Model model = (Model)resource.getContents().get(0);
            this.oldArtifactId = model.getArtifactId();
            this.oldGroupId = model.getGroupId();
            this.oldVersion = model.getVersion();
        }
        finally {
            resource.unload();
        }
        RefactoringStatus res = new RefactoringStatus();
        return res;
    }

    public String getName() {
        return Messages.RenameRefactoring_name;
    }

    @Override
    public PomVisitor getVisitor() {
        return new PomVisitor(){

            @Override
            public CompoundCommand applyChanges(RefactoringModelResources current, IProgressMonitor pm) throws Exception {
                boolean processRoot = current.getPomFile().equals((Object)RenameRefactoring.this.file);
                return RenameRefactoring.this.applyModel(current, RenameRefactoring.this.page.getNewGroupId(), RenameRefactoring.this.page.getNewArtifactId(), RenameRefactoring.this.page.getNewVersion(), processRoot);
            }
        };
    }

    @Override
    public boolean scanAllArtifacts() {
        return true;
    }

    @Override
    public String getTitle() {
        return NLS.bind((String)Messages.RenameRefactoring_title, (Object)this.file.getParent().getName());
    }

    static class EObjectWithPath {
        public EObject object;
        public Path path;

        public EObjectWithPath(EObject object, Path path) {
            this.object = object;
            this.path = path;
        }
    }

    static class Path {
        List<PathElement> path = new ArrayList<PathElement>();

        Path() {
        }

        public void addElement(String element, String artifactId) {
            this.path.add(new PathElement(element, artifactId));
        }

        public String toString() {
            return this.path.toString();
        }

        public Path clone() {
            Path res = new Path();
            res.path = new ArrayList<PathElement>(this.path);
            return res;
        }
    }

    static class PathElement {
        String element;
        String artifactId;

        public PathElement(String element, String artifactId) {
            this.element = element;
            this.artifactId = artifactId;
        }

        public String toString() {
            return "/" + this.element + "[artifactId=" + this.artifactId + "]";
        }
    }

    static interface ScanVisitor {
        public boolean interested(EObject var1);
    }
}

