/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jdt.ui.cleanup.ICleanUpConfigurationUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ContributedCleanUpTabPage
extends CleanUpTabPage {
    private final ICleanUpConfigurationUI fContribution;

    public ContributedCleanUpTabPage(ICleanUpConfigurationUI contribution) {
        this.fContribution = contribution;
    }

    @Override
    public void setWorkingValues(Map<String, String> workingValues) {
        super.setWorkingValues(workingValues);
        final CleanUpOptions options = new CleanUpOptions(workingValues){

            @Override
            public void setOption(String key, String value) {
                super.setOption(key, value);
                ContributedCleanUpTabPage.this.doUpdatePreview();
                ContributedCleanUpTabPage.this.notifyValuesModified();
            }
        };
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ContributedCleanUpTabPage.this.handleException(exception);
            }

            public void run() throws Exception {
                ContributedCleanUpTabPage.this.fContribution.setOptions(options);
            }
        });
    }

    @Override
    public void setOptions(CleanUpOptions options) {
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        final Composite parent = new Composite(composite, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = numColumns;
        parent.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ContributedCleanUpTabPage.this.handleException(exception);
                Label label = new Label(parent, 0);
                label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                label.setText(CleanUpMessages.ContributedCleanUpTabPage_ErrorPage_message);
            }

            public void run() throws Exception {
                ContributedCleanUpTabPage.this.fContribution.createContents(parent);
            }
        });
    }

    @Override
    public String getPreview() {
        final String[] result = new String[]{""};
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ContributedCleanUpTabPage.this.handleException(exception);
            }

            public void run() throws Exception {
                result[0] = ContributedCleanUpTabPage.this.fContribution.getPreview();
            }
        });
        return result[0];
    }

    @Override
    public int getSelectedCleanUpCount() {
        final int[] result = new int[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ContributedCleanUpTabPage.this.handleException(exception);
            }

            public void run() throws Exception {
                int count = ContributedCleanUpTabPage.this.fContribution.getSelectedCleanUpCount();
                Assert.isTrue((count >= 0 && count <= ContributedCleanUpTabPage.this.getCleanUpCount() ? 1 : 0) != 0);
                result[0] = count;
            }
        });
        return result[0];
    }

    @Override
    public int getCleanUpCount() {
        final int[] result = new int[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ContributedCleanUpTabPage.this.handleException(exception);
            }

            public void run() throws Exception {
                result[0] = ContributedCleanUpTabPage.this.fContribution.getCleanUpCount();
            }
        });
        return result[0];
    }

    private void handleException(Throwable exception) {
        JavaPlugin.log(exception);
    }
}

