/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.ide.actions.global;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ResourceGlobalActionHandler;
import org.eclipse.gmf.runtime.common.ui.action.ide.internal.l10n.CommonUIActionIDEMessages;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyResourceGlobalActionHandler
extends ResourceGlobalActionHandler {
    public ICommand getCommand(IGlobalActionContext cntxt) {
        List selectedResources = this.getResourceSelection((IStructuredSelection)cntxt.getSelection()).toList();
        IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                fileNames[actualLength++] = location.toOSString();
            }
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(resources[i].getName());
            ++i;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            int i2 = 0;
            while (i2 < actualLength) {
                fileNames[i2] = tempFileNames[i2];
                ++i2;
            }
        }
        this.setClipboard(resources, fileNames, buf.toString(), cntxt.getActivePart());
        return null;
    }

    private void setClipboard(IResource[] resources, String[] fileNames, String names, IWorkbenchPart part) {
        block5: {
            try {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                if (fileNames.length > 0) {
                    clipboard.setContents(new Object[]{resources, fileNames, names}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    clipboard.setContents(new Object[]{resources, names}, new Transfer[]{ResourceTransfer.getInstance(), TextTransfer.getInstance()});
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(part), (String)CommonUIActionIDEMessages.CopyToClipboardProblemDialog_title, (String)CommonUIActionIDEMessages.CopyToClipboardProblemDialog_message)) break block5;
                this.setClipboard(resources, fileNames, names, part);
            }
        }
    }
}

