/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards.pages;

import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class AskLanguageNameWizardPage
extends WizardPage {
    private Text _nameField;
    private String _initialLanguageName;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = AskLanguageNameWizardPage.this.validatePage();
            AskLanguageNameWizardPage.this.setPageComplete(valid);
        }
    };

    public AskLanguageNameWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void setLanguageName(String name) {
        if (name == null) {
            this._initialLanguageName = null;
        } else {
            int indexOfFirstPoint = name.lastIndexOf(".");
            String intermediateString = name.trim();
            if (indexOfFirstPoint != -1 && intermediateString.length() > indexOfFirstPoint) {
                intermediateString = intermediateString.substring(indexOfFirstPoint + 1);
            }
            this._initialLanguageName = intermediateString.replaceAll("\\W", "").replaceAll(" ", "");
        }
        if (this._nameField != null) {
            this._nameField.setText(this._initialLanguageName);
        }
    }

    public String getLanguageName() {
        return this._nameField.getText();
    }

    private boolean validatePage() {
        boolean ok = false;
        if (this.getLanguageName().length() > 2) {
            ok = Character.isJavaIdentifierStart(this.getLanguageName().charAt(0));
            char[] cArray = this.getLanguageName().substring(1).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                ok = ok && Character.isJavaIdentifierPart(c);
                ++n2;
            }
        }
        return ok;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText("Language name");
        label.setFont(parent.getFont());
        this._nameField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this._nameField.setLayoutData((Object)data);
        this._nameField.setFont(parent.getFont());
        if (this._initialLanguageName != null) {
            this._nameField.setText(this._initialLanguageName);
        }
        this._nameField.addListener(24, this.nameModifyListener);
        BidiUtils.applyBidiProcessing((Text)this._nameField, (String)"default");
        this.setControl((Control)composite);
    }
}

