/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.tracemetamodel.StepStrings;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class TraceMMGeneratorSteps {
  private final OperationalSemanticsView mmext;
  
  private final TraceMMExplorer traceMMExplorer;
  
  private final boolean gemoc;
  
  private final EPackage tracemmresult;
  
  private final TraceMMGenerationTraceability traceability;
  
  private final Map<Rule, EClass> stepRuleToClass = new HashMap<Rule, EClass>();
  
  private final String randomStringToFindGetCallerAnnotations = Integer.valueOf(new Random(10000).nextInt()).toString();
  
  private final static String GET_CALLER_OPERATION_NAME = "getCaller";
  
  public TraceMMGeneratorSteps(final OperationalSemanticsView mmext, final EPackage tracemmresult, final TraceMMGenerationTraceability traceability, final TraceMMExplorer traceMMExplorer, final boolean gemoc) {
    this.traceability = traceability;
    this.tracemmresult = tracemmresult;
    this.traceMMExplorer = traceMMExplorer;
    this.mmext = mmext;
    this.gemoc = gemoc;
  }
  
  private void debug(final Object stuff) {
  }
  
  private Set<Rule> gatherRulesThatOverride(final Rule rule) {
    final Set<Rule> result = new HashSet<Rule>();
    result.add(rule);
    EList<Rule> _overridenBy = rule.getOverridenBy();
    result.addAll(_overridenBy);
    EList<Rule> _overridenBy_1 = rule.getOverridenBy();
    for (final Rule ov : _overridenBy_1) {
      Set<Rule> _gatherRulesThatOverride = this.gatherRulesThatOverride(ov);
      result.addAll(_gatherRulesThatOverride);
    }
    return result;
  }
  
  private Set<Rule> gatherStepCalls(final Rule rule, final Set<Rule> inProgress) {
    final Set<Rule> result = new HashSet<Rule>();
    boolean _contains = inProgress.contains(rule);
    boolean _not = (!_contains);
    if (_not) {
      inProgress.add(rule);
      boolean _isStepRule = rule.isStepRule();
      if (_isStepRule) {
        result.add(rule);
      } else {
        EList<Rule> _calledRules = rule.getCalledRules();
        for (final Rule called : _calledRules) {
          {
            final Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
            result.addAll(gathered);
          }
        }
      }
    }
    return result;
  }
  
  private EClass getStepClass(final Rule stepRule) {
    boolean _containsKey = this.stepRuleToClass.containsKey(stepRule);
    if (_containsKey) {
      return this.stepRuleToClass.get(stepRule);
    } else {
      final EClass stepClass = EcoreFactory.eINSTANCE.createEClass();
      EList<EClassifier> _eClassifiers = this.traceMMExplorer.stepsPackage.getEClassifiers();
      _eClassifiers.add(stepClass);
      this.stepRuleToClass.put(stepRule, stepClass);
      this.traceability.addStepRuleToStepClass(stepRule, stepClass);
      return stepClass;
    }
  }
  
  private void setClassNameWithoutConflict(final EClass clazz, final String name) {
    TreeIterator<EObject> _eAllContents = this.tracemmresult.eAllContents();
    Set<EObject> _set = IteratorExtensions.<EObject>toSet(_eAllContents);
    Iterable<EClass> _filter = Iterables.<EClass>filter(_set, EClass.class);
    final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        return Boolean.valueOf(((!Objects.equal(c.getName(), null)) && c.getName().startsWith(name)));
      }
    };
    Iterable<EClass> _filter_1 = IterableExtensions.<EClass>filter(_filter, _function);
    final int nbExistingClassesWithName = IterableExtensions.size(_filter_1);
    if ((nbExistingClassesWithName > 0)) {
      clazz.setName(((name + "_") + Integer.valueOf(nbExistingClassesWithName)));
    } else {
      clazz.setName(name);
    }
  }
  
  public void process() {
    EList<Rule> _rules = this.mmext.getRules();
    for (final Rule rule : _rules) {
      EList<Rule> _calledRules = rule.getCalledRules();
      List<Rule> _immutableCopy = ImmutableList.<Rule>copyOf(_calledRules);
      for (final Rule calledRule : _immutableCopy) {
        {
          final Set<Rule> overrides = this.gatherRulesThatOverride(calledRule);
          EList<Rule> _calledRules_1 = rule.getCalledRules();
          _calledRules_1.addAll(overrides);
        }
      }
    }
    EList<Rule> _rules_1 = this.mmext.getRules();
    final Predicate<Rule> _function = new Predicate<Rule>() {
      @Override
      public boolean test(final Rule it) {
        return it.isAbstract();
      }
    };
    _rules_1.removeIf(_function);
    EList<Rule> _rules_2 = this.mmext.getRules();
    for (final Rule rule_1 : _rules_2) {
      EList<Rule> _calledRules_1 = rule_1.getCalledRules();
      final Predicate<Rule> _function_1 = new Predicate<Rule>() {
        @Override
        public boolean test(final Rule it) {
          return it.isAbstract();
        }
      };
      _calledRules_1.removeIf(_function_1);
    }
    EList<Rule> _rules_3 = this.mmext.getRules();
    final Function1<Rule, Boolean> _function_2 = new Function1<Rule, Boolean>() {
      @Override
      public Boolean apply(final Rule r) {
        return Boolean.valueOf(r.isStepRule());
      }
    };
    Iterable<Rule> _filter = IterableExtensions.<Rule>filter(_rules_3, _function_2);
    final Set<Rule> stepRules = IterableExtensions.<Rule>toSet(_filter);
    Set<Rule> _immutableCopy_1 = ImmutableSet.<Rule>copyOf(stepRules);
    for (final Rule rule_2 : _immutableCopy_1) {
      {
        final Set<Rule> overrides = this.gatherRulesThatOverride(rule_2);
        for (final Rule o : overrides) {
          {
            o.setStepRule(true);
            stepRules.add(o);
          }
        }
      }
    }
    for (final Rule rule_3 : stepRules) {
      {
        EList<Rule> _calledRules_2 = rule_3.getCalledRules();
        final Function1<Rule, Boolean> _function_3 = new Function1<Rule, Boolean>() {
          @Override
          public Boolean apply(final Rule r) {
            boolean _isStepRule = r.isStepRule();
            return Boolean.valueOf((!_isStepRule));
          }
        };
        Iterable<Rule> _filter_1 = IterableExtensions.<Rule>filter(_calledRules_2, _function_3);
        final Set<Rule> calledNonStepRules = IterableExtensions.<Rule>toSet(_filter_1);
        for (final Rule called : calledNonStepRules) {
          {
            final Set<Rule> inProgress = new HashSet<Rule>();
            final Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
            EList<Rule> _calledRules_3 = rule_3.getCalledRules();
            _calledRules_3.addAll(gathered);
          }
        }
        EList<Rule> _calledRules_3 = rule_3.getCalledRules();
        _calledRules_3.removeAll(calledNonStepRules);
      }
    }
    EList<Rule> _rules_4 = this.mmext.getRules();
    _rules_4.clear();
    EList<Rule> _rules_5 = this.mmext.getRules();
    _rules_5.addAll(stepRules);
    final Function1<Rule, String> _function_3 = new Function1<Rule, String>() {
      @Override
      public String apply(final Rule r) {
        EClass _containingClass = r.getContainingClass();
        String _name = _containingClass.getName();
        String _plus = (_name + ".");
        EOperation _operation = r.getOperation();
        String _name_1 = _operation.getName();
        String _plus_1 = (_plus + _name_1);
        String _plus_2 = (_plus_1 + ": ");
        EList<Rule> _calledRules = r.getCalledRules();
        boolean _isEmpty = _calledRules.isEmpty();
        boolean _not = (!_isEmpty);
        return (_plus_2 + Boolean.valueOf(_not));
      }
    };
    final Iterable<String> prettyStepRules = IterableExtensions.<Rule, String>map(stepRules, _function_3);
    this.debug(prettyStepRules);
    EClass _specificTraceClass = this.traceMMExplorer.getSpecificTraceClass();
    EList<EGenericType> _eGenericSuperTypes = _specificTraceClass.getEGenericSuperTypes();
    EGenericType _head = IterableExtensions.<EGenericType>head(_eGenericSuperTypes);
    EClassifier _eClassifier = _head.getEClassifier();
    final Resource mseMetamodelResource = _eClassifier.eResource();
    TreeIterator<EObject> _allContents = mseMetamodelResource.getAllContents();
    Set<EObject> _set = IteratorExtensions.<EObject>toSet(_allContents);
    Iterable<EClass> _filter_1 = Iterables.<EClass>filter(_set, EClass.class);
    final Function1<EClass, Boolean> _function_4 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass it) {
        String _name = it.getName();
        return Boolean.valueOf(_name.equals("SequentialStep"));
      }
    };
    final EClass mseSequentialStepClass = IterableExtensions.<EClass>findFirst(_filter_1, _function_4);
    TreeIterator<EObject> _allContents_1 = mseMetamodelResource.getAllContents();
    Set<EObject> _set_1 = IteratorExtensions.<EObject>toSet(_allContents_1);
    Iterable<EClass> _filter_2 = Iterables.<EClass>filter(_set_1, EClass.class);
    final Function1<EClass, Boolean> _function_5 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass it) {
        String _name = it.getName();
        return Boolean.valueOf(_name.equals("SmallStep"));
      }
    };
    final EClass mseSmallStepClass = IterableExtensions.<EClass>findFirst(_filter_2, _function_5);
    for (final Rule stepRule : stepRules) {
      {
        final EClass stepClass = this.getStepClass(stepRule);
        EOperation _operation = stepRule.getOperation();
        String _name = _operation.getName();
        stepClass.setName(_name);
        if ((this.gemoc && (!Objects.equal(stepRule.getContainingClass(), null)))) {
          final EOperation getCallerEOperation = EcoreFactory.eINSTANCE.createEOperation();
          EClass _containingClass = stepRule.getContainingClass();
          final EClass tracedClass = this.traceability.getTracedClass(_containingClass);
          EClass _xifexpression = null;
          boolean _equals = Objects.equal(tracedClass, null);
          if (_equals) {
            _xifexpression = stepRule.getContainingClass();
          } else {
            _xifexpression = tracedClass;
          }
          getCallerEOperation.setEType(_xifexpression);
          getCallerEOperation.setLowerBound(1);
          getCallerEOperation.setUpperBound(1);
          getCallerEOperation.setName(TraceMMGeneratorSteps.GET_CALLER_OPERATION_NAME);
          final EAnnotation bodyAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
          EList<EAnnotation> _eAnnotations = getCallerEOperation.getEAnnotations();
          _eAnnotations.add(bodyAnnotation);
          bodyAnnotation.setSource(GenModelPackage.eNS_URI);
          EMap<String, String> _details = bodyAnnotation.getDetails();
          _details.put("body", this.randomStringToFindGetCallerAnnotations);
          EList<EOperation> _eOperations = stepClass.getEOperations();
          _eOperations.add(getCallerEOperation);
        } else {
          EClass _containingClass_1 = stepRule.getContainingClass();
          EcoreCraftingUtil.addReferenceToClass(stepClass, "this", _containingClass_1);
        }
        EClass _containingClass_2 = stepRule.getContainingClass();
        EOperation _operation_1 = stepRule.getOperation();
        String _stepClassName = StepStrings.stepClassName(_containingClass_2, _operation_1);
        this.setClassNameWithoutConflict(stepClass, _stepClassName);
        String _ref_createTraceClassToStepClass = TraceMMStrings.ref_createTraceClassToStepClass(stepClass);
        final EReference ref = EcoreCraftingUtil.addReferenceToClass(this.traceMMExplorer.specificTraceClass, _ref_createTraceClassToStepClass, stepClass);
        ref.setLowerBound(0);
        ref.setUpperBound((-1));
        ref.setContainment(false);
        this.traceability.addStepSequence(stepClass, ref);
        this.traceability.addStepClass(stepClass);
        EList<EClass> _eSuperTypes = stepClass.getESuperTypes();
        EClass _specificStepClass = this.traceMMExplorer.getSpecificStepClass();
        _eSuperTypes.add(_specificStepClass);
        EList<Rule> _calledRules_2 = stepRule.getCalledRules();
        boolean _isEmpty = _calledRules_2.isEmpty();
        if (_isEmpty) {
          final EGenericType smallStepGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
          smallStepGenericSuperType.setEClassifier(mseSmallStepClass);
          final EGenericType smallStepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          EList<EGenericType> _eTypeArguments = smallStepGenericSuperType.getETypeArguments();
          _eTypeArguments.add(smallStepTypeBinding);
          smallStepTypeBinding.setEClassifier(this.traceMMExplorer.specificStateClass);
          EList<EGenericType> _eGenericSuperTypes_1 = stepClass.getEGenericSuperTypes();
          _eGenericSuperTypes_1.add(smallStepGenericSuperType);
        } else {
          this.traceability.addBigStepClass(stepClass);
          final EGenericType genericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
          genericSuperType.setEClassifier(mseSequentialStepClass);
          final EGenericType stepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          final EGenericType stateTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          EList<EGenericType> _eTypeArguments_1 = genericSuperType.getETypeArguments();
          CollectionExtensions.<EGenericType>addAll(_eTypeArguments_1, stepTypeBinding, stateTypeBinding);
          EList<EGenericType> _eGenericSuperTypes_2 = stepClass.getEGenericSuperTypes();
          _eGenericSuperTypes_2.add(genericSuperType);
          final EClass subStepSuperClass = EcoreFactory.eINSTANCE.createEClass();
          EList<EClassifier> _eClassifiers = this.traceMMExplorer.stepsPackage.getEClassifiers();
          _eClassifiers.add(subStepSuperClass);
          EClass _containingClass_3 = stepRule.getContainingClass();
          EOperation _operation_2 = stepRule.getOperation();
          String _abstractSubStepClassName = StepStrings.abstractSubStepClassName(_containingClass_3, _operation_2);
          this.setClassNameWithoutConflict(subStepSuperClass, _abstractSubStepClassName);
          subStepSuperClass.setAbstract(true);
          subStepSuperClass.setInterface(true);
          EList<EClass> _eSuperTypes_1 = subStepSuperClass.getESuperTypes();
          _eSuperTypes_1.add(this.traceMMExplorer.specificStepClass);
          stepTypeBinding.setEClassifier(subStepSuperClass);
          stateTypeBinding.setEClassifier(this.traceMMExplorer.specificStateClass);
          final EClass implicitStepClass = EcoreFactory.eINSTANCE.createEClass();
          EList<EClassifier> _eClassifiers_1 = this.traceMMExplorer.stepsPackage.getEClassifiers();
          _eClassifiers_1.add(implicitStepClass);
          EClass _containingClass_4 = stepRule.getContainingClass();
          EOperation _operation_3 = stepRule.getOperation();
          String _implicitStepClassName = StepStrings.implicitStepClassName(_containingClass_4, _operation_3);
          this.setClassNameWithoutConflict(implicitStepClass, _implicitStepClassName);
          EList<EClass> _eSuperTypes_2 = implicitStepClass.getESuperTypes();
          _eSuperTypes_2.add(subStepSuperClass);
          final EGenericType smallStepGenericSuperType_1 = EcoreFactory.eINSTANCE.createEGenericType();
          smallStepGenericSuperType_1.setEClassifier(mseSmallStepClass);
          final EGenericType smallStepTypeBinding_1 = EcoreFactory.eINSTANCE.createEGenericType();
          EList<EGenericType> _eTypeArguments_2 = smallStepGenericSuperType_1.getETypeArguments();
          _eTypeArguments_2.add(smallStepTypeBinding_1);
          smallStepTypeBinding_1.setEClassifier(this.traceMMExplorer.specificStateClass);
          EList<EGenericType> _eGenericSuperTypes_3 = implicitStepClass.getEGenericSuperTypes();
          _eGenericSuperTypes_3.add(smallStepGenericSuperType_1);
          EClass _containingClass_5 = stepRule.getContainingClass();
          this.traceability.putImplicitStepClass(implicitStepClass, _containingClass_5);
          EList<Rule> _calledRules_3 = stepRule.getCalledRules();
          for (final Rule calledStepRule : _calledRules_3) {
            {
              final EClass subStepClass = this.getStepClass(calledStepRule);
              EList<EClass> _eSuperTypes_3 = subStepClass.getESuperTypes();
              _eSuperTypes_3.add(subStepSuperClass);
            }
          }
        }
      }
    }
  }
  
  /**
   * To generate the code of 'getCaller' operations inside the trace metamodel, thanks to the exact FQNs
   * of the generated java classes computed using the genmodel.
   */
  public void addGetCallerEOperations(final Set<EPackage> traceMetamodel, final Set<GenPackage> packages) {
    for (final EPackage p : traceMetamodel) {
      TreeIterator<EObject> _eAllContents = p.eAllContents();
      Iterator<EOperation> _filter = Iterators.<EOperation>filter(_eAllContents, EOperation.class);
      Set<EOperation> _set = IteratorExtensions.<EOperation>toSet(_filter);
      for (final EOperation operation : _set) {
        {
          EList<EAnnotation> _eAnnotations = operation.getEAnnotations();
          final Function1<EAnnotation, Boolean> _function = new Function1<EAnnotation, Boolean>() {
            @Override
            public Boolean apply(final EAnnotation a) {
              EMap<String, String> _details = a.getDetails();
              return Boolean.valueOf(_details.containsKey("body"));
            }
          };
          final Iterable<EAnnotation> annotationsWithBody = IterableExtensions.<EAnnotation>filter(_eAnnotations, _function);
          final Function1<EAnnotation, Boolean> _function_1 = new Function1<EAnnotation, Boolean>() {
            @Override
            public Boolean apply(final EAnnotation a) {
              EMap<String, String> _details = a.getDetails();
              String _get = _details.get("body");
              return Boolean.valueOf(_get.equals(TraceMMGeneratorSteps.this.randomStringToFindGetCallerAnnotations));
            }
          };
          final EAnnotation annotationWithUniqueString = IterableExtensions.<EAnnotation>findFirst(annotationsWithBody, _function_1);
          boolean _notEquals = (!Objects.equal(annotationWithUniqueString, null));
          if (_notEquals) {
            EMap<String, String> _details = annotationWithUniqueString.getDetails();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("return (");
            EClassifier _eType = operation.getEType();
            String _javaFQN = EcoreCraftingUtil.getJavaFQN(_eType, packages);
            _builder.append(_javaFQN, "");
            _builder.append(") this.getMseoccurrence().getMse().getCaller();");
            _details.put(
              "body", _builder.toString());
          }
        }
      }
    }
  }
}
