/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.compare.postprocessor.BasicPostProcessorDescriptorImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericDimension;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericTracedObject;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.SingleReferenceValue;
import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;
import org.eclipse.gemoc.trace.commons.model.trace.BigStep;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.Trace;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewNotifier;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class GenericTraceExtractor
implements ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> {
    private Trace<?, ?, ?> trace;
    private Map<Dimension<?>, Boolean> ignoredDimensions = new HashMap();
    private final IQualifiedNameProvider nameProvider = new DefaultDeclarativeQualifiedNameProvider();
    private Map<ITraceViewListener, Set<ITraceViewNotifier.TraceViewCommand>> listeners = new HashMap<ITraceViewListener, Set<ITraceViewNotifier.TraceViewCommand>>();
    private final IPostProcessor customPostProcessor = new IPostProcessor(){
        private final Function<EObject, String> getIdFunction = e -> e.eClass().getName();

        public void postMatch(Comparison comparison, Monitor monitor) {
            ArrayList matches = new ArrayList(comparison.getMatches());
            ArrayList treatedMatches = new ArrayList();
            matches.forEach(m1 -> {
                matches.forEach(m2 -> {
                    if (m1 != m2 && !treatedMatches.contains(m2)) {
                        EObject right;
                        EObject left;
                        if (m1.getLeft() != null && m1.getRight() == null && m2.getLeft() == null && m2.getRight() != null) {
                            left = m1.getLeft();
                            right = m2.getRight();
                        } else if (m2.getLeft() != null && m2.getRight() == null && m1.getLeft() == null && m1.getRight() != null) {
                            left = m2.getLeft();
                            right = m1.getRight();
                        } else {
                            return;
                        }
                        String leftId = this.getIdFunction.apply(left);
                        String rightId = this.getIdFunction.apply(right);
                        if (leftId.equals(rightId)) {
                            comparison.getMatches().remove(m1);
                            comparison.getMatches().remove(m2);
                            MatchSpec match2 = new MatchSpec();
                            match2.setLeft(left);
                            match2.setRight(right);
                            comparison.getMatches().add((Object)match2);
                        }
                    }
                });
                treatedMatches.add(m1);
            });
        }

        public void postDiff(Comparison comparison, Monitor monitor) {
        }

        public void postRequirements(Comparison comparison, Monitor monitor) {
        }

        public void postEquivalences(Comparison comparison, Monitor monitor) {
        }

        public void postConflicts(Comparison comparison, Monitor monitor) {
        }

        public void postComparison(Comparison comparison, Monitor monitor) {
        }
    };
    private boolean compareInitialized = false;
    private IPostProcessor.Descriptor descriptor = null;
    private IPostProcessor.Descriptor.Registry<String> registry = null;
    private EMFCompare compare;
    private IDiffEngine diffEngine = null;
    private final List<Dimension<?>> cachedDimensions = new ArrayList();
    private final Map<List<Integer>, List<State<?, ?>>> stateEquivalenceClasses = Collections.synchronizedMap(new HashMap());
    private final Map<List<Integer>, List<State<?, ?>>> cachedMaskedStateEquivalenceClasses = Collections.synchronizedMap(new HashMap());
    private final List<Value<?>> observedValues = new ArrayList();
    private Map<Dimension<?>, String> dimensionToLabel = new HashMap();

    public GenericTraceExtractor(Trace<Step<?>, TracedObject<?>, State<?, ?>> trace) {
        this.trace = trace;
        this.configureDiffEngine();
    }

    public void loadTrace(Trace<Step<?>, TracedObject<?>, State<?, ?>> trace) {
        this.trace = trace;
    }

    public void notifyListeners() {
        for (Map.Entry<ITraceViewListener, Set<ITraceViewNotifier.TraceViewCommand>> entry : this.listeners.entrySet()) {
            entry.getValue().forEach(c -> c.execute());
        }
    }

    public void registerCommand(ITraceViewListener listener, ITraceViewNotifier.TraceViewCommand command) {
        if (listener != null) {
            Set<ITraceViewNotifier.TraceViewCommand> commands = this.listeners.get(listener);
            if (commands == null) {
                commands = new HashSet<ITraceViewNotifier.TraceViewCommand>();
                this.listeners.put(listener, commands);
            }
            commands.add(command);
        }
    }

    public void removeListener(ITraceViewListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void ignoreDimension(Dimension<?> dimension, boolean ignore) {
        this.ignoredDimensions.put(dimension, ignore);
    }

    public boolean isDimensionIgnored(Dimension<?> dimension) {
        Boolean ignored = this.ignoredDimensions.get(dimension);
        return ignored != null && ignored != false;
    }

    private boolean isDimensionIgnored(int index) {
        return this.isDimensionIgnored(this.getDimensions().get(index));
    }

    public boolean isStateBreakable(State<?, ?> state) {
        return true;
    }

    private void configureDiffEngine() {
        DiffBuilder diffProcessor = new DiffBuilder();
        this.diffEngine = new DefaultDiffEngine((IDiffProcessor)diffProcessor){

            protected FeatureFilter createFeatureFilter() {
                return new FeatureFilter(){

                    protected boolean isIgnoredReference(Match match, EReference reference) {
                        String name = reference.getName();
                        return name.equals("parent") || name.equals("states") || name.equals("statesNoOpposite");
                    }
                };
            }
        };
    }

    private boolean compareEObjects(EObject e1, EObject e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (!this.compareInitialized) {
            this.descriptor = new BasicPostProcessorDescriptorImpl(this.customPostProcessor, Pattern.compile(".*"), null);
            this.registry = new PostProcessorDescriptorRegistryImpl();
            this.registry.put((Object)this.customPostProcessor.getClass().getName(), this.descriptor);
            this.compare = EMFCompare.builder().setPostProcessorRegistry(this.registry).setDiffEngine(this.diffEngine).build();
            this.compareInitialized = true;
        }
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)e1, (Notifier)e2, null);
        Comparison comparison = this.compare.compare((IComparisonScope)scope);
        return comparison.getDifferences().isEmpty();
    }

    public boolean compareStates(State<?, ?> state1, State<?, ?> state2, boolean respectIgnored) {
        if (state1.getValues().size() != state2.getValues().size()) {
            return false;
        }
        List<Value<?>> values1 = this.getStateValues(state1);
        List<Value<?>> values2 = this.getStateValues(state2);
        boolean result = true;
        int i = 0;
        while (i < values1.size()) {
            Value<?> value2;
            Value<?> value1;
            if (!(respectIgnored && this.isDimensionIgnored(i) || (value1 = values1.get(i)) == (value2 = values2.get(i)))) {
                boolean bl = result = result && this.compareEObjects((EObject)value1, (EObject)value2);
                if (!result) break;
            }
            ++i;
        }
        return result;
    }

    private List<Integer> computeStateComparisonList(List<? extends Value<?>> values) {
        ArrayList<Integer> valueIndexes = new ArrayList<Integer>();
        int i = 0;
        while (i < values.size()) {
            Value<?> value = values.get(i);
            int idx = -1;
            int j = 0;
            while (j < this.observedValues.size()) {
                Value<?> v2;
                Value<?> v1 = this.observedValues.get(j);
                if (this.compareEObjects((EObject)v1, (EObject)(v2 = value))) {
                    idx = j;
                    break;
                }
                ++j;
            }
            if (idx != -1) {
                valueIndexes.add(idx);
            } else {
                valueIndexes.add(this.observedValues.size());
                this.observedValues.add(value);
            }
            ++i;
        }
        return valueIndexes;
    }

    private void updateEquivalenceClasses(State<?, ?> state) {
        List<Value<?>> values = this.getStateValues(state);
        List<Integer> valueIndexes = this.computeStateComparisonList(values);
        List<State<?, ?>> equivalenceClass = this.stateEquivalenceClasses.get(valueIndexes);
        if (equivalenceClass == null) {
            equivalenceClass = new ArrayList();
            this.stateEquivalenceClasses.put(valueIndexes, equivalenceClass);
        }
        equivalenceClass.add(state);
        List<Dimension<?>> dimensionsToMask = this.getIgnoredDimensions();
        if (!dimensionsToMask.isEmpty() && !this.cachedMaskedStateEquivalenceClasses.isEmpty()) {
            List<Dimension<?>> dimensions = this.getDimensions();
            List<Integer> dimensionIndexesToMask = dimensionsToMask.stream().map(d -> dimensions.indexOf(d)).sorted().collect(Collectors.toList());
            List<Integer> maskedIndexList = this.applyMask(valueIndexes, dimensionIndexesToMask);
            equivalenceClass = this.cachedMaskedStateEquivalenceClasses.get(maskedIndexList);
            if (equivalenceClass == null) {
                equivalenceClass = new ArrayList();
                this.cachedMaskedStateEquivalenceClasses.put(maskedIndexList, equivalenceClass);
            }
            equivalenceClass.add(state);
        }
    }

    private List<Integer> applyMask(List<Integer> source, List<Integer> mask) {
        ArrayList<Integer> result = new ArrayList<Integer>(source);
        int j = 0;
        for (Integer i : mask) {
            result.remove(i - j);
            ++j;
        }
        return result;
    }

    private List<List<State<?, ?>>> getStateEquivalenceClasses() {
        Set<Dimension<?>> dimensionsToMask = this.ignoredDimensions.keySet();
        if (dimensionsToMask.isEmpty()) {
            return new ArrayList(this.stateEquivalenceClasses.values());
        }
        if (this.cachedMaskedStateEquivalenceClasses.isEmpty()) {
            List<Dimension<?>> dimensions = this.getDimensions();
            List dimensionIndexesToMask = dimensionsToMask.stream().map(d -> dimensions.indexOf(d)).sorted().collect(Collectors.toList());
            this.stateEquivalenceClasses.forEach((indexList, stateList) -> {
                List<Integer> maskedIndexList = this.applyMask((List<Integer>)indexList, dimensionIndexesToMask);
                List<State<?, ?>> equivalenceClass = this.cachedMaskedStateEquivalenceClasses.get(maskedIndexList);
                if (equivalenceClass == null) {
                    equivalenceClass = new ArrayList();
                    this.cachedMaskedStateEquivalenceClasses.put(maskedIndexList, equivalenceClass);
                }
                equivalenceClass.addAll((Collection<State<?, ?>>)stateList);
            });
        }
        return new ArrayList(this.cachedMaskedStateEquivalenceClasses.values());
    }

    public List<List<State<?, ?>>> computeStateEquivalenceClasses(List<? extends State<?, ?>> states) {
        return this.getStateEquivalenceClasses().stream().map(l -> l.stream().filter(s -> states.contains(s)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public List<List<State<?, ?>>> computeStateEquivalenceClasses() {
        return this.getStateEquivalenceClasses().stream().map(l -> new ArrayList(l)).collect(Collectors.toList());
    }

    public LaunchConfiguration getLaunchConfiguration() {
        return this.trace.getLaunchconfiguration();
    }

    public int getNumberOfDimensions() {
        return this.trace.getTracedObjects().stream().map(o -> ((TracedObject)o).getDimensions().size()).reduce(0, (i1, i2) -> i1 + i2);
    }

    private List<Value<?>> getStateValues(State<?, ?> state) {
        HashMap dimensionToValue = new HashMap();
        state.getValues().forEach(v -> {
            Value value = dimensionToValue.put((Dimension)((Value)v).eContainer(), (Value)v);
        });
        return this.getDimensions().stream().map(d -> (Value)dimensionToValue.get(d)).collect(Collectors.toList());
    }

    public String getStateDescription(State<?, ?> state) {
        String result = "";
        List<Value<?>> values = this.getStateValues(state);
        int i = 0;
        while (i < values.size()) {
            if (!this.isDimensionIgnored(i)) {
                String description = this.getValueDescription(values.get(i));
                result = String.valueOf(result) + (description == null ? "" : String.valueOf(result.length() == 0 ? "" : "\n") + description);
            }
            ++i;
        }
        return result;
    }

    public int getStatesTraceLength() {
        return this.trace.getStates().size();
    }

    public State<?, ?> getState(int stateIndex) {
        return (State)this.trace.getStates().get(stateIndex);
    }

    public List<State<?, ?>> getStates(int firstStateIndex, int lastStateIndex) {
        ArrayList result = new ArrayList();
        int effectiveFrom = Math.max(0, firstStateIndex);
        int effectiveTo = Math.min(this.trace.getStates().size(), lastStateIndex + 1);
        this.trace.getStates().subList(effectiveFrom, effectiveTo).forEach(s -> {
            boolean bl = result.add((State)s);
        });
        return result;
    }

    public int getStateIndex(State<?, ?> state) {
        return this.trace.getStates().indexOf(state);
    }

    public int getValueFirstStateIndex(Value<?> value) {
        return this.trace.getStates().indexOf(value.getStates().get(0));
    }

    public int getValueLastStateIndex(Value<?> value) {
        EList states = value.getStates();
        return this.trace.getStates().indexOf(states.get(states.size() - 1));
    }

    private String getValueName(Value<?> value) {
        String eClassName = value.eClass().getName();
        return eClassName.substring(eClassName.indexOf(95) + 1, eClassName.indexOf("_Value"));
    }

    private String getObjectDescription(Object object) {
        Collection o_cast;
        if (object == null) {
            return "null";
        }
        if (object instanceof EObject) {
            Object originalObject = this.getOriginalObject((EObject)object);
            if (originalObject != null) {
                QualifiedName qname;
                if (originalObject instanceof EObject && (qname = this.nameProvider.getFullyQualifiedName((EObject)originalObject)) != null) {
                    return qname.getLastSegment();
                }
                return originalObject.toString();
            }
            QualifiedName qname = this.nameProvider.getFullyQualifiedName((EObject)object);
            if (qname != null) {
                return qname.getLastSegment();
            }
        }
        if (object instanceof Collection && !(o_cast = (Collection)object).isEmpty()) {
            List strings = o_cast.stream().map(o -> this.getObjectDescription(o)).collect(Collectors.toList());
            return strings.toString();
        }
        return object.toString();
    }

    public List<Value<?>> getValuesForStates(Dimension<?> dimension, int from, int to) {
        List<Value<?>> values = dimension.getValues().stream().filter(v -> {
            EList states = ((Value)v).getStates();
            State firstState = (State)states.get(0);
            State lastState = (State)states.get(states.size() - 1);
            return this.getStateIndex(firstState) < to && this.getStateIndex(lastState) > from;
        }).collect(Collectors.toList());
        return values;
    }

    public String getValueDescription(Value<?> value) {
        Optional<EStructuralFeature> attribute;
        if (value == null) {
            return "";
        }
        String description = String.valueOf(this.getDimensionLabel((Dimension)value.eContainer())) + " : ";
        String attributeName = value instanceof GenericValue ? (value instanceof GenericAttributeValue ? "attributeValue" : (value instanceof SingleReferenceValue ? "referenceValue" : "referenceValues")) : this.getValueName(value);
        if (attributeName.length() > 0 && (attribute = value.eClass().getEAllStructuralFeatures().stream().filter(r -> r.getName().equals(attributeName)).findFirst()).isPresent()) {
            Object o = value.eGet(attribute.get());
            return String.valueOf(description) + this.getObjectDescription(o);
        }
        return String.valueOf(description) + value;
    }

    private Object getOriginalObject(EObject eObject) {
        return eObject.eClass().getEAllReferences().stream().filter(r -> r.getName().startsWith("originalObject")).findFirst().map(r -> eObject.eGet((EStructuralFeature)r)).orElse(null);
    }

    public String getDimensionLabel(Dimension<?> dimension) {
        return this.dimensionToLabel.computeIfAbsent(dimension, d -> {
            String result;
            QualifiedName fqn;
            Object originalObject;
            EObject container = dimension.eContainer();
            String modelElement = container != null ? ((originalObject = container instanceof GenericTracedObject ? ((GenericTracedObject)container).getOriginalObject() : this.getOriginalObject(container)) != null ? ((fqn = this.nameProvider.getFullyQualifiedName(originalObject)) == null ? "" : String.valueOf(fqn.getLastSegment()) + ".") : "") : "";
            if (dimension instanceof GenericDimension) {
                result = ((GenericDimension)dimension).getDynamicProperty().getName();
            } else {
                String dimensionName = dimension.eClass().getName();
                String tmp = dimensionName.substring(0, dimensionName.indexOf("_Dimension"));
                result = tmp.substring(tmp.lastIndexOf("_") + 1);
            }
            return String.valueOf(modelElement) + result;
        });
    }

    public int getDimensionLength(Dimension<?> dimension) {
        return dimension.getValues().size();
    }

    private void updateEquivalenceClasses(List<State<?, ?>> states) {
        states.stream().distinct().forEach(s -> this.updateEquivalenceClasses((State<?, ?>)s));
    }

    public void statesAdded(List<State<?, ?>> states) {
        this.updateEquivalenceClasses(states);
        this.notifyListeners();
    }

    public void stepsStarted(List<Step<?>> steps) {
    }

    public void stepsEnded(List<Step<?>> steps) {
    }

    public void valuesAdded(List<Value<?>> values) {
    }

    public void dimensionsAdded(List<Dimension<?>> addedDimensions) {
        this.cachedMaskedStateEquivalenceClasses.clear();
        this.cachedDimensions.clear();
        List<Dimension<?>> dimensions = this.getDimensions();
        ArrayList<Integer> insertedTracesIndexes = new ArrayList<Integer>();
        for (Dimension<?> dimension : addedDimensions) {
            int i = dimensions.indexOf(dimension);
            insertedTracesIndexes.add(i);
        }
        Collections.sort(insertedTracesIndexes);
        ArrayList<List<Integer>> keys = new ArrayList<List<Integer>>(this.stateEquivalenceClasses.keySet());
        for (List list : keys) {
            List<State<?, ?>> states = this.stateEquivalenceClasses.remove(list);
            for (Integer i : insertedTracesIndexes) {
                list.add(i, -1);
            }
            this.stateEquivalenceClasses.put(list, states);
        }
    }

    public List<Step<?>> getSubSteps(Step<?> step) {
        if (step instanceof BigStep) {
            return new ArrayList((Collection<Step<?>>)((BigStep)step).getSubSteps());
        }
        return Collections.emptyList();
    }

    public List<Step<?>> getSteps(int firstStateIndex, int lastStateIndex) {
        Step rootStep = this.trace.getRootStep();
        if (rootStep instanceof BigStep) {
            ArrayList steps = new ArrayList((Collection<Step<?>>)((BigStep)rootStep).getSubSteps());
            steps.removeIf(s -> s.getEndingState() != null && this.getStateIndex(s.getEndingState()) < firstStateIndex || this.getStateIndex(s.getStartingState()) > lastStateIndex);
            return steps;
        }
        return Collections.singletonList(rootStep);
    }

    public List<Dimension<?>> getDimensions() {
        if (this.cachedDimensions.isEmpty()) {
            this.trace.getTracedObjects().forEach(o -> {
                boolean bl = this.cachedDimensions.addAll((Collection<Dimension<?>>)((TracedObject)o).getDimensions());
            });
        }
        return this.cachedDimensions;
    }

    private List<Dimension<?>> getIgnoredDimensions() {
        return this.getDimensions().stream().filter(d -> this.isDimensionIgnored((Dimension<?>)d)).collect(Collectors.toList());
    }
}

