/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.commons.tracemetamodel;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class StepStrings {
  public final static String implicitStepSuffix = "_ImplicitStep";
  
  public final static String abstractSubStepSuffix = "_AbstractSubStep";
  
  public final static String globalImplicitStepName = "ImplicitStep";
  
  public final static String package_BigSteps = "BigSteps";
  
  public final static String ref_BigStepToSub = "subSteps";
  
  public static String implicitStepClassName(final EClass macroStepClass) {
    String _name = macroStepClass.getName();
    return (_name + StepStrings.implicitStepSuffix);
  }
  
  public static String stepClassName(final EClass containingClass, final EOperation rule) {
    String _xifexpression = null;
    boolean _notEquals = (!Objects.equal(containingClass, null));
    if (_notEquals) {
      String _fQN = EcoreCraftingUtil.getFQN(containingClass, "_");
      String _firstUpper = StringExtensions.toFirstUpper(_fQN);
      _xifexpression = (_firstUpper + "_");
    } else {
      _xifexpression = "Root_";
    }
    final String prefix = _xifexpression;
    String _name = rule.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name);
    return (prefix + _firstUpper_1);
  }
  
  public static String subStepClassName(final EClass containingClass, final EOperation rule) {
    return StepStrings.stepClassName(containingClass, rule);
  }
  
  public static String abstractSubStepClassName(final EClass containingClass, final EOperation rule) {
    String _stepClassName = StepStrings.stepClassName(containingClass, rule);
    return (_stepClassName + StepStrings.abstractSubStepSuffix);
  }
  
  public static String implicitStepClassName(final EClass containingClass, final EOperation rule) {
    String _stepClassName = StepStrings.stepClassName(containingClass, rule);
    return (_stepClassName + StepStrings.implicitStepSuffix);
  }
}
