/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.framework.Bundle;

public class IntrospectiveMutableFieldExtractor
implements IMutableFieldExtractor {
    private String languageName;
    private Map<EObject, List<MutableField>> eObjects = new HashMap<EObject, List<MutableField>>();
    private Map<EClass, List<Pair<Class<?>, Class<?>>>> aspectClasses = new HashMap();

    public IntrospectiveMutableFieldExtractor(String languageName) {
        this.languageName = languageName;
    }

    private String decapitalize(String string) {
        char _lowerCase;
        char[] c = string.toCharArray();
        char _get = c[0];
        c[0] = _lowerCase = Character.toLowerCase(_get);
        return new String(c);
    }

    private String findName(Class<?> cls, EObject eObject) {
        Iterable name;
        block4: {
            try {
                boolean _notEquals;
                Field[] _declaredFields = cls.getDeclaredFields();
                Functions.Function1<Field, Boolean> _function = new Functions.Function1<Field, Boolean>(){

                    public Boolean apply(Field f) {
                        String _name = f.getName();
                        return _name.equals("name");
                    }
                };
                name = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_declaredFields)), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)name);
                if (!_isEmpty) break block4;
                Class<?> _superclass = cls.getSuperclass();
                boolean bl = _notEquals = !Objects.equal(_superclass, EObjectImpl.class);
                if (_notEquals) {
                    Class<?> _superclass_1 = cls.getSuperclass();
                    return this.findName(_superclass_1, eObject);
                }
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        Field f = ((Field[])Conversions.unwrapArray((Object)name, Field.class))[0];
        f.setAccessible(true);
        Object _get = f.get(eObject);
        return _get.toString();
    }

    private String findId(Class<?> cls, EObject eObject) {
        Iterable id;
        block4: {
            try {
                boolean _notEquals;
                Field[] _declaredFields = cls.getDeclaredFields();
                Functions.Function1<Field, Boolean> _function = new Functions.Function1<Field, Boolean>(){

                    public Boolean apply(Field f) {
                        String _name = f.getName();
                        return _name.equals("id");
                    }
                };
                id = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_declaredFields)), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)id);
                if (!_isEmpty) break block4;
                Class<?> _superclass = cls.getSuperclass();
                boolean bl = _notEquals = !Objects.equal(_superclass, EObjectImpl.class);
                if (_notEquals) {
                    Class<?> _superclass_1 = cls.getSuperclass();
                    return this.findId(_superclass_1, eObject);
                }
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        Field f = ((Field[])Conversions.unwrapArray((Object)id, Field.class))[0];
        f.setAccessible(true);
        Object _get = f.get(eObject);
        return _get.toString();
    }

    private String findDataName(EObject eObject) {
        Class<?> _class = eObject.getClass();
        String name = this.findName(_class, eObject);
        if (name == null) {
            Class<?> _class_1 = eObject.getClass();
            String id = this.findId(_class_1, eObject);
            if (id == null) {
                return eObject.toString();
            }
            EClass _eClass = eObject.eClass();
            String _name = _eClass.getName();
            String _decapitalize = this.decapitalize(_name);
            String _plus = String.valueOf(_decapitalize) + " ";
            return String.valueOf(_plus) + id;
        }
        return name;
    }

    private List<MutableField> getMutableFieldsFromAspect(final EObject eObject, Class<?> properties, final Class<?> aspect) {
        boolean _not;
        final ArrayList<MutableField> result = new ArrayList<MutableField>();
        Field[] fields = properties.getFields();
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)fields)).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Consumer<Field> _function = new Consumer<Field>(){

                @Override
                public void accept(final Field f) {
                    Method[] _methods = aspect.getMethods();
                    Functions.Function1<Method, Boolean> _function = new Functions.Function1<Method, Boolean>(){

                        public Boolean apply(Method m) {
                            String _name = m.getName();
                            String _name_1 = f.getName();
                            return _name.equals(_name_1);
                        }
                    };
                    Iterable methods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods)), (Functions.Function1)_function);
                    Functions.Function1<Method, Boolean> _function_1 = new Functions.Function1<Method, Boolean>(){

                        public Boolean apply(Method m) {
                            int _parameterCount = m.getParameterCount();
                            return _parameterCount == 1;
                        }
                    };
                    final Method getter = (Method)IterableExtensions.findFirst((Iterable)methods, (Functions.Function1)_function_1);
                    Functions.Function1<Method, Boolean> _function_2 = new Functions.Function1<Method, Boolean>(){

                        public Boolean apply(Method m) {
                            int _parameterCount = m.getParameterCount();
                            return _parameterCount == 2;
                        }
                    };
                    final Method setter = (Method)IterableExtensions.findFirst((Iterable)methods, (Functions.Function1)_function_2);
                    if (getter != null && setter != null) {
                        String _findDataName = IntrospectiveMutableFieldExtractor.this.findDataName(eObject);
                        Supplier<Object> _function_3 = new Supplier<Object>(){

                            @Override
                            public Object get() {
                                try {
                                    return getter.invoke(null, eObject);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        };
                        Consumer<Object> _function_4 = new Consumer<Object>(){

                            @Override
                            public void accept(Object t) {
                                try {
                                    setter.invoke(null, eObject, t);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        };
                        MutableField data = new MutableField(_findDataName, eObject, _function_3, _function_4);
                        result.add(data);
                    }
                }
            };
            ((List)Conversions.doWrapArray((Object)fields)).forEach(_function);
        }
        return result;
    }

    @Override
    public List<MutableField> extractMutableField(final EObject eObject) {
        boolean _not;
        boolean _containsKey = this.eObjects.containsKey(eObject);
        boolean bl = _not = !_containsKey;
        if (_not) {
            boolean _not_1;
            final ArrayList<MutableField> datas = new ArrayList<MutableField>();
            EClass _eClass = eObject.eClass();
            boolean _containsKey_1 = this.aspectClasses.containsKey(_eClass);
            boolean bl2 = _not_1 = !_containsKey_1;
            if (_not_1) {
                Map<Class<?>, List<Class<?>>> classes = this.getStaticHelperClasses(eObject);
                if (classes != null) {
                    final ArrayList list = new ArrayList();
                    BiConsumer _function = new BiConsumer<Class<?>, List<Class<?>>>(){

                        @Override
                        public void accept(final Class<?> i, List<Class<?>> l) {
                            Consumer _function = new Consumer<Class<?>>(){

                                @Override
                                public void accept(Class<?> c) {
                                    try {
                                        Bundle _dslBundle = DslHelper.getDslBundle((String)IntrospectiveMutableFieldExtractor.this.languageName);
                                        String _name = c.getName();
                                        String _simpleName = i.getSimpleName();
                                        String _plus = String.valueOf(_name) + _simpleName;
                                        String _plus_1 = String.valueOf(_plus) + "AspectProperties";
                                        Class properties = _dslBundle.loadClass(_plus_1);
                                        Pair pair = new Pair(c, (Object)properties);
                                        list.add(pair);
                                        List _mutableFieldsFromAspect = IntrospectiveMutableFieldExtractor.this.getMutableFieldsFromAspect(eObject, properties, c);
                                        datas.addAll(_mutableFieldsFromAspect);
                                    }
                                    catch (Throwable _t) {
                                        if (_t instanceof ClassNotFoundException) {
                                            ClassNotFoundException classNotFoundException = (ClassNotFoundException)_t;
                                        }
                                        throw Exceptions.sneakyThrow((Throwable)_t);
                                    }
                                }
                            };
                            l.forEach(_function);
                        }
                    };
                    classes.forEach(_function);
                    EClass _eClass_1 = eObject.eClass();
                    this.aspectClasses.put(_eClass_1, list);
                } else {
                    EClass _eClass_2 = eObject.eClass();
                    this.aspectClasses.put(_eClass_2, Collections.EMPTY_LIST);
                }
            } else {
                EClass _eClass_3 = eObject.eClass();
                List<Pair<Class<?>, Class<?>>> list_1 = this.aspectClasses.get(_eClass_3);
                Consumer _function_1 = new Consumer<Pair<Class<?>, Class<?>>>(){

                    @Override
                    public void accept(Pair<Class<?>, Class<?>> p) {
                        Class _value = (Class)p.getValue();
                        Class _key = (Class)p.getKey();
                        List _mutableFieldsFromAspect = IntrospectiveMutableFieldExtractor.this.getMutableFieldsFromAspect(eObject, _value, _key);
                        datas.addAll(_mutableFieldsFromAspect);
                    }
                };
                list_1.forEach(_function_1);
            }
            this.eObjects.put(eObject, datas);
            return datas;
        }
        return this.eObjects.get(eObject);
    }

    private void getSuperInterfacesOfInterface(Class<?> c, final HashSet<Class<?>> set) {
        Class<?>[] _interfaces = c.getInterfaces();
        List<Class<?>> _asList = Arrays.asList(_interfaces);
        Functions.Function1 _function = new Functions.Function1<Class<?>, Boolean>(){

            public Boolean apply(Class<?> i) {
                boolean _equals = i.equals(EObject.class);
                return !_equals;
            }
        };
        Iterable possibleSuperInterfaces = IterableExtensions.filter(_asList, (Functions.Function1)_function);
        Consumer _function_1 = new Consumer<Class<?>>(){

            @Override
            public void accept(Class<?> i) {
                boolean _add = set.add(i);
                if (_add) {
                    IntrospectiveMutableFieldExtractor.this.getSuperInterfacesOfInterface(i, set);
                }
            }
        };
        possibleSuperInterfaces.forEach(_function_1);
    }

    private List<Class<?>> getSuperInterfacesOfInterface(Class<?> c) {
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        this.getSuperInterfacesOfInterface(c, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private List<Class<?>> getInterfacesOfEObject(final EObject o) {
        Functions.Function1 _function;
        ArrayList possibleInterfaces = new ArrayList();
        Class<?> _class = o.getClass();
        List<Class<?>> interfaces = this.getAllInterfaces(_class);
        Class baseInterface = (Class)IterableExtensions.findFirst(interfaces, (Functions.Function1)(_function = new Functions.Function1<Class<?>, Boolean>(){

            public Boolean apply(Class<?> i) {
                String _simpleName = i.getSimpleName();
                EClass _eClass = o.eClass();
                String _name = _eClass.getName();
                return _simpleName.equals(_name);
            }
        }));
        if (baseInterface != null) {
            possibleInterfaces.add(baseInterface);
            List<Class<?>> _superInterfacesOfInterface = this.getSuperInterfacesOfInterface(baseInterface);
            possibleInterfaces.addAll(_superInterfacesOfInterface);
        }
        InputOutput.println(possibleInterfaces);
        return possibleInterfaces;
    }

    private List<Class<?>> getAllInterfaces(Class<? extends EObject> cls) {
        if (cls == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        this.getAllInterfaces(cls, interfacesFound);
        ArrayList res = new ArrayList(interfacesFound);
        return res;
    }

    private void getAllInterfaces(Class<?> cls, final HashSet<Class<?>> interfacesFound) {
        Class<?> currCls = cls;
        while (currCls != null) {
            Class<?>[] _interfaces = currCls.getInterfaces();
            Consumer _function = new Consumer<Class<?>>(){

                @Override
                public void accept(Class<?> i) {
                    boolean _add = interfacesFound.add(i);
                    if (_add) {
                        IntrospectiveMutableFieldExtractor.this.getAllInterfaces(i, interfacesFound);
                    }
                }
            };
            ((List)Conversions.doWrapArray(_interfaces)).forEach(_function);
            Class<?> _superclass = currCls.getSuperclass();
            currCls = _superclass;
        }
    }

    private Map<Class<?>, List<Class<?>>> getStaticHelperClasses(EObject target) {
        List<Class<?>> allPossibleInterfaces = this.getInterfacesOfEObject(target);
        final HashMap res = new HashMap();
        final Set allAspects = K3DslHelper.getAspects((String)this.languageName);
        Consumer _function = new Consumer<Class<?>>(){

            @Override
            public void accept(final Class<?> i) {
                Functions.Function1 _function = new Functions.Function1<Class<?>, Boolean>(){

                    public Boolean apply(Class<?> asp) {
                        Class _target = K3DslHelper.getTarget(asp);
                        return Objects.equal((Object)_target, (Object)i);
                    }
                };
                Iterable appliedAspects = IterableExtensions.filter((Iterable)allAspects, (Functions.Function1)_function);
                List _list = IterableExtensions.toList((Iterable)appliedAspects);
                res.put(i, _list);
            }
        };
        allPossibleInterfaces.forEach(_function);
        return res;
    }
}

