package org.eclipse.gemoc.ui.highlighting;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.ui.highlighting.DslHighlightingConfiguration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

@SuppressWarnings("all")
public class DslHighlightingCalculator extends DefaultSemanticHighlightingCalculator {
  @Override
  public void provideHighlightingFor(final XtextResource resource, final IHighlightedPositionAcceptor acceptor, final CancelIndicator cancelIndicator) {
    IParseResult _parseResult = resource.getParseResult();
    final INode root = _parseResult.getRootNode();
    BidiTreeIterable<INode> _asTreeIterable = root.getAsTreeIterable();
    for (final INode node : _asTreeIterable) {
      {
        final EObject grammarElement = node.getGrammarElement();
        if ((grammarElement instanceof RuleCall)) {
          RuleCall rc = ((RuleCall) grammarElement);
          AbstractRule r = rc.getRule();
          final EObject c = ((RuleCall)grammarElement).eContainer();
          EObject _eContainer = c.eContainer();
          final EObject ccc = _eContainer.eContainer();
          String _name = r.getName();
          boolean _equals = _name.equals("WORD");
          if (_equals) {
            if ((c instanceof Assignment)) {
              String _feature = ((Assignment)c).getFeature();
              boolean _equals_1 = Objects.equal(_feature, "key");
              if (_equals_1) {
                int _offset = node.getOffset();
                int _length = node.getLength();
                acceptor.addPosition(_offset, _length, 
                  DslHighlightingConfiguration.KEY_ID);
              }
            }
          } else {
            String _name_1 = r.getName();
            boolean _equals_2 = Objects.equal(_name_1, "VALUE_WORD");
            if (_equals_2) {
              int _offset_1 = node.getOffset();
              int _length_1 = node.getLength();
              acceptor.addPosition(_offset_1, _length_1, DslHighlightingConfiguration.VALUE_ID);
            } else {
              String _name_2 = r.getName();
              boolean _equals_3 = Objects.equal(_name_2, "SEPARATOR");
              if (_equals_3) {
                if ((ccc instanceof ParserRule)) {
                  String _name_3 = ((ParserRule)ccc).getName();
                  boolean _notEquals = (!Objects.equal(_name_3, "VALUE_WORD"));
                  if (_notEquals) {
                    int _offset_2 = node.getOffset();
                    int _length_2 = node.getLength();
                    acceptor.addPosition(_offset_2, _length_2, 
                      DslHighlightingConfiguration.SEPARATOR_ID);
                  }
                }
              }
            }
          }
        } else {
          if ((grammarElement instanceof Keyword)) {
            String _value = ((Keyword)grammarElement).getValue();
            boolean _equals_4 = Objects.equal(_value, "\\");
            if (_equals_4) {
              int _offset_3 = node.getOffset();
              int _length_3 = node.getLength();
              acceptor.addPosition(_offset_3, _length_3, 
                DslHighlightingConfiguration.LINESEPARATOR_ID);
            }
          }
        }
      }
    }
  }
}
