/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.DebugTargetUtils;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.DSLEclipseDebugIntegration;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.ModelUpdater;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLDebugTargetAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.dsl.debug.ide.event.DSLDebugEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDSLLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String RESOURCE_URI = "Resource";
    public static final String FIRST_INSTRUCTION_URI = "First Instruction";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch(this.getFirstInstruction(configuration), configuration, mode, launch, monitor);
    }

    protected void launch(EObject firstInstruction, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if ("debug".equals(mode)) {
            DebugTarget eDebugTarget = DebugTargetUtils.createDebugTarget((String)this.getDebugTargetName(configuration, firstInstruction), (EObject)firstInstruction);
            DSLDebugEventDispatcher dispatcher = new DSLDebugEventDispatcher();
            DSLEclipseDebugIntegration integration = new DSLEclipseDebugIntegration(this.getModelIdentifier(), launch, eDebugTarget, new ModelUpdater(), dispatcher);
            final DSLDebugTargetAdapter debugTarget = integration.getDebugTarget(eDebugTarget);
            dispatcher.setModel(debugTarget);
            for (IDSLCurrentInstructionListener listener : this.getCurrentInstructionListeners()) {
                debugTarget.addCurrentInstructionListener(listener);
            }
            IDSLDebugger debugger = this.getDebugger(configuration, dispatcher, firstInstruction, monitor);
            dispatcher.setDebugger(debugger);
            launch.addDebugTarget((IDebugTarget)debugTarget);
            Job job = new Job(this.getDebugJobName(configuration, firstInstruction)){

                protected IStatus run(IProgressMonitor monitor) {
                    debugTarget.start();
                    return new Status(0, AbstractDSLLaunchConfigurationDelegate.this.getPluginID(), "Execution was successfull");
                }
            };
            job.schedule();
        }
    }

    protected EObject getFirstInstruction(ILaunchConfiguration configuration) {
        EObject res = null;
        ResourceSet rs = this.getResourceSet();
        try {
            rs.getResource(URI.createPlatformResourceURI((String)configuration.getAttribute(RESOURCE_URI, ""), (boolean)true), true);
            res = rs.getEObject(URI.createURI((String)configuration.getAttribute(FIRST_INSTRUCTION_URI, ""), (boolean)true), true);
        }
        catch (CoreException e) {
            Activator.getDefault().error(e);
        }
        return res;
    }

    protected ResourceSet getResourceSet() {
        return new ResourceSetImpl();
    }

    protected List<IDSLCurrentInstructionListener> getCurrentInstructionListeners() {
        return new ArrayList<IDSLCurrentInstructionListener>();
    }

    protected abstract IDSLDebugger getDebugger(ILaunchConfiguration var1, DSLDebugEventDispatcher var2, EObject var3, IProgressMonitor var4);

    protected abstract String getDebugTargetName(ILaunchConfiguration var1, EObject var2);

    protected abstract String getDebugJobName(ILaunchConfiguration var1, EObject var2);

    protected abstract String getPluginID();

    public abstract String getModelIdentifier();
}

