/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gemoc.addon.stategraph.layout.StateGraphLayoutCommand;
import org.eclipse.gemoc.addon.stategraph.logic.DirectedGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateVertex;
import org.eclipse.gemoc.addon.stategraph.logic.alg.JohnsonSimpleCycles;
import org.eclipse.gemoc.addon.stategraph.views.CurvedEdgeView;
import org.eclipse.gemoc.addon.stategraph.views.CycleView;
import org.eclipse.gemoc.addon.stategraph.views.EdgeView;
import org.eclipse.gemoc.addon.stategraph.views.StraightEdgeView;
import org.eclipse.gemoc.addon.stategraph.views.VertexView;

public class StateGraphRenderer
extends Pane {
    private StateGraph stateGraph;
    private final StateGraphLayoutCommand layoutCommand;
    private final Map<StateVertex, VertexView> nodeToGroup = new HashMap<StateVertex, VertexView>();
    private final Map<DirectedGraph.Edge<StateVertex>, EdgeView> edgeToGroup = new HashMap<DirectedGraph.Edge<StateVertex>, EdgeView>();
    private final Set<StateVertex> movedVertice = new HashSet<StateVertex>();
    private final List<CycleView> hulls = new ArrayList<CycleView>();
    private final JohnsonSimpleCycles<StateVertex> cycleFindingAlgorithm;
    private boolean changed = false;
    private StateVertex currentVertex = null;
    private boolean isCycleColorationEnabled = false;

    public StateGraphRenderer(StateGraph stateGraph, StateGraphLayoutCommand layoutCommand) {
        this.layoutCommand = layoutCommand;
        this.stateGraph = stateGraph;
        this.stateGraph.setUpdateCommand((clear, currentVertex) -> this.render((boolean)clear, (StateVertex)currentVertex));
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        this.cycleFindingAlgorithm = new JohnsonSimpleCycles<StateVertex>(this.stateGraph);
    }

    public void setStateGraph(StateGraph stateGraph) {
        this.stateGraph = stateGraph;
        this.stateGraph.setUpdateCommand((clear, currentVertex) -> this.render((boolean)clear, (StateVertex)currentVertex));
        this.cycleFindingAlgorithm.setGraph(this.stateGraph);
    }

    private void render(boolean clear, StateVertex currentVertex) {
        if (currentVertex != null) {
            this.currentVertex = currentVertex;
        }
        Platform.runLater(() -> {
            if (clear) {
                this.changed = true;
                this.getChildren().clear();
                this.nodeToGroup.clear();
                this.edgeToGroup.clear();
            }
            HashMap<DirectedGraph.Edge<StateVertex>, StateVertex> workList = new HashMap<DirectedGraph.Edge<StateVertex>, StateVertex>();
            ArrayList vertexShapesToAdd = new ArrayList();
            ArrayList<EdgeView> edgeShapesToAdd = new ArrayList<EdgeView>();
            List vertice = this.stateGraph.getVertice().stream().sorted((v1, v2) -> v1.getIndex() - v2.getIndex()).collect(Collectors.toList());
            ArrayList<StateVertex> verticeToRemove = new ArrayList<StateVertex>(this.nodeToGroup.keySet());
            verticeToRemove.removeAll(vertice);
            if (!verticeToRemove.isEmpty()) {
                this.changed = true;
            }
            verticeToRemove.forEach(n -> {
                VertexView vertexShape = this.nodeToGroup.get(n);
                this.nodeToGroup.remove(n);
                if (vertexShape != null) {
                    this.getChildren().remove((Object)vertexShape);
                }
            });
            int i = 0;
            while (i < vertice.size()) {
                StateVertex v3 = (StateVertex)vertice.get(i);
                Object vertexShape = this.nodeToGroup.get(v3);
                if (vertexShape == null) {
                    this.changed = true;
                    vertexShape = new VertexView(i, v3);
                    this.nodeToGroup.put(v3, (VertexView)((Object)((Object)vertexShape)));
                    vertexShapesToAdd.add(vertexShape);
                }
                ((VertexView)((Object)((Object)vertexShape))).setCurrentState(currentVertex == v3);
                ((VertexView)((Object)((Object)vertexShape))).setStateIndex(i);
                for (DirectedGraph.Edge<StateVertex> e2 : this.stateGraph.getOutgoingEdges(v3)) {
                    workList.put(e2, v3);
                }
                ++i;
            }
            ArrayList<DirectedGraph.Edge<StateVertex>> edgesToRemove = new ArrayList<DirectedGraph.Edge<StateVertex>>(this.edgeToGroup.keySet());
            for (StateVertex v3 : vertice) {
                for (DirectedGraph.Edge<StateVertex> e2 : this.stateGraph.getIncomingEdges(v3)) {
                    VertexView target;
                    VertexView source;
                    EdgeView edgeGroup;
                    StateVertex w = (StateVertex)workList.get(e2);
                    if (w == null || v3 == w) continue;
                    DirectedGraph.Edge<StateVertex> reverseEdge = this.stateGraph.getEdge(v3, w);
                    if (reverseEdge != null) {
                        edgeGroup = this.edgeToGroup.get(e2);
                        if (edgeGroup == null || edgeGroup instanceof StraightEdgeView) {
                            this.changed = true;
                            if (edgeGroup != null) {
                                this.getChildren().remove((Object)edgeGroup);
                            }
                            source = this.nodeToGroup.get(w);
                            target = this.nodeToGroup.get(v3);
                            edgeGroup = new CurvedEdgeView(source.translateXProperty(), source.translateYProperty(), target.translateXProperty(), target.translateYProperty());
                            this.edgeToGroup.put(e2, edgeGroup);
                            edgeShapesToAdd.add(edgeGroup);
                        }
                        edgesToRemove.remove(e2);
                        EdgeView reverseEdgeGroup = this.edgeToGroup.get(reverseEdge);
                        if (reverseEdgeGroup == null || reverseEdgeGroup instanceof StraightEdgeView) {
                            this.changed = true;
                            if (reverseEdgeGroup != null) {
                                this.getChildren().remove((Object)reverseEdgeGroup);
                            }
                            VertexView source2 = this.nodeToGroup.get(v3);
                            VertexView target2 = this.nodeToGroup.get(w);
                            reverseEdgeGroup = new CurvedEdgeView(source2.translateXProperty(), source2.translateYProperty(), target2.translateXProperty(), target2.translateYProperty());
                            this.edgeToGroup.put(reverseEdge, reverseEdgeGroup);
                            edgeShapesToAdd.add(reverseEdgeGroup);
                        }
                        edgesToRemove.remove(reverseEdge);
                        continue;
                    }
                    edgeGroup = this.edgeToGroup.get(e2);
                    if (edgeGroup == null || edgeGroup instanceof CurvedEdgeView) {
                        this.changed = true;
                        if (edgeGroup != null) {
                            this.getChildren().remove((Object)edgeGroup);
                        }
                        source = this.nodeToGroup.get(w);
                        target = this.nodeToGroup.get(v3);
                        edgeGroup = new StraightEdgeView(source.translateXProperty(), source.translateYProperty(), target.translateXProperty(), target.translateYProperty());
                        this.edgeToGroup.put(e2, edgeGroup);
                        edgeShapesToAdd.add(edgeGroup);
                    }
                    edgesToRemove.remove(e2);
                }
            }
            if (!edgesToRemove.isEmpty()) {
                this.changed = true;
            }
            edgesToRemove.forEach(e -> {
                Group edgeGroup = this.edgeToGroup.get(e);
                this.edgeToGroup.remove(e);
                if (edgeGroup != null) {
                    this.getChildren().remove((Object)edgeGroup);
                }
            });
            this.getChildren().addAll(0, edgeShapesToAdd);
            this.getChildren().addAll(vertexShapesToAdd);
            if (this.changed) {
                this.layoutCommand.applyLayout(this.nodeToGroup, this.movedVertice);
            }
            if (!this.isCycleColorationEnabled) {
                this.getChildren().removeAll(this.hulls);
                this.hulls.clear();
            } else if (this.changed) {
                this.getChildren().removeAll(this.hulls);
                this.hulls.clear();
                List<List<StateVertex>> cycles = this.cycleFindingAlgorithm.findSimpleCycles();
                if (!cycles.isEmpty()) {
                    double hueInterval = 360.0 / (double)cycles.size();
                    int i2 = 0;
                    while (i2 < cycles.size()) {
                        List<Node> nodes = cycles.get(i2).stream().map(v -> (Node)this.nodeToGroup.get(v)).collect(Collectors.toList());
                        CycleView cycleView = new CycleView(nodes, i2, hueInterval);
                        this.getChildren().add(0, (Object)cycleView);
                        this.hulls.add(cycleView);
                        ++i2;
                    }
                }
            }
            this.changed = false;
        });
    }

    public void setCycleColorationEnabled(boolean checked) {
        if (this.isCycleColorationEnabled != checked) {
            this.isCycleColorationEnabled = checked;
            this.changed = true;
            this.render(false, this.currentVertex);
        }
    }

    public void forceLayout() {
        this.movedVertice.clear();
        Platform.runLater(() -> this.layoutCommand.applyLayout(this.nodeToGroup, this.movedVertice));
    }

    public Set<StateVertex> getMovedVertice() {
        return this.movedVertice;
    }
}

