/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.mrtree.IGraphImporter;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.properties.InternalProperties;
import org.eclipse.elk.alg.mrtree.properties.MrTreeOptions;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public class KGraphImporter
implements IGraphImporter<KNode> {
    @Override
    public TGraph importGraph(KNode kgraph) {
        TGraph tGraph = new TGraph();
        KShapeLayout sourceShapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        tGraph.copyProperties((IPropertyHolder)sourceShapeLayout);
        tGraph.setProperty(InternalProperties.ORIGIN, kgraph);
        HashMap<KNode, TNode> elemMap = new HashMap<KNode, TNode>();
        this.transformNodes(kgraph, tGraph, elemMap);
        this.transformEdges(kgraph, tGraph, elemMap);
        return tGraph;
    }

    private void transformNodes(KNode parentNode, TGraph tGraph, Map<KNode, TNode> elemMap) {
        int index = 0;
        for (KNode knode : parentNode.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            String label = "";
            if (!knode.getLabels().isEmpty()) {
                label = ((KLabel)knode.getLabels().get(0)).getText();
            }
            TNode newNode = new TNode(index++, tGraph, label);
            newNode.copyProperties((IPropertyHolder)nodeLayout);
            newNode.setProperty(InternalProperties.ORIGIN, knode);
            newNode.getPosition().y = nodeLayout.getYpos() + nodeLayout.getHeight() / 2.0f;
            newNode.getSize().x = Math.max(nodeLayout.getWidth(), 1.0f);
            newNode.getPosition().x = nodeLayout.getXpos() + nodeLayout.getWidth() / 2.0f;
            newNode.getSize().y = Math.max(nodeLayout.getHeight(), 1.0f);
            tGraph.getNodes().add(newNode);
            elemMap.put(knode, newNode);
        }
    }

    private void transformEdges(KNode parentNode, TGraph tGraph, Map<KNode, TNode> elemMap) {
        for (KNode knode : parentNode.getChildren()) {
            for (KEdge kedge : knode.getOutgoingEdges()) {
                if (kedge.getTarget().getParent() != parentNode || knode == kedge.getTarget()) continue;
                KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
                TNode source = elemMap.get(knode);
                TNode target = elemMap.get(kedge.getTarget());
                if (source == null || target == null) continue;
                TEdge newEdge = new TEdge(source, target);
                newEdge.setProperty(InternalProperties.ORIGIN, kedge);
                newEdge.copyProperties((IPropertyHolder)edgeLayout);
                source.getOutgoingEdges().add(newEdge);
                target.getIncomingEdges().add(newEdge);
                tGraph.getEdges().add(newEdge);
            }
        }
    }

    @Override
    public void applyLayout(TGraph tGraph) {
        KNode kgraph = (KNode)tGraph.getProperty(InternalProperties.ORIGIN);
        KShapeLayout graphLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        float borderSpacing = ((Float)tGraph.getProperty(MrTreeOptions.SPACING_BORDER)).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = ((Float)MrTreeOptions.SPACING_NODE.getDefault()).floatValue();
            tGraph.setProperty(MrTreeOptions.SPACING_BORDER, Float.valueOf(borderSpacing));
        }
        double minXPos = 2.147483647E9;
        double minYPos = 2.147483647E9;
        double maxXPos = -2.147483648E9;
        double maxYPos = -2.147483648E9;
        for (TNode tNode : tGraph.getNodes()) {
            KVector pos = tNode.getPosition();
            KVector size = tNode.getSize();
            minXPos = Math.min(minXPos, pos.x - size.x / 2.0);
            minYPos = Math.min(minYPos, pos.y - size.y / 2.0);
            maxXPos = Math.max(maxXPos, pos.x + size.x / 2.0);
            maxYPos = Math.max(maxYPos, pos.y + size.y / 2.0);
        }
        KVector offset = new KVector((double)borderSpacing - minXPos, (double)borderSpacing - minYPos);
        for (TNode tNode : tGraph.getNodes()) {
            Object object = tNode.getProperty(InternalProperties.ORIGIN);
            if (!(object instanceof KNode)) continue;
            KNode knode = (KNode)object;
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            KVector nodePos = tNode.getPosition().add(offset);
            nodeLayout.setXpos((float)nodePos.x - nodeLayout.getWidth() / 2.0f);
            nodeLayout.setYpos((float)nodePos.y - nodeLayout.getHeight() / 2.0f);
        }
        for (TEdge tEdge : tGraph.getEdges()) {
            KEdge kedge = (KEdge)tEdge.getProperty(InternalProperties.ORIGIN);
            if (kedge == null) continue;
            KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
            KVectorChain bendPoints = tEdge.getBendPoints();
            KVector sourcePoint = new KVector(tEdge.getSource().getPosition());
            bendPoints.addFirst((Object)sourcePoint);
            KVector targetPoint = new KVector(tEdge.getTarget().getPosition());
            bendPoints.addLast((Object)targetPoint);
            KGraphImporter.toNodeBorder(sourcePoint, (KVector)bendPoints.get(1), tEdge.getSource().getSize());
            KGraphImporter.toNodeBorder(targetPoint, (KVector)bendPoints.get(bendPoints.size() - 2), tEdge.getTarget().getSize());
            edgeLayout.getBendPoints().clear();
            edgeLayout.applyVectorChain(bendPoints);
        }
        KInsets insets = graphLayout.getInsets();
        float width = (float)(maxXPos - minXPos) + 2.0f * borderSpacing + insets.getLeft() + insets.getRight();
        float height = (float)(maxYPos - minYPos) + 2.0f * borderSpacing + insets.getTop() + insets.getBottom();
        ElkUtil.resizeNode((KNode)kgraph, (float)width, (float)height, (boolean)false, (boolean)false);
    }

    private static void toNodeBorder(KVector center, KVector next, KVector size) {
        double wh = size.x / 2.0;
        double hh = size.y / 2.0;
        double absx = Math.abs(next.x - center.x);
        double absy = Math.abs(next.y - center.y);
        double xscale = 1.0;
        double yscale = 1.0;
        if (absx > wh) {
            xscale = wh / absx;
        }
        if (absy > hh) {
            yscale = hh / absy;
        }
        double scale = Math.min(xscale, yscale);
        center.x += scale * (next.x - center.x);
        center.y += scale * (next.y - center.y);
    }
}

