/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.p3order.NodeRelativePortDistributor;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InteractiveCrossingMinimizer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBeforePhase4(IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.LONG_EDGE_JOINER);

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.fromExisting(INTERMEDIATE_PROCESSING_CONFIGURATION);
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PORT_LIST_SORTER);
        }
        return configuration;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive crossing minimization", 1.0f);
        int portCount = 0;
        for (Layer layer : layeredGraph) {
            double horizPos = 0.0;
            int nodeCount = 0;
            for (LNode node : layer.getNodes()) {
                if (node.getPosition().x > 0.0) {
                    horizPos += node.getPosition().x + node.getSize().x / 2.0;
                    ++nodeCount;
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                }
            }
            horizPos /= (double)nodeCount;
            final double[] pos = new double[layer.getNodes().size()];
            int nextIndex = 0;
            for (LNode node : layer) {
                node.id = nextIndex++;
                pos[node.id] = this.getPos(node, horizPos);
                if (node.getType() != LNode.NodeType.LONG_EDGE) continue;
                node.setProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION, pos[node.id]);
            }
            Collections.sort(layer.getNodes(), new Comparator<LNode>(){

                @Override
                public int compare(LNode node1, LNode node2) {
                    int compare = Double.compare(pos[node1.id], pos[node2.id]);
                    if (compare == 0) {
                        List node1Successors = (List)node1.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
                        List node2Successors = (List)node2.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
                        if (node1Successors.contains((Object)node2)) {
                            return -1;
                        }
                        if (node2Successors.contains((Object)node1)) {
                            return 1;
                        }
                    }
                    return compare;
                }
            });
        }
        NodeRelativePortDistributor portDistributor = new NodeRelativePortDistributor(new float[portCount]);
        portDistributor.distributePorts(layeredGraph.toNodeArray());
        monitor.done();
    }

    private double getPos(LNode node, double horizPos) {
        switch (node.getType()) {
            case LONG_EDGE: {
                LEdge edge = (LEdge)((Object)node.getProperty(InternalProperties.ORIGIN));
                KVectorChain bendpoints = (KVectorChain)edge.getProperty(InternalProperties.ORIGINAL_BENDPOINTS);
                if (bendpoints == null) {
                    bendpoints = new KVectorChain();
                } else if (((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue()) {
                    bendpoints = KVectorChain.reverse((KVectorChain)bendpoints);
                }
                LPort source = (LPort)((Object)node.getProperty(InternalProperties.LONG_EDGE_SOURCE));
                KVector sourcePoint = source.getAbsoluteAnchor();
                if (horizPos <= sourcePoint.x) {
                    return sourcePoint.y;
                }
                bendpoints.addFirst((Object)sourcePoint);
                LPort target = (LPort)((Object)node.getProperty(InternalProperties.LONG_EDGE_TARGET));
                KVector targetPoint = target.getAbsoluteAnchor();
                if (targetPoint.x <= horizPos) {
                    return targetPoint.y;
                }
                bendpoints.addLast((Object)targetPoint);
                Iterator pointIter = bendpoints.iterator();
                KVector point1 = (KVector)pointIter.next();
                KVector point2 = (KVector)pointIter.next();
                while (point2.x < horizPos && pointIter.hasNext()) {
                    point1 = point2;
                    point2 = (KVector)pointIter.next();
                }
                return point1.y + (horizPos - point1.x) / (point2.x - point1.x) * (point2.y - point1.y);
            }
            case NORTH_SOUTH_PORT: {
                LPort originPort = (LPort)((Object)node.getPorts().get(0).getProperty(InternalProperties.ORIGIN));
                LNode originNode = originPort.getNode();
                switch (originPort.getSide()) {
                    case NORTH: {
                        return originNode.getPosition().y;
                    }
                    case SOUTH: {
                        return originNode.getPosition().y + originNode.getSize().y;
                    }
                }
            }
        }
        return node.getInteractiveReferencePoint().y;
    }
}

