/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.ICrossingMinimizationHeuristic;
import org.eclipse.elk.alg.layered.p3order.constraints.IConstraintResolver;
import org.eclipse.elk.alg.layered.properties.InternalProperties;

public final class BarycenterHeuristic
implements ICrossingMinimizationHeuristic {
    private final float[] portRanks;
    private final Random random;
    private final IConstraintResolver constraintResolver;
    private final BarycenterState[][] barycenterState;
    private static final float RANDOM_AMOUNT = 0.07f;
    private final Comparator<LNode> barycenterStateComparator = (n1, n2) -> {
        BarycenterState s1 = this.stateOf((LNode)((Object)n1));
        BarycenterState s2 = this.stateOf((LNode)((Object)n2));
        if (s1.barycenter != null && s2.barycenter != null) {
            return s1.barycenter.compareTo(s2.barycenter);
        }
        if (s1.barycenter != null) {
            return -1;
        }
        if (s2.barycenter != null) {
            return 1;
        }
        return 0;
    };

    public BarycenterHeuristic(BarycenterState[][] barycenterState, IConstraintResolver constraintResolver, Random graphRandom, float[] portRanks) {
        this.barycenterState = barycenterState;
        this.constraintResolver = constraintResolver;
        this.random = graphRandom;
        this.portRanks = portRanks;
    }

    @Override
    public void minimizeCrossings(List<LNode> layer, boolean preOrdered, boolean randomize, boolean forward) {
        if (randomize) {
            this.randomizeBarycenters(layer);
        } else {
            this.calculateBarycenters(layer, forward);
            this.fillInUnknownBarycenters(layer, preOrdered);
        }
        if (layer.size() > 1) {
            Collections.sort(layer, this.barycenterStateComparator);
            this.constraintResolver.processConstraints(layer);
        }
    }

    private void randomizeBarycenters(List<LNode> nodes) {
        for (LNode node : nodes) {
            this.stateOf((LNode)node).barycenter = this.random.nextDouble();
            this.stateOf((LNode)node).summedWeight = this.stateOf((LNode)node).barycenter;
            this.stateOf((LNode)node).degree = 1;
        }
    }

    private void fillInUnknownBarycenters(List<LNode> nodes, boolean preOrdered) {
        if (preOrdered) {
            double lastValue = -1.0;
            ListIterator<LNode> nodesIterator = nodes.listIterator();
            while (nodesIterator.hasNext()) {
                LNode node = nodesIterator.next();
                Double value = this.stateOf((LNode)node).barycenter;
                if (value == null) {
                    double nextValue = lastValue + 1.0;
                    ListIterator<LNode> nextNodeIterator = nodes.listIterator(nodesIterator.nextIndex());
                    while (nextNodeIterator.hasNext()) {
                        Double x = this.stateOf((LNode)nextNodeIterator.next()).barycenter;
                        if (x == null) continue;
                        nextValue = x;
                        break;
                    }
                    this.stateOf((LNode)node).barycenter = value = Double.valueOf((lastValue + nextValue) / 2.0);
                    this.stateOf((LNode)node).summedWeight = value;
                    this.stateOf((LNode)node).degree = 1;
                }
                lastValue = value;
            }
        } else {
            double maxBary = 0.0;
            for (LNode node : nodes) {
                if (this.stateOf((LNode)node).barycenter == null) continue;
                maxBary = Math.max(maxBary, this.stateOf((LNode)node).barycenter);
            }
            maxBary += 2.0;
            for (LNode node : nodes) {
                if (this.stateOf((LNode)node).barycenter != null) continue;
                double value = (double)this.random.nextFloat() * maxBary - 1.0;
                this.stateOf((LNode)node).barycenter = value;
                this.stateOf((LNode)node).summedWeight = value;
                this.stateOf((LNode)node).degree = 1;
            }
        }
    }

    private void calculateBarycenters(List<LNode> nodes, boolean forward) {
        for (LNode node : nodes) {
            this.stateOf((LNode)node).visited = false;
        }
        for (LNode node : nodes) {
            this.calculateBarycenter(node, forward);
        }
    }

    private void calculateBarycenter(LNode node, boolean forward) {
        if (this.stateOf((LNode)node).visited) {
            return;
        }
        this.stateOf((LNode)node).visited = true;
        this.stateOf((LNode)node).degree = 0;
        this.stateOf((LNode)node).summedWeight = 0.0;
        this.stateOf((LNode)node).barycenter = null;
        for (LPort freePort : node.getPorts()) {
            Iterable<LPort> portIterable = forward ? freePort.getPredecessorPorts() : freePort.getSuccessorPorts();
            for (LPort fixedPort : portIterable) {
                LNode fixedNode = fixedPort.getNode();
                if (fixedNode.getLayer() == node.getLayer()) {
                    if (fixedNode == node) continue;
                    this.calculateBarycenter(fixedNode, forward);
                    this.stateOf((LNode)node).degree += this.stateOf((LNode)fixedNode).degree;
                    this.stateOf((LNode)node).summedWeight += this.stateOf((LNode)fixedNode).summedWeight;
                    continue;
                }
                this.stateOf((LNode)node).summedWeight += (double)this.portRanks[fixedPort.id];
                ++this.stateOf((LNode)node).degree;
            }
        }
        List barycenterAssociates = (List)node.getProperty(InternalProperties.BARYCENTER_ASSOCIATES);
        if (barycenterAssociates != null) {
            for (LNode associate : barycenterAssociates) {
                if (node.getLayer() != associate.getLayer()) continue;
                this.calculateBarycenter(associate, forward);
                this.stateOf((LNode)node).degree += this.stateOf((LNode)associate).degree;
                this.stateOf((LNode)node).summedWeight += this.stateOf((LNode)associate).summedWeight;
            }
        }
        if (this.stateOf((LNode)node).degree > 0) {
            this.stateOf((LNode)node).summedWeight += (double)(this.random.nextFloat() * 0.07f - 0.035f);
            this.stateOf((LNode)node).barycenter = this.stateOf((LNode)node).summedWeight / (double)this.stateOf((LNode)node).degree;
        }
    }

    private BarycenterState stateOf(LNode node) {
        return this.barycenterState[node.getLayer().id][node.id];
    }

    public static final class BarycenterState {
        public LNode node;
        public double summedWeight;
        public int degree;
        public Double barycenter;
        public boolean visited;

        public BarycenterState(LNode node) {
            this.node = node;
        }
    }
}

