/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathGroup;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathMessages;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;

public class AJClasspathModel
extends ClasspathModel {
    public static final int ASPECTPATH = 2;
    public static final int OUTJAR = 3;
    private ClasspathGroup bootstrapEntries;
    private ClasspathGroup userEntries;
    private ClasspathGroup aspectPathEntries;
    private ClasspathGroup outJarEntries;

    public AJClasspathModel() {
        this.getBootstrapEntry();
        this.getUserEntry();
        this.getAspectPathEntry();
        this.getOutJarEntry();
    }

    public Object addEntry(int entryType, IRuntimeClasspathEntry entry) {
        IClasspathEntry entryParent = null;
        switch (entryType) {
            case 0: {
                entryParent = this.getBootstrapEntry();
                break;
            }
            case 1: {
                entryParent = this.getUserEntry();
                break;
            }
            case 2: {
                entryParent = this.getAspectPathEntry();
                break;
            }
            case 3: {
                entryParent = this.getOutJarEntry();
            }
        }
        ClasspathEntry newEntry = this.createEntry(entry, entryParent);
        for (Object element : this.childEntries) {
            if (!(element instanceof ClasspathGroup ? ((ClasspathGroup)element).contains((IClasspathEntry)newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        if (entryParent != null) {
            ((ClasspathGroup)entryParent).addEntry((IClasspathEntry)newEntry, null);
        } else {
            this.childEntries.add(newEntry);
        }
        return newEntry;
    }

    public void removeAll() {
        if (this.bootstrapEntries != null) {
            this.bootstrapEntries.removeAll();
        }
        if (this.userEntries != null) {
            this.userEntries.removeAll();
        }
        if (this.aspectPathEntries != null) {
            this.aspectPathEntries.removeAll();
        }
        if (this.outJarEntries != null) {
            this.outJarEntries.removeAll();
        }
    }

    public void setBootstrapEntries(IRuntimeClasspathEntry[] entries) {
        if (this.bootstrapEntries == null) {
            this.getBootstrapEntry();
        }
        this.bootstrapEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.bootstrapEntries.addEntry((IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)this.bootstrapEntries), null);
            ++i;
        }
    }

    public void setUserEntries(IRuntimeClasspathEntry[] entries) {
        if (this.userEntries == null) {
            this.getUserEntry();
        }
        this.userEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.userEntries.addEntry((IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)this.userEntries), null);
            ++i;
        }
    }

    public void setAspectPathEntries(IRuntimeClasspathEntry[] entries) {
        if (this.aspectPathEntries == null) {
            this.getAspectPathEntry();
        }
        this.aspectPathEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.aspectPathEntries.addEntry((IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)this.aspectPathEntries), null);
            ++i;
        }
    }

    private IClasspathEntry getAspectPathEntry() {
        if (this.aspectPathEntries == null) {
            String name = UIMessages.Launcher_aspectPath;
            this.aspectPathEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.aspectPathEntries;
    }

    private IClasspathEntry getOutJarEntry() {
        if (this.outJarEntries == null) {
            String name = UIMessages.Launcher_outJar;
            this.outJarEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.outJarEntries;
    }

    public IClasspathEntry getBootstrapEntry() {
        if (this.bootstrapEntries == null) {
            String name = ClasspathMessages.ClasspathModel_0;
            this.bootstrapEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.bootstrapEntries;
    }

    public IClasspathEntry getUserEntry() {
        if (this.userEntries == null) {
            String name = ClasspathMessages.ClasspathModel_1;
            this.userEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.userEntries;
    }

    public ClasspathGroup createGroupEntry(IRuntimeClasspathEntry[] entries, ClasspathGroup entryParent, String name, boolean canBeRemoved, boolean addEntry) {
        ClasspathGroup group = new ClasspathGroup(name, (IClasspathEntry)entryParent, canBeRemoved);
        int i = 0;
        while (i < entries.length) {
            group.addEntry((IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)group), null);
            ++i;
        }
        if (addEntry) {
            this.addEntry(group);
        }
        return group;
    }

    public IClasspathEntry[] getEntries(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.bootstrapEntries == null) break;
                return this.bootstrapEntries.getEntries();
            }
            case 1: {
                if (this.userEntries == null) break;
                return this.userEntries.getEntries();
            }
            case 2: {
                if (this.aspectPathEntries == null) break;
                return this.aspectPathEntries.getEntries();
            }
            case 3: {
                if (this.outJarEntries == null) break;
                return this.outJarEntries.getEntries();
            }
        }
        return new IClasspathEntry[0];
    }
}

