/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.res.StringManager;

final class StandardHostValve
extends ValveBase {
    protected static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    protected static final boolean ACCESS_SESSION;
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";
    private static final StringManager sm;

    public StandardHostValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        PrivilegedSetTccl pa;
        Context context = request.getContext();
        if (context == null) {
            response.sendError(500, sm.getString("standardHost.noContext"));
            return;
        }
        if (context.getLoader() != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(context.getLoader().getClassLoader());
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
            }
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(context.getPipeline().isAsyncSupported());
        }
        context.getPipeline().getFirst().invoke(request, response);
        if (ACCESS_SESSION) {
            request.getSession(false);
        }
        if (Globals.IS_SECURITY_ENABLED) {
            pa = new PrivilegedSetTccl(StandardHostValve.class.getClassLoader());
            AccessController.doPrivileged(pa);
        } else {
            Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
        }
    }

    @Override
    public final void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        Context context = request.getContext();
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        context.getPipeline().getFirst().event(request, response, event);
        if (ACCESS_SESSION) {
            request.getSession(false);
        }
        Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
    }

    static {
        String accessSession = System.getProperty("org.apache.catalina.core.StandardHostValve.ACCESS_SESSION");
        ACCESS_SESSION = accessSession == null ? STRICT_SERVLET_COMPLIANCE : Boolean.valueOf(accessSession);
        sm = StringManager.getManager((String)"org.apache.catalina.core");
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }
}

