/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.eclipse.gemini.naming.BuilderSupportedInitialContextFactory;
import org.eclipse.gemini.naming.FactoryManager;
import org.eclipse.gemini.naming.ReflectionUtils;
import org.eclipse.gemini.naming.SecurityUtils;

class ServiceAwareContextFactory {
    private static Logger logger = Logger.getLogger(ServiceAwareContextFactory.class.getName());

    private ServiceAwareContextFactory() {
    }

    static Context createServiceAwareContextWrapper(InitialContextFactory factory, Context internalContext, FactoryManager manager) {
        return (Context)Proxy.newProxyInstance(ServiceAwareContextFactory.class.getClassLoader(), new Class[]{Context.class}, (InvocationHandler)new DefaultServiceAwareInvocationHandler(factory, internalContext, manager));
    }

    static DirContext createServiceAwareDirContextWrapper(InitialContextFactory factory, DirContext internalContext, FactoryManager manager) {
        return (DirContext)Proxy.newProxyInstance(ServiceAwareContextFactory.class.getClassLoader(), new Class[]{DirContext.class}, (InvocationHandler)new DefaultServiceAwareInvocationHandler(factory, internalContext, manager));
    }

    static LdapContext createServiceAwareLdapContextWrapper(InitialContextFactory factory, LdapContext internalContext, FactoryManager manager) {
        return (LdapContext)Proxy.newProxyInstance(ServiceAwareContextFactory.class.getClassLoader(), new Class[]{LdapContext.class}, (InvocationHandler)new DefaultServiceAwareInvocationHandler(factory, internalContext, manager));
    }

    private static class DefaultServiceAwareInvocationHandler
    implements InvocationHandler {
        private InitialContextFactory m_factory;
        private Context m_context;
        private final FactoryManager m_manager;
        private final Object lock = new Object();
        private volatile boolean m_isOpen;

        DefaultServiceAwareInvocationHandler(InitialContextFactory factory, Context context, FactoryManager manager) {
            this.m_factory = factory;
            this.m_context = context;
            this.m_manager = manager;
            this.m_isOpen = true;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.invokeContextMethod(method, args);
            }
            catch (Exception exception) {
                if (exception instanceof NamingException) {
                    throw (NamingException)exception;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Exception occurred during a doPrivileged call", exception);
                }
                NamingException namingException = new NamingException("Exception occured during a Context method invocation");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invokeContextMethod(Method method, Object[] args) throws Throwable {
            if (this.m_isOpen) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.m_isOpen) {
                        if (!method.getName().equals("close")) {
                            FactoryManager factoryManager = this.m_manager;
                            synchronized (factoryManager) {
                                if (!this.isFactoryServiceActive()) {
                                    SecurityUtils.invokePrivilegedActionNoReturn(new ObtainFactory());
                                }
                            }
                        } else {
                            this.m_isOpen = false;
                        }
                    }
                }
            }
            return ReflectionUtils.invokeMethodOnContext(method, this.m_context, args);
        }

        private void obtainNewFactory() throws NamingException, Throwable, NoInitialContextException {
            Hashtable newContextEnvironment = new Hashtable();
            if (this.m_context.getEnvironment() != null) {
                newContextEnvironment.putAll(this.m_context.getEnvironment());
            }
            try {
                InitialContextFactory newFactory = this.m_manager.createInitialContextFactory(newContextEnvironment);
                if (newFactory != null) {
                    this.m_factory = newFactory;
                    Context newInternalContext = this.m_factory.getInitialContext(newContextEnvironment);
                    if (newInternalContext != null) {
                        this.m_context = newInternalContext;
                        return;
                    }
                }
            }
            catch (NoInitialContextException noContextException) {
                logger.log(Level.SEVERE, "An exception occurred while attempting to rebind the JNDI Provider service for this Context", noContextException);
            }
            throw new NoInitialContextException("The service that created this JNDI Context is not available");
        }

        private boolean isFactoryServiceActive() {
            if (this.m_factory instanceof BuilderSupportedInitialContextFactory) {
                return this.m_manager.isFactoryServiceActive(((BuilderSupportedInitialContextFactory)this.m_factory).getBuilder());
            }
            return this.m_manager.isFactoryServiceActive(this.m_factory);
        }

        private class ObtainFactory
        implements PrivilegedExceptionAction {
            private ObtainFactory() {
            }

            public Object run() throws Exception {
                try {
                    DefaultServiceAwareInvocationHandler.this.obtainNewFactory();
                    return null;
                }
                catch (Throwable e) {
                    if (e instanceof NamingException) {
                        throw (NamingException)e;
                    }
                    NamingException namingException = new NamingException("Error while attempting to obtain factory service on behalf of Context");
                    namingException.setRootCause(e);
                    throw namingException;
                }
            }
        }
    }
}

