/*
 * Decompiled with CFR 0.152.
 */
package model.account;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import model.account.Account;
import model.account.TxOperation;

@Entity
@Table(name="ACCT_TXN")
@NamedQuery(name="Transaction.findAllSince", query="SELECT t FROM Transaction t WHERE t.account = :account AND t.txTime >= :dateArg")
public class Transaction {
    @Id
    @GeneratedValue
    int id;
    @ManyToOne
    Account account;
    @Column(name="OP")
    TxOperation operation;
    double amount;
    @Temporal(value=TemporalType.TIME)
    Date txTime;

    public Transaction() {
    }

    public Transaction(Account account, TxOperation operation, double amount) {
        this.account = account;
        account.getTxns().add(this);
        this.operation = operation;
        this.amount = amount;
        this.txTime = Calendar.getInstance().getTime();
    }

    public int getId() {
        return this.id;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public TxOperation getOperation() {
        return this.operation;
    }

    public void setOperation(TxOperation operation) {
        this.operation = operation;
    }

    public Date getTxTime() {
        return this.txTime;
    }

    public void setTxTime(Date txTime) {
        this.txTime = txTime;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String toString() {
        return "(" + this.txTime + " - " + "Acct#: " + this.account.getId() + " " + this.operation.toString() + ": " + this.amount + ")";
    }
}

