/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.jmx.JmxConstants;

public final class OSGiProperties {
    private static final String VERSION = "Version";
    private static final List<String> SCALAR_TYPES = Collections.unmodifiableList(Arrays.asList("String", "Integer", "Long", "Float", "Double", "Byte", "Short", "Character", "Boolean", "BigDecimal", "BigInteger"));
    private static final List<String> PRIMITIVE_TYPES = Collections.unmodifiableList(Arrays.asList("byte", "char", "short", "int", "long", "double", "float"));

    public static TabularData tableFrom(Dictionary<String, Object> properties) {
        TabularDataSupport table = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                table.put(OSGiProperties.encode(key, properties.get(key)));
            }
        }
        return table;
    }

    public static TabularData tableFrom(ServiceReference<?> ref) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            props.put(key, ref.getProperty(key));
            ++n2;
        }
        return OSGiProperties.tableFrom(props);
    }

    public static CompositeData encode(String key, Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            return OSGiProperties.encodeArray(key, value, clazz.getComponentType());
        }
        if (clazz.equals(Vector.class)) {
            return OSGiProperties.encodeVector(key, (Vector)value);
        }
        return OSGiProperties.propertyData(key, value.toString(), OSGiProperties.typeOf(clazz));
    }

    public static Dictionary<String, Object> propertiesFrom(TabularData table) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (table == null) {
            return props;
        }
        for (CompositeData data : table.values()) {
            props.put((String)data.get("Key"), OSGiProperties.parse((String)data.get("Value"), (String)data.get("Type")));
        }
        return props;
    }

    public static Map<String, ?> getDirectiveKeyValueItem(String key, Object value) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Key", key);
        items.put("Value", value);
        return items;
    }

    private static CompositeData encodeArray(String key, Object value, Class<?> componentClazz) {
        Object[] array;
        StringBuffer buf = new StringBuffer();
        if (Integer.TYPE.equals(componentClazz)) {
            array = (int[])value;
            int i = 0;
            while (i < array.length) {
                buf.append(array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Long.TYPE.equals(componentClazz)) {
            array = (long[])value;
            int i = 0;
            while (i < array.length) {
                buf.append((long)array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Double.TYPE.equals(componentClazz)) {
            array = (double[])value;
            int i = 0;
            while (i < array.length) {
                buf.append((double)array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Float.TYPE.equals(componentClazz)) {
            array = (float[])value;
            int i = 0;
            while (i < array.length) {
                buf.append((float)array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Byte.TYPE.equals(componentClazz)) {
            array = (byte[])value;
            int i = 0;
            while (i < array.length) {
                buf.append(array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Short.TYPE.equals(componentClazz)) {
            array = (short[])value;
            int i = 0;
            while (i < array.length) {
                buf.append(array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Character.TYPE.equals(componentClazz)) {
            array = (char[])value;
            int i = 0;
            while (i < array.length) {
                buf.append(array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else if (Boolean.TYPE.equals(componentClazz)) {
            array = (boolean[])value;
            int i = 0;
            while (i < array.length) {
                buf.append(array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        } else {
            array = (Object[])value;
            int i = 0;
            while (i < array.length) {
                buf.append((Object)array[i]);
                if (i < array.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
        }
        String type = OSGiProperties.typeOf(componentClazz);
        return OSGiProperties.propertyData(key, buf.toString(), "Array of " + type);
    }

    private static CompositeData encodeVector(String key, Vector<?> value) {
        String type = "String";
        if (value.size() > 0) {
            type = OSGiProperties.typeOf(value.get(0).getClass());
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.size()) {
            buf.append(value.get(i));
            if (i < value.size() - 1) {
                buf.append(',');
            }
            ++i;
        }
        return OSGiProperties.propertyData(key, buf.toString(), "Vector of " + type);
    }

    private static String typeOf(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return "String";
        }
        if (clazz.equals(Version.class)) {
            return VERSION;
        }
        if (clazz.equals(Integer.class)) {
            return "Integer";
        }
        if (clazz.equals(Long.class)) {
            return "Long";
        }
        if (clazz.equals(Double.class)) {
            return "Double";
        }
        if (clazz.equals(Double.class)) {
            return "Float";
        }
        if (clazz.equals(Byte.class)) {
            return "Byte";
        }
        if (clazz.equals(Short.class)) {
            return "Short";
        }
        if (clazz.equals(Character.class)) {
            return "Character";
        }
        if (clazz.equals(Boolean.class)) {
            return "Boolean";
        }
        if (clazz.equals(BigDecimal.class)) {
            return "BigDecimal";
        }
        if (clazz.equals(BigInteger.class)) {
            return "BigInteger";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Long.TYPE)) {
            return "long";
        }
        if (clazz.equals(Double.TYPE)) {
            return "double";
        }
        if (clazz.equals(Double.TYPE)) {
            return "float";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "byte";
        }
        if (clazz.equals(Short.TYPE)) {
            return "short";
        }
        if (clazz.equals(Character.TYPE)) {
            return "char";
        }
        if (clazz.equals(Boolean.TYPE)) {
            return "boolean";
        }
        throw new IllegalArgumentException("Illegal type: " + clazz);
    }

    private static CompositeData propertyData(String key, String value, String type) {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("Key", key);
        items.put("Value", value);
        items.put("Type", type);
        try {
            return new CompositeDataSupport(JmxConstants.PROPERTY_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form property open data", e);
        }
    }

    private static Object parse(String value, String type) {
        StringTokenizer tokens = new StringTokenizer(type);
        if (!tokens.hasMoreElements()) {
            throw new IllegalArgumentException("Type is empty");
        }
        String token = tokens.nextToken();
        if ("Array".equals(token)) {
            return OSGiProperties.parseArray(value, tokens);
        }
        if ("Vector".equals(token)) {
            return OSGiProperties.parseVector(value, tokens);
        }
        if (SCALAR_TYPES.contains(token) || PRIMITIVE_TYPES.contains(token)) {
            return OSGiProperties.parseValue(value, token);
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private static Object parseArray(String value, StringTokenizer tokens) {
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Expecting <of> token in Array type");
        }
        if (!"of".equals(tokens.nextToken())) {
            throw new IllegalArgumentException("Expecting <of> token in Array type");
        }
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Expecting <primitive>|<scalar> token in Array type");
        }
        String type = tokens.nextToken();
        if (SCALAR_TYPES.contains(type)) {
            return OSGiProperties.parseScalarArray(value, type);
        }
        if (PRIMITIVE_TYPES.contains(type)) {
            return OSGiProperties.parsePrimitiveArray(value, type);
        }
        throw new IllegalArgumentException("Expecting <scalar>|<primitive> type token in Array type: " + type);
    }

    /*
     * Unable to fully structure code
     */
    private static Object parseVector(String value, StringTokenizer tokens) {
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Expecting <of> token in Vector type");
        }
        if (!tokens.nextElement().equals("of")) {
            throw new IllegalArgumentException("Expecting <of> token in Vector type");
        }
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Expecting <scalar> token in Vector type");
        }
        type = tokens.nextToken();
        values = new StringTokenizer(value, ",");
        vector = new Vector<Object>();
        if (OSGiProperties.SCALAR_TYPES.contains(type)) ** GOTO lbl14
        throw new IllegalArgumentException("Expecting <scalar> type token in Vector type: " + type);
lbl-1000:
        // 1 sources

        {
            vector.add(OSGiProperties.parseScalar(values.nextToken().trim(), type));
lbl14:
            // 2 sources

            ** while (values.hasMoreTokens())
        }
lbl15:
        // 1 sources

        return vector;
    }

    private static Object[] parseScalarArray(String value, String type) {
        ArrayList<Object> array = new ArrayList<Object>();
        StringTokenizer values = new StringTokenizer(value, ",");
        while (values.hasMoreTokens()) {
            array.add(OSGiProperties.parseScalar(values.nextToken().trim(), type));
        }
        return array.toArray(OSGiProperties.createScalarArray(type, array.size()));
    }

    private static Object parsePrimitiveArray(String value, String type) {
        StringTokenizer values = new StringTokenizer(value, ",");
        if ("int".equals(type)) {
            int[] array = new int[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Integer.parseInt(values.nextToken().trim());
            }
            return array;
        }
        if ("long".equals(type)) {
            long[] array = new long[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Long.parseLong(values.nextToken().trim());
            }
            return array;
        }
        if ("double".equals(type)) {
            double[] array = new double[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Double.parseDouble(values.nextToken().trim());
            }
            return array;
        }
        if ("float".equals(type)) {
            float[] array = new float[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Float.parseFloat(values.nextToken().trim());
            }
            return array;
        }
        if ("byte".equals(type)) {
            byte[] array = new byte[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Byte.parseByte(values.nextToken().trim());
            }
            return array;
        }
        if ("short".equals(type)) {
            short[] array = new short[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Short.parseShort(values.nextToken().trim());
            }
            return array;
        }
        if ("char".equals(type)) {
            char[] array = new char[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = values.nextToken().trim().charAt(0);
            }
            return array;
        }
        if ("boolean".equals(type)) {
            boolean[] array = new boolean[values.countTokens()];
            int i = 0;
            while (values.hasMoreTokens()) {
                array[i++] = Boolean.parseBoolean(values.nextToken().trim());
            }
            return array;
        }
        throw new IllegalArgumentException("Unknown primitive type: " + type);
    }

    private static Object[] createScalarArray(String type, int size) {
        if ("String".equals(type)) {
            return new String[size];
        }
        if (VERSION.equals(type)) {
            return new Version[size];
        }
        if ("Integer".equals(type)) {
            return new Integer[size];
        }
        if ("Long".equals(type)) {
            return new Long[size];
        }
        if ("Double".equals(type)) {
            return new Double[size];
        }
        if ("Float".equals(type)) {
            return new Float[size];
        }
        if ("Byte".equals(type)) {
            return new Byte[size];
        }
        if ("Short".equals(type)) {
            return new Short[size];
        }
        if ("Character".equals(type)) {
            return new Character[size];
        }
        if ("Boolean".equals(type)) {
            return new Boolean[size];
        }
        if ("BigDecimal".equals(type)) {
            return new BigDecimal[size];
        }
        if ("BigInteger".equals(type)) {
            return new BigInteger[size];
        }
        throw new IllegalArgumentException("Unknown scalar type: " + type);
    }

    private static Object parseScalar(String value, String type) {
        if ("String".equals(type)) {
            return value;
        }
        if (VERSION.equals(type)) {
            return Version.parseVersion((String)value);
        }
        if ("Integer".equals(type)) {
            return Integer.parseInt(value);
        }
        if ("Long".equals(type)) {
            return Long.parseLong(value);
        }
        if ("Double".equals(type)) {
            return Double.parseDouble(value);
        }
        if ("Float".equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if ("Byte".equals(type)) {
            return Byte.parseByte(value);
        }
        if ("Short".equals(type)) {
            return Short.parseShort(value);
        }
        if ("Character".equals(type)) {
            return Character.valueOf(value.charAt(0));
        }
        if ("Boolean".equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if ("BigDecimal".equals(type)) {
            return new BigDecimal(value);
        }
        if ("BigInteger".equals(type)) {
            return new BigInteger(value);
        }
        throw new IllegalArgumentException("Unknown scalar type: " + type);
    }

    private static Object parseValue(String value, String type) {
        try {
            return OSGiProperties.parseScalar(value, type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if ("int".equals(type)) {
                return Integer.parseInt(value);
            }
            if ("long".equals(type)) {
                return Long.parseLong(value);
            }
            if ("double".equals(type)) {
                return Double.parseDouble(value);
            }
            if ("float".equals(type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if ("byte".equals(type)) {
                return Byte.parseByte(value);
            }
            if ("short".equals(type)) {
                return Short.parseShort(value);
            }
            if ("char".equals(type)) {
                return Character.valueOf(value.charAt(0));
            }
            if ("boolean".equals(type)) {
                return Boolean.parseBoolean(value);
            }
            throw new IllegalArgumentException("Unknown scalar type: " + type);
        }
    }
}

