/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.base;

import java.util.ArrayList;
import org.eclipse.etrice.generator.fsm.base.GenFile;
import org.eclipse.etrice.generator.fsm.base.GenItem;

public class GenDir
extends GenItem {
    private ArrayList<GenItem> contents = new ArrayList();

    public GenDir(GenDir parent, String name) {
        super(parent, name);
    }

    public ArrayList<GenItem> getContents() {
        return this.contents;
    }

    public ArrayList<GenFile> getFiles() {
        ArrayList<GenFile> sources = new ArrayList<GenFile>();
        for (GenItem item : this.contents) {
            if (!(item instanceof GenFile)) continue;
            sources.add((GenFile)item);
        }
        return sources;
    }

    public ArrayList<GenDir> getDirs() {
        ArrayList<GenDir> dirs = new ArrayList<GenDir>();
        for (GenItem item : this.contents) {
            if (!(item instanceof GenDir)) continue;
            dirs.add((GenDir)item);
        }
        return dirs;
    }

    public ArrayList<String> getNestedRelativePathsWithExtension(String ext) {
        ArrayList<String> dirs = new ArrayList<String>();
        for (GenItem item : this.contents) {
            if (!(item instanceof GenDir)) continue;
            if (((GenDir)item).hasFilesWithExtension(ext)) {
                dirs.add(item.getName());
                continue;
            }
            ArrayList<String> nested = ((GenDir)item).getNestedRelativePathsWithExtension(ext);
            for (String ndir : nested) {
                dirs.add(((GenDir)item).getName() + "/" + ndir);
            }
        }
        return dirs;
    }

    public boolean hasFilesWithExtension(String ext) {
        ArrayList<GenFile> sources = this.getFiles();
        for (GenFile source : sources) {
            if (!source.getExtension().equals(ext)) continue;
            return true;
        }
        return false;
    }
}

