/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime.builtins;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.tooldef.runtime.ToolDefException;

public class BuiltInPathTools {
    private BuiltInPathTools() {
    }

    public static String abspath(String path) {
        return BuiltInPathTools.abspath(path, BuiltInPathTools.curdir());
    }

    public static String abspath(String path, String workdir) {
        return org.eclipse.escet.common.app.framework.Paths.resolve((String)path, (String)workdir);
    }

    public static String basename(String path) {
        if (path.endsWith("\\") || path.endsWith("/")) {
            String msg = Strings.fmt((String)"Failed to get base name: path \"%s\" ends with \"\\\" or \"/\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        return org.eclipse.escet.common.app.framework.Paths.getFileName((String)path);
    }

    public static void chdir(String path) {
        Path workdir;
        String absPath = BuiltInPathTools.abspath(path, BuiltInPathTools.curdir());
        try {
            workdir = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to change current working directory: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(workdir, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to change current working directory: path \"%s\" does not exist.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        if (!Files.isDirectory(workdir, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to change current working directory: path \"%s\" is not a directory.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        org.eclipse.escet.common.app.framework.Paths.setCurWorkingDir((String)absPath);
    }

    public static String chfileext(String path, String oldext, String newext) {
        return org.eclipse.escet.common.app.framework.Paths.pathChangeExtension((String)path, (String)oldext, (String)newext);
    }

    public static String curdir() {
        return org.eclipse.escet.common.app.framework.Paths.getCurWorkingDir();
    }

    public static String dirname(String path) {
        if (!path.contains("\\") && !path.contains("/")) {
            String msg = Strings.fmt((String)"Failed to get directory name: path \"%s\" is not an absolute local file system path.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        if (path.endsWith("\\") || path.endsWith("/")) {
            String msg = Strings.fmt((String)"Failed to get directory name: path \"%s\" ends with \"\\\" or \"/\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        return org.eclipse.escet.common.app.framework.Paths.getAbsFilePathDir((String)path);
    }

    public static String fileext(String path) {
        return org.eclipse.escet.common.app.framework.Paths.getExtension((String)path);
    }

    public static boolean hasfileext(String path, String ext) {
        String realExt = BuiltInPathTools.fileext(path).toLowerCase(Locale.US);
        return realExt.equals(ext.toLowerCase(Locale.US));
    }

    public static String pathjoin(List<String> paths) {
        if (paths.size() == 0) {
            return "";
        }
        if (paths.size() == 1) {
            return paths.get(0);
        }
        return org.eclipse.escet.common.app.framework.Paths.join((String[])paths.toArray(new String[paths.size()]));
    }

    public static String scriptpath() {
        String propName = "org.eclipse.escet.tooldef.interpreter.scriptpath";
        return AppEnv.getProperty((String)"org.eclipse.escet.tooldef.interpreter.scriptpath");
    }
}

