/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.options;

import org.eclipse.escet.cif.plcgen.options.PlcNumberBits;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class PlcIntTypeSizeOption
extends EnumOption<PlcNumberBits> {
    public PlcIntTypeSizeOption() {
        super("PLC integer type size", "BITS is the number of bits for an integer value in the PLC. Specify \"auto\" to automatically determine the size, \"32\" for 32-bits integer values, or \"64\" for 64-bits integer values. [DEFAULT=auto]", null, "int-size", "BITS", (Enum)PlcNumberBits.AUTO, true, "The number of bits for an integer value in PLC.");
    }

    protected String getDialogText(PlcNumberBits value) {
        return value.dialogText;
    }

    public PlcNumberBits parseValue(String optName, String value) {
        PlcNumberBits[] plcNumberBitsArray = PlcNumberBits.values();
        int n = plcNumberBitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlcNumberBits option = plcNumberBitsArray[n2];
            if (value.equals(option.cmdValueTxt)) {
                return option;
            }
            ++n2;
        }
        throw new InvalidOptionException("Unknown option value: " + value);
    }

    public String[] getCmdLine(Object value) {
        String valueTxt = ((PlcNumberBits)((Object)value)).cmdValueTxt;
        return new String[]{"--" + this.cmdLong + "=" + valueTxt};
    }

    public static PlcNumberBits getNumberBits() {
        return (PlcNumberBits)((Object)Options.get(PlcIntTypeSizeOption.class));
    }
}

