/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;
import org.eclipse.ocl.cst.OCLExpressionCS;

public class ProtectStatement
extends Statement {
    private final ExpressionHelper commentStart;
    private final ExpressionHelper commentEnd;
    private final Statement[] body;
    private final ExpressionHelper id;
    private final boolean disable;

    public ProtectStatement(int start, int end, int line, OCLExpressionCS commentStart, OCLExpressionCS commentEnd, Statement[] body, OCLExpressionCS id, boolean disable) {
        super(start, end, line);
        this.commentStart = new ExpressionHelper(commentStart, this);
        this.commentEnd = new ExpressionHelper(commentEnd, this);
        this.body = body;
        this.id = new ExpressionHelper(id, this);
        this.disable = disable;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        this.commentStart.analyze(ctx, issues);
        this.commentEnd.analyze(ctx, issues);
        this.id.analyze(ctx, issues);
        int i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        String cStart = this.nullSave(this.commentStart.evaluate(ctx));
        if (cStart == null) {
            throw new EvaluationException("NullEvaluation!", this.commentStart);
        }
        String cEnd = this.nullSave(this.commentEnd.evaluate(ctx));
        if (cEnd == null) {
            throw new EvaluationException("NullEvaluation!", this.commentEnd);
        }
        String idv = this.nullSave(this.id.evaluate(ctx));
        if (idv == null) {
            throw new EvaluationException("NullEvaluation!", this.id);
        }
    }

    private String nullSave(Object string) {
        return string != null ? string.toString() : "";
    }

    ExpressionHelper getCommentStart() {
        return this.commentStart;
    }

    ExpressionHelper getCommentEnd() {
        return this.commentEnd;
    }

    ExpressionHelper getId() {
        return this.id;
    }

    Statement[] getBody() {
        return this.body;
    }
}

