/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor;

import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.gmf.internal.xpand.editor.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public class EditorImages
implements IDisposable {
    private final ImageRegistry myRegistry = new ImageRegistry(Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent());
    private static SoftReference<EditorImages> ourState;

    protected EditorImages() {
    }

    public static EditorImages get() {
        EditorImages inst;
        EditorImages editorImages = inst = ourState == null ? null : ourState.get();
        if (inst == null) {
            inst = new EditorImages();
            ourState = new SoftReference<EditorImages>(inst);
        }
        return inst;
    }

    public Image getExtension() {
        return this.imageFromPath("extension.gif");
    }

    public Image getOperation() {
        return this.imageFromPath("operation.gif");
    }

    public Image getProperty() {
        return this.imageFromPath("property.gif");
    }

    public Image getVariable() {
        return this.imageFromPath("variable.gif");
    }

    public Image getType() {
        return this.imageFromPath("type.gif");
    }

    public Image getStatement() {
        return this.imageFromPath("statement.gif");
    }

    protected Image imageFromPath(String path) {
        if (this.myRegistry.getDescriptor(path) == null) {
            ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
            try {
                desc = ImageDescriptor.createFromURL((URL)EditorImages.makeIconFileURL(path));
            }
            catch (MalformedURLException me) {
                Activator.logError(me);
            }
            this.myRegistry.put(path, desc);
        }
        return this.myRegistry.get(path);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        return Activator.getDefault().getBundle().getEntry("/icons/" + iconPath);
    }

    public void dispose() {
        this.myRegistry.dispose();
    }
}

