/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.lite.figures.ICompartmentHandleLocatorProvider;
import org.eclipse.gmf.runtime.lite.figures.LineBorderEx;

public class CompartmentFigure
extends Figure
implements ICompartmentHandleLocatorProvider {
    public CompartmentFigure() {
        this.setMinimumSize(new Dimension(10, 10));
        this.setHeaderHeight(10);
    }

    public void addNotify() {
        if (this.getFont() != null) {
            this.setHeaderHeight(this.getFont().getFontData()[0].getHeight());
        }
        super.addNotify();
    }

    public void setHeaderHeight(int height) {
        super.setBorder((Border)new CompoundBorder((Border)new LineBorderEx(ColorConstants.black, 1, 8), (Border)new MarginBorder(height, 0, 0, 0)));
    }

    public final void setBorder(Border border) {
    }

    @Override
    public Locator getCompartmentHandleLocator() {
        return new Locator(){

            public void relocate(IFigure target) {
                Rectangle theBounds = CompartmentFigure.this.getBounds().getCopy();
                CompartmentFigure.this.translateToAbsolute((Translatable)theBounds);
                target.translateToRelative((Translatable)theBounds);
                Dimension preferredSize = target.getPreferredSize();
                theBounds.height = Math.min(theBounds.height, preferredSize.height);
                theBounds.width = Math.max(theBounds.width, preferredSize.width);
                target.setBounds(theBounds);
            }
        };
    }
}

