/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;

public class SetBoundsCommand
extends AbstractCommand {
    private final Node myNode;
    private final Rectangle myBounds;
    private Rectangle myOldBounds;

    public SetBoundsCommand(Node node, Rectangle bounds) {
        super("Set node position/size");
        this.myNode = node;
        this.myBounds = bounds;
    }

    public boolean canUndo() {
        return true;
    }

    protected boolean prepare() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.myNode);
        if (domain != null && domain.isReadOnly(this.myNode.eResource())) {
            return false;
        }
        if (this.myNode.getLayoutConstraint() == null) {
            this.myOldBounds = null;
            return true;
        }
        if (!(this.myNode.getLayoutConstraint() instanceof Bounds)) {
            return false;
        }
        Bounds bounds = (Bounds)this.myNode.getLayoutConstraint();
        this.myOldBounds = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        return true;
    }

    public void redo() {
        this.execute();
    }

    public void execute() {
        this.execute(this.myBounds);
    }

    public void undo() {
        this.execute(this.myOldBounds);
    }

    private void execute(Rectangle rect) {
        if (rect == null) {
            this.myNode.setLayoutConstraint(null);
            return;
        }
        Bounds bounds = (Bounds)this.myNode.getLayoutConstraint();
        if (bounds == null) {
            bounds = NotationFactory.eINSTANCE.createBounds();
            this.myNode.setLayoutConstraint((LayoutConstraint)bounds);
        }
        bounds.setX(rect.x);
        bounds.setY(rect.y);
        bounds.setWidth(rect.width);
        bounds.setHeight(rect.height);
    }
}

