/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.common.util.Multimap;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.AbstractSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.StateflowBlock;
import org.eclipse.epsilon.emc.simulink.operations.contributors.ModelOperationContributor;
import org.eclipse.epsilon.emc.simulink.util.SearchPreferences;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public class SimulinkModel
extends AbstractSimulinkModel
implements IOperationContributorProvider {
    @Deprecated
    public static final String PROPERTY_SHOW_IN_MATLAB_EDITOR = "hidden_editor";
    public static final String PROPERTY_FOLLOW_LINKS = "follow_links";
    public static final String PROPERTY_LOOK_UNDER_MASKS = "look_under_masks";
    public static final String PROPERTY_INCLUDE_COMMENTED = "include_commented";
    public static final String PROPERTY_CURRENT_SIMULINK_MODEL = "current_simulink_model";
    public static final String PROPERTY_FIND_OPTIMISATION = "find_optimisation_enabled";
    public static final String BLOCK = "Block";
    public static final String SIMULINK = "Simulink";
    public static final String STATEFLOW = "Stateflow";
    public static final String GET_PARAM = "get_param('?', 'Handle');";
    public static final String LOAD_SYSTEM = "load_system('?')";
    public static final String OPEN_SYSTEM = "open_system('?')";
    public static final String NEW_SYSTEM = "new_system('?', 'Model');";
    public static final String SAVE_SYSTEM = "save_system('?', '?');";
    private static final Multimap<String, String> createBlockMap = new Multimap();
    private static final ArrayList<ArrayList<String>> deleteBlockMap = new ArrayList();
    protected SearchPreferences searchPreferences = new SearchPreferences();
    protected ModelOperationContributor simulinkOperationContributor;
    protected boolean useCurrentSimulinkModel = false;
    protected boolean findOptimisationEnabled = true;
    @Deprecated
    protected boolean showInMatlabEditor = false;
    protected double handle = -1.0;
    protected String simulinkModelName;

    static {
        createBlockMap.put((Object)"sflib/Chart", (Object)"Stateflow.Chart");
        ArrayList<String> chart = new ArrayList<String>();
        chart.add("SubSystem");
        chart.add("Stateflow.Chart");
        deleteBlockMap.add(chart);
    }

    protected void loadModel() throws EolModelLoadingException {
        block14: {
            super.loadModel();
            try {
                this.simulinkOperationContributor = new ModelOperationContributor(this.engine);
                if (this.isUseCurrentSimulinkModel()) {
                    String evalWithResult = (String)this.engine.evalWithResult("gcs;");
                    this.setSimulinkModelName(evalWithResult);
                    this.handle = (Double)this.engine.evalWithResult("Simulink.ID.getHandle('?');", new Object[]{this.getSimulinkModelName()});
                    break block14;
                }
                this.setSimulinkModelName(this.getFile());
                if (this.readOnLoad) {
                    try {
                        this.engine.eval(LOAD_SYSTEM, new Object[]{this.file.getAbsolutePath()});
                        this.engine.flush();
                    }
                    catch (Exception exception) {
                        System.out.println("Model file does not exist. Creating new model in specified location: " + this.file.getAbsolutePath());
                        try {
                            this.engine.eval(NEW_SYSTEM, new Object[]{this.getSimulinkModelName()});
                        }
                        catch (Exception exception2) {}
                    }
                } else {
                    try {
                        this.engine.eval(NEW_SYSTEM, new Object[]{this.getSimulinkModelName()});
                    }
                    catch (Exception exception) {}
                }
                if (this.isOpenOnLoad().booleanValue()) {
                    try {
                        this.engine.eval(OPEN_SYSTEM, new Object[]{this.getSimulinkModelName()});
                        this.engine.flush();
                    }
                    catch (Exception exception) {}
                }
                this.handle = (Double)this.engine.evalWithResult(GET_PARAM, new Object[]{this.getSimulinkModelName()});
            }
            catch (Exception e) {
                throw new EolModelLoadingException(e, (IModel)this);
            }
        }
    }

    protected void closeMatlabModel() {
        try {
            this.engine.eval("bdclose('?');", new Object[]{this.getSimulinkModelName()});
            this.engine.flush();
        }
        catch (Exception exception) {
            System.err.println("Unable to close model");
        }
    }

    protected ISimulinkModelElement createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (type.contains("/")) {
            try {
                return new SimulinkBlock(this, this.engine, type);
            }
            catch (MatlabRuntimeException matlabRuntimeException) {
                throw new EolNotInstantiableModelElementTypeException(this.getSimulinkModelName(), type);
            }
        }
        if (type.startsWith("Stateflow.")) {
            try {
                return new StateflowBlock(this, this.engine, type);
            }
            catch (MatlabException matlabException) {
                throw new EolNotInstantiableModelElementTypeException(this.getSimulinkModelName(), type);
            }
        }
        return super.createInstanceInModel(type);
    }

    protected void addToCache(String type, ISimulinkModelElement instance) throws EolModelElementTypeNotFoundException {
        assert (this.kindCache != null);
        for (String kind : this.getAllTypeNamesOf(instance)) {
            Object kindCacheKey = this.getCacheKeyForType(kind);
            this.kindCache.putIfPresent(kindCacheKey, (Object)instance);
        }
    }

    protected void removeFromCache(ISimulinkModelElement instance) throws EolModelElementTypeNotFoundException {
        assert (this.kindCache != null);
        for (String kind : this.getAllTypeNamesOf(instance)) {
            Object kindCacheKey = this.getCacheKeyForType(kind);
            this.kindCache.remove(kindCacheKey, (Object)instance);
        }
    }

    public void deleteElement(Object o) throws EolRuntimeException {
        this.deleteElementInModel(o);
        if (this.isCachingEnabled() && o instanceof ISimulinkModelElement) {
            this.removeFromCache((ISimulinkModelElement)o);
            String type = ((ISimulinkModelElement)o).getType();
            for (List list : deleteBlockMap) {
                if (!list.contains(type)) continue;
                for (String equivalent : list) {
                    if (equivalent.equals(type)) continue;
                    this.kindCache.replaceValues((Object)equivalent, this.getAllOfTypeFromModel(equivalent));
                }
            }
        }
    }

    public ISimulinkModelElement createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        ISimulinkModelElement instance = this.createInstanceInModel(type);
        if (this.isCachingEnabled()) {
            this.addToCache(instance.getType(), instance);
            if (createBlockMap.containsKey((Object)type)) {
                for (String equivalent : createBlockMap.get((Object)type)) {
                    this.kindCache.replaceValues((Object)equivalent, this.getAllOfTypeFromModel(equivalent));
                }
            }
        }
        return instance;
    }

    public Object createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (type.startsWith(STATEFLOW) && parameters.size() == 1) {
            Object parentObject = parameters.toArray()[0];
            try {
                if (parentObject instanceof StateflowBlock) {
                    try {
                        StateflowBlock instance = new StateflowBlock(this, this.engine, type, (StateflowBlock)((Object)parentObject));
                        if (this.isCachingEnabled()) {
                            this.addToCache(instance.getType(), (ISimulinkModelElement)instance);
                            if (createBlockMap.containsKey((Object)type)) {
                                for (String equivalent : createBlockMap.get((Object)type)) {
                                    this.kindCache.replaceValues((Object)equivalent, this.getAllOfTypeFromModel(equivalent));
                                }
                            }
                        }
                        return instance;
                    }
                    catch (MatlabException e) {
                        throw new EolModelElementTypeNotFoundException(type, null, e.getMessage());
                    }
                }
                throw new EolModelElementTypeNotFoundException(type, null, "invalid parameters");
            }
            catch (EolRuntimeException e) {
                throw new EolModelElementTypeNotFoundException(type, null, e.getMessage());
            }
        }
        throw new EolModelElementTypeNotFoundException(type, null);
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        try {
            if (instance instanceof ISimulinkModelElement) {
                return ((ISimulinkModelElement)instance).deleteElementInModel();
            }
            return false;
        }
        catch (Exception e) {
            throw new EolInternalException((Throwable)e);
        }
    }

    protected Collection<ISimulinkModelElement> allContentsFromModel() {
        return TypeHelper.getAll(this);
    }

    protected Collection<ISimulinkModelElement> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        return TypeHelper.getAllOfType(this, type);
    }

    protected Collection<ISimulinkModelElement> getAllOfKindFromModel(String kind_) throws EolModelElementTypeNotFoundException {
        try {
            return TypeHelper.Kind.get(kind_).getAll(this);
        }
        catch (Exception exception) {
            return this.getAllOfTypeFromModel(kind_);
        }
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        this.setShowInMatlabEditor(properties.getBooleanProperty(PROPERTY_SHOW_IN_MATLAB_EDITOR, this.showInMatlabEditor));
        this.setFollowLinks(properties.getBooleanProperty(PROPERTY_FOLLOW_LINKS, this.getSearchPreferences().isFollowLinks().booleanValue()));
        this.setIncludeCommented(properties.getBooleanProperty(PROPERTY_INCLUDE_COMMENTED, this.getSearchPreferences().isIncludeCommented().booleanValue()));
        this.setFindOptimisationEnabled(properties.getBooleanProperty(PROPERTY_FIND_OPTIMISATION, this.findOptimisationEnabled));
        this.setLookUnderMasks(properties.getProperty(PROPERTY_LOOK_UNDER_MASKS, this.getSearchPreferences().getLookUnderMasks()));
        this.setUseCurrentSimulinkModel(properties.getBooleanProperty(PROPERTY_CURRENT_SIMULINK_MODEL, false));
        this.load();
    }

    public void simulate() throws InterruptedException {
        String name = this.getFile().getName().substring(0, this.getFile().getName().lastIndexOf("."));
        try {
            this.engine.evalAsync("simout = sim('" + name + "', []);").get();
        }
        catch (ExecutionException | MatlabException e) {
            e.printStackTrace();
        }
    }

    public boolean hasType(String type) {
        return true;
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof ISimulinkModelElement) {
            return ((ISimulinkModelElement)instance).getType();
        }
        return instance.getClass().getSimpleName().replace(SIMULINK, "");
    }

    public Object getElementById(String id) {
        return null;
    }

    public void setElementId(Object instance, String newId) {
    }

    public String getElementId(Object instance) {
        try {
            return (String)this.propertyGetter.invoke(instance, "id", null);
        }
        catch (EolRuntimeException eolRuntimeException) {
            return "";
        }
    }

    public boolean owns(Object instance) {
        if (instance == null) {
            return false;
        }
        return instance instanceof ISimulinkModelElement && ((ISimulinkModelElement)instance).getOwningModel() == this || instance instanceof SimulinkModel || super.owns(instance);
    }

    public boolean store(String location) {
        try {
            this.engine.eval(SAVE_SYSTEM, new Object[]{this.getSimulinkModelName(), location});
            this.engine.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean store() {
        this.store(this.file.getAbsolutePath());
        return true;
    }

    public boolean isInstantiable(String type) {
        return this.hasType(type) || super.isInstantiable(type);
    }

    public String getSimulinkModelName() {
        return this.simulinkModelName;
    }

    protected void setSimulinkModelName(String name) {
        this.simulinkModelName = name;
    }

    protected void setSimulinkModelName(File name) {
        this.simulinkModelName = FileUtil.getFileName((String)this.file.getName(), (boolean)false);
    }

    public OperationContributor getOperationContributor() {
        return this.simulinkOperationContributor;
    }

    public Double getHandle() {
        return this.handle;
    }

    public boolean isUseCurrentSimulinkModel() {
        return this.useCurrentSimulinkModel;
    }

    public void setUseCurrentSimulinkModel(boolean useCurrentSimulinkModel) {
        this.useCurrentSimulinkModel = useCurrentSimulinkModel;
    }

    @Deprecated
    public void setShowInMatlabEditor(boolean openMatlabEditor) {
        this.showInMatlabEditor = openMatlabEditor;
    }

    @Deprecated
    public boolean isShowInMatlabEditor() {
        return this.showInMatlabEditor;
    }

    public SearchPreferences getSearchPreferences() {
        return this.searchPreferences;
    }

    public void setSearchPreferences(SearchPreferences searchPreferences) {
        this.searchPreferences = searchPreferences;
    }

    public boolean isFollowLinks() {
        return this.searchPreferences.isFollowLinks();
    }

    public void setFollowLinks(boolean followLinks) {
        this.searchPreferences.setFollowLinks(followLinks);
    }

    public String getLookUnderMasks() {
        return this.searchPreferences.getLookUnderMasks();
    }

    public void setLookUnderMasks(String lookUnderMasks) {
        this.searchPreferences.setLookUnderMasks(lookUnderMasks);
    }

    public boolean isIncludeCommented() {
        return this.searchPreferences.isIncludeCommented();
    }

    public void setIncludeCommented(boolean includeCommented) {
        this.searchPreferences.setIncludeCommented(includeCommented);
    }

    public boolean isFindOptimisationEnabled() {
        return this.findOptimisationEnabled;
    }

    public void setFindOptimisationEnabled(boolean enabled) {
        this.findOptimisationEnabled = enabled;
    }

    public Collection<ISimulinkModelElement> getChildren() throws MatlabException {
        return SimulinkUtil.findBlocks(this, 1);
    }

    public Collection<ISimulinkModelElement> findBlocks() throws MatlabException {
        return SimulinkUtil.findBlocks(this, 1);
    }

    public Collection<ISimulinkModelElement> findBlocks(Integer depth) throws MatlabException {
        return SimulinkUtil.findBlocks(this, depth);
    }
}

